/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jivesoftware.smack.OpenTrustManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class SSLXMPPConnection
extends XMPPConnection {
    private static SocketFactory socketFactory = new DummySSLSocketFactory();

    public SSLXMPPConnection(String host) throws XMPPException {
        this(host, 5223);
    }

    public SSLXMPPConnection(String host, int port) throws XMPPException {
        this(host, port, host);
    }

    public SSLXMPPConnection(String host, int port, String serviceName) throws XMPPException {
        super(host, port, serviceName, socketFactory);
    }

    public boolean isSecureConnection() {
        return true;
    }

    private static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public DummySSLSocketFactory() {
            try {
                SSLContext sslcontent = SSLContext.getInstance("TLS");
                sslcontent.init(null, new TrustManager[]{new OpenTrustManager()}, new SecureRandom());
                this.factory = sslcontent.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }

        public static SocketFactory getDefault() {
            return new DummySSLSocketFactory();
        }

        public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
            return this.factory.createSocket(socket, s, i, flag);
        }

        public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr2, int j) throws IOException {
            return this.factory.createSocket(inaddr, i, inaddr2, j);
        }

        public Socket createSocket(InetAddress inaddr, int i) throws IOException {
            return this.factory.createSocket(inaddr, i);
        }

        public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
            return this.factory.createSocket(s, i, inaddr, j);
        }

        public Socket createSocket(String s, int i) throws IOException {
            return this.factory.createSocket(s, i);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

