/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosdrx;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import javax.oss.fm.monitor.NotifyAckStateChangedEvent;
import javax.oss.fm.monitor.NotifyAlarmCommentsEvent;
import javax.oss.fm.monitor.NotifyAlarmListRebuiltEvent;
import javax.oss.fm.monitor.NotifyChangedAlarmEvent;
import javax.oss.fm.monitor.NotifyClearedAlarmEvent;
import javax.oss.fm.monitor.NotifyNewAlarmEvent;
import javax.oss.util.IRPEvent;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsNode;
import org.openoss.opennms.spring.dao.OnmsAlarmOssjMapper;
import org.openoss.opennms.spring.dao.OssDaoOpenNMSImpl;
import org.openoss.opennms.spring.qosdrx.QoSDrx;
import org.openoss.ossj.fm.monitor.spring.AlarmEventReceiverEventHandler;
import org.openoss.ossj.fm.monitor.spring.OssBeanAlarmEventReceiver;

public class QoSDrxAlarmEventReceiverEventHandlerImpl2
implements AlarmEventReceiverEventHandler {
    private static final String LOG4J_CATEGORY = "OpenOSS.QoSDrx";
    private static boolean initialised = false;
    public static int SPECIFY_OUTSTATION = 1;
    public static int USE_TYPE_INSTANCE = 2;
    private static Integer almUpdateBehaviour = null;
    private String alarmUpdateBehaviour = null;
    private static AssetRecordDao _assetRecordDao;
    private static NodeDao _nodeDao;
    private static AlarmDao _alarmDao;
    private static DistPollerDao distPollerDao;
    private static OssDaoOpenNMSImpl ossDao;
    private static OnmsAlarmOssjMapper onmsAlarmOssjMapper;

    private static Logger getLog() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return (Logger)ThreadCategory.getInstance(QoSDrx.class);
    }

    public void setalarmUpdateBehaviour(String _alarmUpdateBehaviour) {
        if (_alarmUpdateBehaviour == null) {
            throw new IllegalArgumentException("QoSDrxAlarmEventReceiverEventHandlerImpl().setalarmUpdateBehaviour(): Null value for alarmUpdateBehaviour");
        }
        this.alarmUpdateBehaviour = _alarmUpdateBehaviour;
        if (_alarmUpdateBehaviour.equals("USE_TYPE_INSTANCE")) {
            almUpdateBehaviour = USE_TYPE_INSTANCE;
            return;
        }
        if (_alarmUpdateBehaviour.equals("SPECIFY_OUTSTATION")) {
            almUpdateBehaviour = SPECIFY_OUTSTATION;
            return;
        }
        throw new IllegalArgumentException("QoSDrxAlarmEventReceiverEventHandlerImpl().setalarmUpdateBehaviour(): Unknown value for alarmUpdateBehaviour:" + _alarmUpdateBehaviour);
    }

    public void setassetRecordDao(AssetRecordDao ar) {
        _assetRecordDao = ar;
    }

    public void setnodeDao(NodeDao nodedao) {
        _nodeDao = nodedao;
    }

    public void setalarmDao(AlarmDao alarmDao) {
        _alarmDao = alarmDao;
    }

    public void setdistPollerDao(DistPollerDao _distPollerDao) {
        distPollerDao = _distPollerDao;
    }

    public void setossDao(OssDaoOpenNMSImpl _ossDao) {
        ossDao = _ossDao;
    }

    public void setOnmsAlarmOssjMapper(OnmsAlarmOssjMapper onmsAlarmOssjMapper) {
        QoSDrxAlarmEventReceiverEventHandlerImpl2.onmsAlarmOssjMapper = onmsAlarmOssjMapper;
    }

    public synchronized void init() {
        if (initialised) {
            return;
        }
        try {
            ossDao.init();
            initialised = true;
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex, this.getClass().getSimpleName() + "init() problem initialising class");
        }
    }

    public void onNotifyNewAlarmEvent(NotifyNewAlarmEvent nnae, OssBeanAlarmEventReceiver callingAer) {
        block35: {
            Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
            String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyNewAlarmEvent(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
            }
            if (!initialised) {
                log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
                return;
            }
            try {
                String applicationDN;
                String ossPrimaryKey;
                OnmsAlarm alarm;
                block36: {
                    Integer onmsseverity;
                    alarm = null;
                    ossPrimaryKey = nnae.getAlarmKey().getAlarmPrimaryKey();
                    applicationDN = nnae.getAlarmKey().getApplicationDN();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Received an onNotifyNewAlarmEvent() - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " eventtime: " + nnae.getEventTime()));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ":Using this OssDao (toString):" + ossDao.toString()));
                    }
                    if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                        log.error((Object)(logheader + " ApplicatioDN or PrimaryKey not set"));
                        break block35;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Creating new alarm"));
                    }
                    alarm = new OnmsAlarm();
                    alarm.setUei(onmsAlarmOssjMapper.ossjAlarmTypeToUei(nnae.getAlarmType()));
                    alarm.setX733AlarmType(nnae.getAlarmType() == null ? "" : nnae.getAlarmType());
                    alarm.setX733ProbableCause((int)nnae.getProbableCause());
                    alarm.setTTicketState(new Integer(0));
                    alarm.setTTicketId("");
                    alarm.setQosAlarmState("external_type");
                    alarm.setSuppressedUser("");
                    alarm.setSuppressedUntil(new Date());
                    alarm.setSuppressedTime(new Date());
                    try {
                        onmsseverity = onmsAlarmOssjMapper.ossjSeveritytoOnmsSeverity(nnae.getPerceivedSeverity());
                    }
                    catch (IllegalArgumentException iae) {
                        log.error((Object)(logheader + " problem setting severity used default:'WARNING'. Exception:" + iae));
                        onmsseverity = new Integer(4);
                    }
                    alarm.setSeverity(onmsseverity);
                    alarm.setReductionKey(":managedObjectInstance:" + nnae.getManagedObjectInstance() + ":managedObjectType:" + nnae.getManagedObjectClass() + ":ossPrimaryKey:-" + ossPrimaryKey + ":applicationDN:-" + applicationDN);
                    alarm.setOssPrimaryKey(ossPrimaryKey);
                    alarm.setOperInstruct(nnae.getProposedRepairActions());
                    OnmsNode node = new OnmsNode();
                    node.setId(new Integer(1));
                    alarm.setNode(node);
                    if (almUpdateBehaviour == null) {
                        log.error((Object)("RX:" + callingAer.getName() + ": This receiver's alarmUpdateBehaviour is not set: defaulting to update nodeID:1"));
                    } else if (callingAer.getName() == null) {
                        log.error((Object)("RX:" + callingAer.getName() + ": This receiver has no name: default alarms will update nodeID:1"));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(logheader + " alarmUpdateBehaviour:" + almUpdateBehaviour + " " + this.alarmUpdateBehaviour));
                        }
                        if (almUpdateBehaviour.equals(SPECIFY_OUTSTATION)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(logheader + " SPECIFY_OUTSTATION looking for node with nodelabel:" + callingAer.getName()));
                            }
                            try {
                                try {
                                    node = ossDao.findNodeByLabel(callingAer.getName());
                                }
                                catch (Exception ex) {
                                    log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node " + ex));
                                }
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE FOUND for this RX Name:" + callingAer.getName() + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId()));
                                    }
                                    alarm.setNode(node);
                                    break block36;
                                }
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE NOT FOUND for this RX Name:" + callingAer.getName() + " setting node id to default NodeID: 1"));
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                alarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex));
                            }
                        } else if (almUpdateBehaviour.equals(USE_TYPE_INSTANCE)) {
                            String managedObjectType = nnae.getManagedObjectClass();
                            String managedObjectInstance = nnae.getManagedObjectInstance();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(logheader + " USE_TYPE_INSTANCE looking for node with managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance));
                            }
                            try {
                                node = ossDao.findNodeByInstanceAndType(managedObjectInstance, managedObjectType);
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE FOUND for this RX Name:" + callingAer.getName() + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId()));
                                    }
                                    alarm.setNode(node);
                                    break block36;
                                }
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE NOT FOUND for this managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance + " setting node id to default NodeID: 1"));
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                alarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex));
                            }
                        } else {
                            log.error((Object)(logheader + " Invalid value for alarmUpdateBehaviour:" + almUpdateBehaviour + " " + this.alarmUpdateBehaviour + " defaulting to update nodeID:1"));
                        }
                    }
                }
                alarm.setMouseOverText("");
                alarm.setManagedObjectType(nnae.getManagedObjectClass());
                alarm.setManagedObjectInstance(nnae.getManagedObjectInstance());
                alarm.setLogMsg(nnae.getSpecificProblem());
                alarm.setIpAddr("localhost");
                alarm.setId(null);
                alarm.setFirstEventTime(nnae.getEventTime());
                alarm.setLastEventTime(nnae.getEventTime());
                alarm.setDistPoller((OnmsDistPoller)distPollerDao.get((Serializable)((Object)"localhost")));
                alarm.setDescription(nnae.getAdditionalText());
                alarm.setCounter(new Integer(1));
                alarm.setClearUei("");
                alarm.setApplicationDN(applicationDN);
                alarm.setAlarmType(new Integer(1));
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Creating Alarm: "));
                    }
                    OnmsAlarm updatedAlarm = ossDao.addCurrentAlarmForUniqueKey(alarm);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Created alarm:" + ossDao.alarmToString(updatedAlarm)));
                    }
                }
                catch (Exception ex) {
                    log.error((Object)(logheader + ": problem creating new alarm AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + ": " + ex));
                }
            }
            catch (Exception e) {
                log.error((Object)(logheader + " Error : "), (Throwable)e);
            }
        }
    }

    public void onNotifyClearedAlarmEvent(NotifyClearedAlarmEvent nclae, OssBeanAlarmEventReceiver callingAer) {
        block14: {
            Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
            String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyClearedAlarmEvent(): ";
            if (log.isDebugEnabled()) {
                log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
            }
            if (!initialised) {
                log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
                return;
            }
            try {
                OnmsAlarm alarm = null;
                String ossPrimaryKey = nclae.getAlarmKey().getAlarmPrimaryKey();
                String applicationDN = nclae.getAlarmKey().getApplicationDN();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": Received an onNotifyClearedAlarmEvent() - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " eventtime: " + nclae.getEventTime()));
                }
                if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                    log.error((Object)(logheader + " ApplicatioDN or PrimaryKey not set"));
                    break block14;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": trying to find existing alarm using getCurrentAlarmForUniqueKey"));
                }
                if ((alarm = ossDao.getCurrentAlarmForUniqueKey(applicationDN, ossPrimaryKey)) == null) {
                    log.info((Object)(logheader + "WARNING Alarm does not exist with this Unique ID:- AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN));
                    break block14;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": found alarm alarmID:" + alarm.getId()));
                }
                alarm.setSeverity(Integer.valueOf(2));
                alarm.setLastEventTime(nclae.getEventTime());
                alarm.setAlarmAckUser("ossjclearevent");
                alarm.setAlarmAckTime(new Date());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Alarm before update:" + ossDao.alarmToString(alarm)));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Updating Alarm using ossDao.updateCurrentAlarmForUniqueKey"));
                    }
                    OnmsAlarm updatedAlarm = ossDao.updateCurrentAlarmForUniqueKey(alarm);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": Updated alarm:" + ossDao.alarmToString(updatedAlarm)));
                    }
                }
                catch (Exception ex) {
                    log.error((Object)(logheader + ": problem clearing new alarm AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + ": " + ex));
                }
            }
            catch (Exception e) {
                log.error((Object)(logheader + " Error : "), (Throwable)e);
            }
        }
    }

    public void onNotifyAckStateChangedEvent(NotifyAckStateChangedEvent nasce, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAckStateChangedEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }

    public void onNotifyAlarmCommentsEvent(NotifyAlarmCommentsEvent nace, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAlarmCommentsEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }

    public void onNotifyAlarmListRebuiltEvent(NotifyAlarmListRebuiltEvent nalre, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAlarmListRebuiltEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }

    public void onNotifyChangedAlarmEvent(NotifyChangedAlarmEvent nchae, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyChangedAlarmEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }

    public void onUnknownIRPEvt(IRPEvent irpevt, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onUnknownIRPEvt(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }

    public void onunknownObjectMessage(Object objectMessage, OssBeanAlarmEventReceiver callingAer) {
        Logger log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onunknownObjectMessage(): ";
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics()));
        }
        if (!initialised) {
            log.error((Object)(logheader + "event handler not initialised. init() must be called by receiver before handling any events"));
            return;
        }
    }
}

