/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.dao;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.openoss.opennms.spring.qosd.QoSD;
import org.openoss.opennms.spring.qosdrx.QoSDrx;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class OssDaoOpenNMSImpl {
    private static final String LOG4J_CATEGORY = "OpenOSS.QoSDrx";
    private Hashtable<Integer, OnmsAlarm> alarmCacheByID = new Hashtable();
    private Hashtable<String, OnmsAlarm> alarmCacheByUniqueKey = new Hashtable();
    private Hashtable<Integer, OnmsNode> nodeCacheByID = new Hashtable();
    private Hashtable<String, OnmsNode> nodeCacheByLabel = new Hashtable();
    private Hashtable<String, OnmsNode> nodeCacheByUniqueID = new Hashtable();
    protected static DataSource _dataSource;
    protected static AssetRecordDao _assetRecordDao;
    protected static NodeDao _nodeDao;
    protected static AlarmDao _alarmDao;
    protected static TransactionTemplate transTemplate;
    private static QoSD qoSD;
    private boolean initialised = false;

    private static Logger getLog() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return (Logger)ThreadCategory.getInstance(QoSDrx.class);
    }

    public void setdataSource(DataSource dataSource) {
        _dataSource = dataSource;
    }

    public void setassetRecordDao(AssetRecordDao ar) {
        _assetRecordDao = ar;
    }

    public void setnodeDao(NodeDao nodedao) {
        _nodeDao = nodedao;
    }

    public void setalarmDao(AlarmDao alarmDao) {
        _alarmDao = alarmDao;
    }

    public void setTransTemplate(TransactionTemplate _transTemplate) {
        transTemplate = _transTemplate;
    }

    public void setQoSD(QoSD _qoSD) {
        qoSD = _qoSD;
    }

    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        try {
            this.localUpdateNodeCaches();
            this.localUpdateAlarmCache();
            this.initialised = true;
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex, this.getClass().getSimpleName() + "init() problem initialising class");
        }
    }

    public synchronized OnmsAlarm addCurrentAlarmForUniqueKey(final OnmsAlarm alarm) {
        block12: {
            Logger log = OssDaoOpenNMSImpl.getLog();
            if (alarm == null || alarm.getId() != null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm==null or alarmID!=null");
            }
            if (alarm.getAlarmType() != 1) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm.getAlarmType() not 'raise' alarm type '1'");
            }
            if (alarm.getApplicationDN() == null || alarm.getApplicationDN().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
            }
            if (alarm.getOssPrimaryKey() == null || alarm.getOssPrimaryKey().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
            }
            OnmsAlarm checkAlarm = this.getCurrentAlarmForUniqueKey(alarm.getApplicationDN(), alarm.getOssPrimaryKey());
            if (checkAlarm != null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm not unique in Current Alarm list: ApplicationDN:" + alarm.getApplicationDN() + " OssPrimaryKey:" + alarm.getOssPrimaryKey());
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): ALARM TO SAVE:\n" + this.alarmToString(alarm)));
                }
                String uniqueKey = alarm.getApplicationDN() + alarm.getOssPrimaryKey();
                transTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        _alarmDao.save((Object)alarm);
                        return null;
                    }
                });
                this.alarmCacheByID.put(new Integer(alarm.getId()), alarm);
                this.alarmCacheByUniqueKey.put(uniqueKey, alarm);
            }
            catch (Exception ex) {
                log.error((Object)"OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey():Error creating alarm in database:", (Throwable)ex);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): ALARM SAVED" + this.alarmToStringBrief(alarm)));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Sending Updated alarm list to QoSD");
                }
                this.sendAlarms();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block12;
                log.debug((Object)("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): problem sending alarm to QoSD ( QoSD may not be running ):" + e));
            }
        }
        return alarm;
    }

    public synchronized OnmsAlarm updateCurrentAlarmForUniqueKey(final OnmsAlarm alarm) {
        block13: {
            Logger log = OssDaoOpenNMSImpl.getLog();
            if (alarm == null || alarm.getId() == null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm==null or alarmID==null");
            }
            if (alarm.getAlarmType() != 1) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm.getAlarmType() not 'raise' alarm type '1'");
            }
            if (alarm.getApplicationDN() == null || alarm.getApplicationDN().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
            }
            if (alarm.getOssPrimaryKey() == null || alarm.getOssPrimaryKey().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
            }
            String uniqueKey = alarm.getApplicationDN() + alarm.getOssPrimaryKey();
            OnmsAlarm updateAlarm = this.getCurrentAlarmForUniqueKey(alarm.getApplicationDN(), alarm.getOssPrimaryKey());
            if (updateAlarm != null) {
                alarm.setId(updateAlarm.getId());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: alarm to update in database" + this.alarmToStringBrief(alarm)));
                    }
                    transTemplate.execute(new TransactionCallback(){

                        public Object doInTransaction(TransactionStatus status) {
                            _alarmDao.update((Object)alarm);
                            return null;
                        }
                    });
                    this.alarmCacheByID.put(new Integer(alarm.getId()), alarm);
                    this.alarmCacheByUniqueKey.put(uniqueKey, alarm);
                }
                catch (Exception ex) {
                    log.error((Object)"OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey():Error updating alarm in database:", (Throwable)ex);
                    return null;
                }
            } else {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm not found in Current Alarm list: ApplicationDN:" + alarm.getApplicationDN() + " OssPrimaryKey:" + alarm.getOssPrimaryKey());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: Sending Updated alarm list Updated alarm" + this.alarmToStringBrief(alarm)));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: Sending Updated alarm list to QoSD");
                }
                this.sendAlarms();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block13;
                log.debug((Object)("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: problem sending alarm to  QoSD:" + e));
            }
        }
        return alarm;
    }

    public synchronized OnmsAlarm getCurrentAlarmForUniqueKey(String applicationDN, String ossPrimaryKey) {
        Logger log = OssDaoOpenNMSImpl.getLog();
        if (applicationDN == null || applicationDN.equals("")) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
        }
        if (ossPrimaryKey == null || ossPrimaryKey.equals("")) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
        }
        OnmsAlarm alarm = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey: checking if alarm is in local alarm cache alarmCacheByID");
            }
            alarm = this.searchAlarmCacheForUniqueKey(applicationDN, ossPrimaryKey);
        }
        catch (Exception ex) {
            log.error((Object)"\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey ERROR : ", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey: alarm result =" + this.alarmToStringBrief(alarm)));
        }
        return alarm;
    }

    private void localUpdateAlarmCache() {
        transTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                OssDaoOpenNMSImpl.this.localUpdateAlarmCacheTransaction();
                return null;
            }
        });
    }

    private void localUpdateAlarmCacheTransaction() {
        Logger log = OssDaoOpenNMSImpl.getLog();
        List c = _alarmDao.findAll();
        this.alarmCacheByID = new Hashtable();
        this.alarmCacheByUniqueKey = new Hashtable();
        OnmsAlarm[] alarms = c.toArray(new OnmsAlarm[c.size()]);
        for (int i = 0; i < alarms.length; ++i) {
            OnmsAlarm newalarm = alarms[i];
            newalarm.getNode().getLabel();
            this.alarmCacheByID.put(new Integer(newalarm.getId()), newalarm);
            if (newalarm.getApplicationDN() == null || newalarm.getOssPrimaryKey() == null || newalarm.getApplicationDN().equals("") || newalarm.getOssPrimaryKey().equals("")) continue;
            String uniqueKey = newalarm.getApplicationDN() + newalarm.getOssPrimaryKey();
            if (this.alarmCacheByUniqueKey.get(uniqueKey) == null) {
                this.alarmCacheByUniqueKey.put(uniqueKey, newalarm);
                continue;
            }
            log.error((Object)("\tOssDaoOpenNMSImpl().localUpdateAlarmCache(): ERROR - duplicate alarm uniqueKey in database =" + uniqueKey + " AlarmID:" + newalarm.getId()));
        }
    }

    public synchronized void updateAlarmCache() throws IllegalStateException {
        this.localUpdateAlarmCache();
    }

    public synchronized void updateAlarmCacheAndSendAlarms() throws IllegalStateException {
        this.localUpdateAlarmCache();
        this.sendAlarms();
    }

    public OnmsAlarm[] getAlarmCache() {
        OnmsAlarm[] returnAlarmCache = new OnmsAlarm[this.alarmCacheByID.size()];
        int i = 0;
        Enumeration<Integer> alarmIDS = this.alarmCacheByID.keys();
        while (alarmIDS.hasMoreElements()) {
            Integer alarmID = alarmIDS.nextElement();
            returnAlarmCache[i] = this.alarmCacheByID.get(alarmID);
            ++i;
        }
        return returnAlarmCache;
    }

    private void sendAlarms() {
        Logger log = OssDaoOpenNMSImpl.getLog();
        if (qoSD != null) {
            try {
                qoSD.sendAlarms();
            }
            catch (Exception ex) {
                log.error((Object)"\tOssDaoOpenNMSImpl().sendAlarms() Problem calling back to qoSD:", (Throwable)ex);
                throw new IllegalStateException("OssDaoOpenNMSImpl().sendAlarms() Problem calling back to qoSD:", ex);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"\tOssDaoOpenNMSImpl().sendAlarms(): QoSD not running - not calling back QoSD to send alarms");
        }
    }

    private OnmsAlarm searchAlarmCacheForUniqueKey(String applicationDN, String ossPrimaryKey) {
        Logger log = OssDaoOpenNMSImpl.getLog();
        String uniqueKey = applicationDN + ossPrimaryKey;
        OnmsAlarm alarm = this.alarmCacheByUniqueKey.get(uniqueKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\tOssDaoOpenNMSImpl().searchAlarmBufForUniqueKey alarmCacheByID search result:" + this.alarmToStringBrief(alarm)));
        }
        return alarm;
    }

    public String alarmToStringBrief(OnmsAlarm alarm) {
        String s = alarm == null ? "\n\t\tOnmsAlarm is Null" : "\n\t\tapplicationDN \t" + alarm.getApplicationDN() + "\t\tossPrimaryKey \t" + alarm.getOssPrimaryKey() + "\t\talarmID " + alarm.getId() + "\t\tSeverity():" + alarm.getSeverity() + "\t\tAlarmAckUser():" + alarm.getAlarmAckUser() + "\t\tAlarmAckTime():" + alarm.getAlarmAckTime();
        return s;
    }

    public String alarmToString(OnmsAlarm alarm) {
        String s = alarm == null ? "\n\t\tOnmsAlarm is Null" : "\n\t\teventUei \t" + alarm.getUei() + "\n" + "\t\tdpName \t" + (alarm.getDistPoller() == null ? null : alarm.getDistPoller().getName()) + "\n" + "\t\tnodeID \t" + (alarm.getNode() == null ? null : alarm.getNode().getId()) + "\n" + "\t\tipaddr \t" + alarm.getIpAddr() + "\n" + "\t\tserviceID \t" + (alarm.getServiceType() == null ? null : alarm.getServiceType().getId()) + "\n" + "\t\treductionKey \t" + alarm.getReductionKey() + "\n" + "\t\talarmType \t" + alarm.getAlarmType() + "\n" + "\t\tcounter \t" + alarm.getCounter() + "\n" + "\t\tseverity \t" + alarm.getSeverity() + "\n" + "\t\tlastEventID \t" + (alarm.getLastEvent() == null ? null : alarm.getLastEvent().getId()) + "\n" + "\t\tfirstEventTime \t" + alarm.getFirstEventTime() + "\n" + "\t\tlastEventTime \t" + alarm.getLastEventTime() + "\n" + "\t\tdescription \t" + alarm.getDescription() + "\n" + "\t\tlogMsg \t" + alarm.getLogMsg() + "\n" + "\t\toperInstruct \t" + alarm.getOperInstruct() + "\n" + "\t\ttticketID \t" + alarm.getTTicketId() + "\n" + "\t\ttticketState \t" + alarm.getTTicketState() + "\n" + "\t\tmouseOverText \t" + alarm.getMouseOverText() + "\n" + "\t\tsuppressedUntil \t" + alarm.getSuppressedUntil() + "\n" + "\t\tsuppressedUser \t" + alarm.getSuppressedUser() + "\n" + "\t\tsuppressedTime \t" + alarm.getSuppressedTime() + "\n" + "\t\talarmAckUser \t" + alarm.getAlarmAckUser() + "\n" + "\t\talarmAckTime \t" + alarm.getAlarmAckTime() + "\n" + "\t\tclearUei   \t" + alarm.getClearUei() + "\n" + "\t\tmanagedObjectInstance \t" + alarm.getManagedObjectInstance() + "\n" + "\t\tmanagedObjectType \t" + alarm.getManagedObjectType() + "\n" + "\t\tapplicationDN \t" + alarm.getApplicationDN() + "\n" + "\t\tossPrimaryKey \t" + alarm.getOssPrimaryKey() + "\n" + "\t\talarmID \t" + alarm.getId() + "\t\tqosAlarmState \t" + alarm.getQosAlarmState();
        return s;
    }

    public OnmsNode findNodeByLabel(String label) {
        Logger log = OssDaoOpenNMSImpl.getLog();
        if (label == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByLabel: Illegal value: label null or empty ");
        }
        OnmsNode node = null;
        try {
            node = this.nodeCacheByLabel.get(label);
        }
        catch (Exception ex) {
            log.error((Object)"\tOssDaoOpenNMSImpl().findNodeByLabel ERROR : ", (Throwable)ex);
        }
        return node;
    }

    public OnmsNode findNodeByInstanceAndType(String managedObjectInstance, String managedObjectType) throws IllegalArgumentException {
        Logger log = OssDaoOpenNMSImpl.getLog();
        if (managedObjectInstance == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByInstanceType: Illegal value: managedObjectInstance null");
        }
        if (managedObjectType == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByInstanceType: Illegal value: label managedObjectType null");
        }
        String uniqueid = managedObjectInstance + managedObjectType;
        OnmsNode node = null;
        try {
            node = this.nodeCacheByUniqueID.get(uniqueid);
        }
        catch (Exception ex) {
            log.error((Object)"\tOssDaoOpenNMSImpl().findNodeByInstanceAndType ERROR : ", (Throwable)ex);
        }
        return node;
    }

    public OnmsNode findNodeByID(Integer nodeid) {
        Logger log = OssDaoOpenNMSImpl.getLog();
        if (nodeid == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByLabel: Illegal value: nodeid null or empty ");
        }
        OnmsNode node = null;
        try {
            node = this.nodeCacheByID.get(nodeid);
        }
        catch (Exception ex) {
            log.error((Object)"\tOssDaoOpenNMSImpl().findNodeByLabel ERROR : ", (Throwable)ex);
        }
        return node;
    }

    public synchronized void updateNodeCaches() {
        this.localUpdateNodeCaches();
    }

    private void localUpdateNodeCaches() {
        block22: {
            Logger log = OssDaoOpenNMSImpl.getLog();
            try {
                OnmsNode node;
                this.nodeCacheByID = new Hashtable();
                this.nodeCacheByLabel = new Hashtable();
                this.nodeCacheByUniqueID = new Hashtable();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches - Updating Node Caches :");
                }
                List c = _nodeDao.findAll();
                OnmsNode[] nodelist = c.toArray(new OnmsNode[c.size()]);
                for (int i = 0; i < nodelist.length; ++i) {
                    OnmsNode node2 = nodelist[i];
                    try {
                        this.nodeCacheByID.put(node2.getId(), node2);
                        if (node2.getLabel() != null) {
                            if (this.nodeCacheByLabel.get(node2.getLabel()) != null) {
                                log.info((Object)("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " Node Label:" + node2.getId() + " is duplicated"));
                            } else {
                                this.nodeCacheByLabel.put(node2.getLabel(), node2);
                            }
                        } else {
                            log.info((Object)("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " Node Label is Not putting node in nodeCacheByLabel"));
                        }
                        OnmsAssetRecord assetRecord = node2.getAssetRecord();
                        if (assetRecord == null) {
                            log.info((Object)("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " assetRecord is NULL. Not putting node in nodeCacheByUniqueID"));
                            continue;
                        }
                        if (assetRecord.getManagedObjectInstance() == null || assetRecord.getManagedObjectType() == null) {
                            log.info((Object)("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " ManagedObjectInstance and/or ManagedObjectType are NULL. Not putting node in nodeCacheByUniqueID"));
                            continue;
                        }
                        String uniqueid = assetRecord.getManagedObjectInstance() + assetRecord.getManagedObjectType();
                        if (this.nodeCacheByUniqueID.get(uniqueid) != null) {
                            log.info((Object)("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + "Unique ID is duplicated. Unique ID = ManagedObjectInstance:" + assetRecord.getManagedObjectInstance() + "+ ManagedObjectType:" + assetRecord.getManagedObjectType()));
                            continue;
                        }
                        this.nodeCacheByUniqueID.put(uniqueid, node2);
                        continue;
                    }
                    catch (Exception ex) {
                        log.error((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches Error updating node caches: ERROR : ", (Throwable)ex);
                    }
                }
                if (!log.isDebugEnabled()) break block22;
                log.debug((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByID : contents :");
                try {
                    Enumeration<Integer> nodeIDs = this.nodeCacheByID.keys();
                    while (nodeIDs.hasMoreElements()) {
                        Integer id = nodeIDs.nextElement();
                        node = this.nodeCacheByID.get(id);
                        log.debug((Object)("\t\tKey: Node ID:" + id + "\tNodeLabel:" + node.getLabel()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByLabel contents Error:", (Throwable)e);
                }
                log.debug((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByLabel : contents :");
                try {
                    Enumeration<String> nodelabels = this.nodeCacheByLabel.keys();
                    while (nodelabels.hasMoreElements()) {
                        String label = nodelabels.nextElement();
                        node = this.nodeCacheByLabel.get(label);
                        log.debug((Object)("\t\tKey: Label:" + label + "\tNodeID:" + node.getId()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByLabel contents. Error:", (Throwable)e);
                }
                try {
                    log.debug((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByUniqueID : contents :");
                    Enumeration<String> uniqueids = this.nodeCacheByUniqueID.keys();
                    while (uniqueids.hasMoreElements()) {
                        String uniqueID = uniqueids.nextElement();
                        node = this.nodeCacheByUniqueID.get(uniqueID);
                        log.debug((Object)("\t\tKey: uniqueID:" + uniqueID + "\tNodeID:" + node.getId()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByUniqueID contents Error:", (Throwable)e);
                }
            }
            catch (Exception ex) {
                log.error((Object)"\tOssDaoOpenNMSImpl().updateNodeCaches ERROR : ", (Throwable)ex);
            }
        }
    }

    static {
        qoSD = null;
    }
}

