/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBeanDefinition
extends AttributeAccessorSupport
implements BeanDefinition {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    public static final int AUTOWIRE_AUTODETECT = 4;
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    private Object beanClass;
    private String scope = "singleton";
    private boolean abstractFlag = false;
    private boolean lazyInit = false;
    private boolean autowireCandidate = true;
    private int autowireMode = 0;
    private int dependencyCheck = 0;
    private String[] dependsOn;
    private ConstructorArgumentValues constructorArgumentValues;
    private MutablePropertyValues propertyValues;
    private MethodOverrides methodOverrides = new MethodOverrides();
    private String factoryBeanName;
    private String factoryMethodName;
    private String initMethodName;
    private String destroyMethodName;
    private boolean enforceInitMethod = true;
    private boolean enforceDestroyMethod = true;
    private boolean synthetic = false;
    private String resourceDescription;
    private Object source;
    private int role = 0;

    protected AbstractBeanDefinition() {
        this(null, null);
    }

    protected AbstractBeanDefinition(ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        this.setConstructorArgumentValues(cargs);
        this.setPropertyValues(pvs);
    }

    protected AbstractBeanDefinition(AbstractBeanDefinition original) {
        this.beanClass = original.beanClass;
        this.setScope(original.getScope());
        this.setAbstract(original.isAbstract());
        this.setLazyInit(original.isLazyInit());
        this.setAutowireCandidate(original.isAutowireCandidate());
        this.setAutowireMode(original.getAutowireMode());
        this.setDependencyCheck(original.getDependencyCheck());
        this.setDependsOn(original.getDependsOn());
        this.setConstructorArgumentValues(new ConstructorArgumentValues(original.getConstructorArgumentValues()));
        this.setPropertyValues(new MutablePropertyValues(original.getPropertyValues()));
        this.setMethodOverrides(new MethodOverrides(original.getMethodOverrides()));
        this.setFactoryBeanName(original.getFactoryBeanName());
        this.setFactoryMethodName(original.getFactoryMethodName());
        this.setInitMethodName(original.getInitMethodName());
        this.setEnforceInitMethod(original.isEnforceInitMethod());
        this.setDestroyMethodName(original.getDestroyMethodName());
        this.setEnforceDestroyMethod(original.isEnforceDestroyMethod());
        this.setSynthetic(original.isSynthetic());
        this.setResourceDescription(original.getResourceDescription());
        this.setSource(original.getSource());
        this.setRole(original.getRole());
        this.copyAttributesFrom(original);
    }

    public void overrideFrom(AbstractBeanDefinition other) {
        if (other.beanClass != null) {
            this.beanClass = other.beanClass;
        }
        this.setScope(other.getScope());
        this.setAbstract(other.isAbstract());
        this.setLazyInit(other.isLazyInit());
        this.setAutowireCandidate(other.isAutowireCandidate());
        this.setAutowireMode(other.getAutowireMode());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setDependsOn(other.getDependsOn());
        this.getConstructorArgumentValues().addArgumentValues(other.getConstructorArgumentValues());
        this.getPropertyValues().addPropertyValues(other.getPropertyValues());
        this.getMethodOverrides().addOverrides(other.getMethodOverrides());
        if (other.getFactoryBeanName() != null) {
            this.setFactoryBeanName(other.getFactoryBeanName());
        }
        if (other.getFactoryMethodName() != null) {
            this.setFactoryMethodName(other.getFactoryMethodName());
        }
        if (other.getInitMethodName() != null) {
            this.setInitMethodName(other.getInitMethodName());
            this.setEnforceInitMethod(other.isEnforceInitMethod());
        }
        if (other.getDestroyMethodName() != null) {
            this.setDestroyMethodName(other.getDestroyMethodName());
            this.setEnforceDestroyMethod(other.isEnforceDestroyMethod());
        }
        this.setSynthetic(other.isSynthetic());
        this.setResourceDescription(other.getResourceDescription());
        this.setSource(other.getSource());
        this.setRole(other.getRole());
        this.copyAttributesFrom(other);
    }

    public boolean hasBeanClass() {
        return this.beanClass instanceof Class;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Class getBeanClass() throws IllegalStateException {
        if (!(this.beanClass instanceof Class)) {
            throw new IllegalStateException("Bean definition does not carry a resolved bean class");
        }
        return (Class)this.beanClass;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClass = beanClassName;
    }

    public String getBeanClassName() {
        if (this.beanClass instanceof Class) {
            return ((Class)this.beanClass).getName();
        }
        return (String)this.beanClass;
    }

    public Class resolveBeanClass(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.beanClass == null) {
            return null;
        }
        Class resolvedClass = ClassUtils.forName((String)this.getBeanClassName(), (ClassLoader)classLoader);
        this.beanClass = resolvedClass;
        return resolvedClass;
    }

    public void setScope(String scope) {
        Assert.notNull((Object)scope, (String)"Scope must not be null");
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setSingleton(boolean singleton) {
        this.scope = singleton ? "singleton" : "prototype";
    }

    public boolean isSingleton() {
        return "singleton".equals(this.scope);
    }

    public boolean isPrototype() {
        return "prototype".equals(this.scope);
    }

    public void setAbstract(boolean abstractFlag) {
        this.abstractFlag = abstractFlag;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setAutowireCandidate(boolean autowireCandidate) {
        this.autowireCandidate = autowireCandidate;
    }

    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public int getResolvedAutowireMode() {
        if (this.autowireMode == 4) {
            Constructor<?>[] constructors = this.getBeanClass().getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                return 2;
            }
            return 3;
        }
        return this.autowireMode;
    }

    public void setDependencyCheck(int dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        this.constructorArgumentValues = constructorArgumentValues != null ? constructorArgumentValues : new ConstructorArgumentValues();
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return !this.constructorArgumentValues.isEmpty();
    }

    public void setPropertyValues(MutablePropertyValues propertyValues) {
        this.propertyValues = propertyValues != null ? propertyValues : new MutablePropertyValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public void setMethodOverrides(MethodOverrides methodOverrides) {
        this.methodOverrides = methodOverrides != null ? methodOverrides : new MethodOverrides();
    }

    public MethodOverrides getMethodOverrides() {
        return this.methodOverrides;
    }

    public void setFactoryBeanName(String factoryBeanName) {
        this.factoryBeanName = factoryBeanName;
    }

    public String getFactoryBeanName() {
        return this.factoryBeanName;
    }

    public void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setEnforceInitMethod(boolean enforceInitMethod) {
        this.enforceInitMethod = enforceInitMethod;
    }

    public boolean isEnforceInitMethod() {
        return this.enforceInitMethod;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setEnforceDestroyMethod(boolean enforceDestroyMethod) {
        this.enforceDestroyMethod = enforceDestroyMethod;
    }

    public boolean isEnforceDestroyMethod() {
        return this.enforceDestroyMethod;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public int getRole() {
        return this.role;
    }

    public void validate() throws BeanDefinitionValidationException {
        if (!this.getMethodOverrides().isEmpty() && this.getFactoryMethodName() != null) {
            throw new BeanDefinitionValidationException("Cannot combine static factory method with method overrides: the static factory method must create the instance");
        }
        if (this.hasBeanClass()) {
            this.prepareMethodOverrides();
        }
    }

    public void prepareMethodOverrides() throws BeanDefinitionValidationException {
        Iterator it = this.getMethodOverrides().getOverrides().iterator();
        while (it.hasNext()) {
            MethodOverride mo = (MethodOverride)it.next();
            this.prepareMethodOverride(mo);
        }
    }

    protected void prepareMethodOverride(MethodOverride mo) throws BeanDefinitionValidationException {
        int count = ClassUtils.getMethodCountForName((Class)this.getBeanClass(), (String)mo.getMethodName());
        if (count == 0) {
            throw new BeanDefinitionValidationException("Invalid method override: no method with name '" + mo.getMethodName() + "' on class [" + this.getBeanClassName() + "]");
        }
        if (count == 1) {
            mo.setOverloaded(false);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbstractBeanDefinition) || !super.equals(other)) {
            return false;
        }
        AbstractBeanDefinition that = (AbstractBeanDefinition)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.beanClass, (Object)that.beanClass)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.scope, (Object)that.scope)) {
            return false;
        }
        if (this.abstractFlag != that.abstractFlag) {
            return false;
        }
        if (this.lazyInit != that.lazyInit) {
            return false;
        }
        if (this.autowireCandidate != that.autowireCandidate) {
            return false;
        }
        if (this.autowireMode != that.autowireMode) {
            return false;
        }
        if (this.dependencyCheck != that.dependencyCheck) {
            return false;
        }
        if (!Arrays.equals(this.dependsOn, that.dependsOn)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.constructorArgumentValues, (Object)that.constructorArgumentValues)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.propertyValues, (Object)that.propertyValues)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.methodOverrides, (Object)that.methodOverrides)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.factoryBeanName, (Object)that.factoryBeanName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.factoryMethodName, (Object)that.factoryMethodName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.initMethodName, (Object)that.initMethodName)) {
            return false;
        }
        if (this.enforceInitMethod != that.enforceInitMethod) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.destroyMethodName, (Object)that.destroyMethodName)) {
            return false;
        }
        if (this.enforceDestroyMethod != that.enforceDestroyMethod) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.resourceDescription, (Object)that.resourceDescription)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.source, (Object)that.source)) {
            return false;
        }
        return this.role == that.role;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.beanClass);
        result = 29 * result + ObjectUtils.nullSafeHashCode((Object)this.scope);
        result = 29 * result + ObjectUtils.nullSafeHashCode((Object)this.constructorArgumentValues);
        result = 29 * result + ObjectUtils.nullSafeHashCode((Object)this.propertyValues);
        result = 29 * result + ObjectUtils.nullSafeHashCode((Object)this.factoryBeanName);
        result = 29 * result + ObjectUtils.nullSafeHashCode((Object)this.factoryMethodName);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("class [");
        sb.append(this.getBeanClassName()).append("]");
        sb.append("; scope=").append(this.scope);
        sb.append("; abstract=").append(this.abstractFlag);
        sb.append("; lazyInit=").append(this.lazyInit);
        sb.append("; autowireCandidate=").append(this.autowireCandidate);
        sb.append("; autowireMode=").append(this.autowireMode);
        sb.append("; dependencyCheck=").append(this.dependencyCheck);
        sb.append("; factoryBeanName=").append(this.factoryBeanName);
        sb.append("; factoryMethodName=").append(this.factoryMethodName);
        sb.append("; initMethodName=").append(this.initMethodName);
        sb.append("; destroyMethodName=").append(this.destroyMethodName);
        if (this.resourceDescription != null) {
            sb.append("; defined in ").append(this.resourceDescription);
        }
        return sb.toString();
    }
}

