/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap {
    private static FileFilter m_dirFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static FilenameFilter m_jarFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public static ClassLoader loadClasses(String dirStr, boolean recursive) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        StringTokenizer toke = new StringTokenizer(dirStr, File.pathSeparator);
        while (toke.hasMoreTokens()) {
            String token = toke.nextToken();
            Bootstrap.loadClasses(new File(token), recursive, urls);
        }
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader loadClasses(File dir, boolean recursive) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        Bootstrap.loadClasses(dir, recursive, urls);
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader newClassLoader(LinkedList<URL> urls) {
        URL[] urlsArray = urls.toArray(new URL[0]);
        return URLClassLoader.newInstance(urlsArray);
    }

    public static void loadClasses(File dir, boolean recursive, LinkedList<URL> urls) throws MalformedURLException {
        File[] children;
        File[] dirlist;
        urls.add(dir.toURL());
        if (recursive && (dirlist = dir.listFiles(m_dirFilter)) != null) {
            for (File childDir : dirlist) {
                Bootstrap.loadClasses(childDir, recursive, urls);
            }
        }
        if ((children = dir.listFiles(m_jarFilter)) != null) {
            for (File childFile : children) {
                urls.add(childFile.toURL());
            }
        }
    }

    public static File findOpenNMSHome() {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        try {
            URL subUrl;
            String classFile = Bootstrap.class.getName().replace('.', '/') + ".class";
            URL url = l.getResource(classFile);
            if (url.getProtocol().equals("jar") && (subUrl = new URL(url.getFile())).getProtocol().equals("file")) {
                String filePath = subUrl.getFile();
                int i = filePath.lastIndexOf(33);
                File file = new File(filePath.substring(0, i));
                return file.getParentFile().getParentFile();
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        return null;
    }

    static void loadProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String propertyName = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            System.setProperty(propertyName, value.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        URL url;
        File f;
        String bootPropertiesName = "bootstrap.properties";
        String opennmsHomeProperty = "opennms.home";
        boolean propertiesLoaded = false;
        String opennmsHome = System.getProperty("opennms.home");
        if (opennmsHome != null && (f = new File(opennmsHome + File.separator + "etc" + File.separator + "bootstrap.properties")).exists()) {
            Bootstrap.loadProperties(new FileInputStream(f));
            propertiesLoaded = true;
        }
        if (!propertiesLoaded) {
            File f2;
            File parent = Bootstrap.findOpenNMSHome();
            if (parent == null) {
                System.err.println("Could not determine OpenNMS home directory.  Use \"-Dopennms.home=...\" option to Java to specify a specific OpenNMS home directory.  E.g.: \"java -Dopennms.home=... -jar ...\".");
                System.exit(1);
            }
            if ((f2 = new File(parent.getPath() + File.separator + "etc" + File.separator + "bootstrap.properties")).exists()) {
                Bootstrap.loadProperties(new FileInputStream(f2));
                propertiesLoaded = true;
            }
            System.setProperty("opennms.home", parent.getPath());
        }
        String classToExec = System.getProperty("opennms.manager.class", "org.opennms.netmgt.vmmgr.Manager");
        String classToExecMethod = "main";
        String[] classToExecArgs = args;
        String dir = System.getProperty("opennms.classpath");
        if (dir == null) {
            dir = System.getProperty("opennms.home") + File.separator + "lib" + File.pathSeparator + System.getProperty("opennms.home") + File.separator + "etc";
        }
        ClassLoader cl = Bootstrap.loadClasses(dir, false);
        if (System.getProperty("opennms.library.jicmp") == null && (url = cl.getResource(System.mapLibraryName("jicmp"))) != null) {
            System.setProperty("opennms.library.jicmp", url.getPath());
        }
        if (System.getProperty("opennms.library.jrrd") == null && (url = cl.getResource(System.mapLibraryName("jrrd"))) != null) {
            System.setProperty("opennms.library.jrrd", url.getPath());
        }
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.configuration", "log4j.properties");
        }
        if (System.getProperty("jcifs.properties") == null && (url = cl.getResource("jcifs.properties")) != null) {
            System.setProperty("jcifs.properties", url.getPath());
        }
        if (classToExec != null) {
            String className = classToExec;
            Class[] classes = new Class[]{classToExecArgs.getClass()};
            final Object[] methodArgs = new Object[]{classToExecArgs};
            Class<?> c = cl.loadClass(className);
            final Method method = c.getMethod("main", classes);
            Runnable execer = new Runnable(){

                public void run() {
                    try {
                        method.invoke(null, methodArgs);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            Thread bootstrapper = new Thread(execer, "BootStrapper");
            bootstrapper.setContextClassLoader(cl);
            bootstrapper.start();
        }
    }
}

