/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager.spi;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import javax.transaction.TransactionManager;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.spi.BaseTransactionManagerFactory;
import org.exolab.castor.util.Messages;

public class JNDIENCTransactionManagerFactory
extends BaseTransactionManagerFactory {
    private TransactionManager _transactionManager;
    private final String _name = "jndi";
    private final String TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";

    public TransactionManager getTransactionManager() throws TransactionManagerAcquireException {
        InitialContext context = null;
        Object objectFound = null;
        try {
            context = new InitialContext();
            String jndiENC = this.params.getProperty("jndiEnc", "java:comp/TransactionManager");
            objectFound = context.lookup(jndiENC);
            this._transactionManager = (TransactionManager)objectFound;
        }
        catch (ClassCastException e) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToCastToTransactionManager", objectFound.getClass().getName()), e);
        }
        catch (NoInitialContextException e) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", e.getMessage()), e);
        }
        catch (NameNotFoundException e) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", e.getMessage()), e);
        }
        catch (Exception e) {
            throw new TransactionManagerAcquireException(Messages.format("jdo.transaction.unableToAcquireTransactionManager", e.getMessage()), e);
        }
        return this._transactionManager;
    }

    public String getName() {
        return "jndi";
    }
}

