/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.SyntaxNotSupportedException;
import org.exolab.castor.jdo.oql.TokenTypes;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.QueryExpression;

public class ParseTreeWalker
implements TokenTypes {
    private LockEngine _dbEngine;
    private ParseTreeNode _parseTree;
    private String _projectionName;
    private String _projectionAlias;
    private int _projectionType;
    private String _fromClassName;
    private String _fromClassAlias;
    private ClassLoader _classLoader;
    private Class _objClass;
    private QueryExpression _queryExpr;
    private DbMetaInfo _dbInfo;
    private Hashtable _paramInfo;
    private Hashtable _fieldInfo;
    private Hashtable _pathInfo;
    private Hashtable _allPaths;
    private SQLEngine _engine;
    private JDOClassDescriptor _clsDesc;
    public static final int AGGREGATE = 1;
    public static final int FUNCTION = 2;
    public static final int PARENT_OBJECT = 3;
    public static final int DEPENDANT_OBJECT = 4;
    public static final int DEPENDANT_OBJECT_VALUE = 5;
    public static final int DEPENDANT_VALUE = 6;
    public static final int MAX_TABLE_LENGTH = 30;

    public ParseTreeWalker(LockEngine dbEngine, ParseTreeNode parseTree, ClassLoader classLoader, DbMetaInfo dbInfo) throws QueryException {
        this._dbEngine = dbEngine;
        this._parseTree = parseTree;
        this._classLoader = classLoader;
        this._dbInfo = dbInfo;
        this._paramInfo = new Hashtable();
        this._fieldInfo = new Hashtable();
        this._pathInfo = new Hashtable();
        this._allPaths = new Hashtable();
        if (!this._parseTree.isRoot()) {
            throw new QueryException("ParseTreeWalker must be created with the root node of the parse tree.");
        }
        this.checkErrors();
        this.createQueryExpression();
    }

    public Class getObjClass() {
        return this._objClass;
    }

    public int getProjectionType() {
        return this._projectionType;
    }

    public QueryExpression getQueryExpression() {
        return this._queryExpr;
    }

    public Hashtable getParamInfo() {
        return this._paramInfo;
    }

    public JDOClassDescriptor getClassDescriptor() {
        return this._clsDesc;
    }

    public Vector getPathInfo() {
        switch (this._projectionType) {
            case 4: 
            case 5: {
                ParseTreeNode projectionNode = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
                if (projectionNode.getToken().getTokenType() == 3) {
                    projectionNode = projectionNode.getChild(0);
                }
                return (Vector)this._pathInfo.get(projectionNode);
            }
        }
        return null;
    }

    private void checkErrors() throws QueryException {
        Enumeration e = this._parseTree.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            if (curChild.getToken().getTokenType() != 5) continue;
            this.checkFromPart(curChild.getChild(0));
            break;
        }
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this.checkSelectPart(this._parseTree.getChild(1));
        } else {
            this.checkSelectPart(this._parseTree.getChild(0));
        }
        block7: for (int curChild = 2; curChild <= this._parseTree.getChildCount() - 1; ++curChild) {
            int tokenType = this._parseTree.getChild(curChild).getToken().getTokenType();
            switch (tokenType) {
                case 7: {
                    this.checkWhereClause(this._parseTree.getChild(curChild));
                    continue block7;
                }
                case 46: {
                    this.checkOrderClause(this._parseTree.getChild(curChild));
                    continue block7;
                }
                case 55: {
                    this.checkLimitClause(this._parseTree.getChild(curChild));
                    continue block7;
                }
                case 56: {
                    this.checkOffsetClause(this._parseTree.getChild(curChild));
                }
            }
        }
    }

    private void checkFromPart(ParseTreeNode fromPart) throws QueryException {
        if (fromPart.getToken().getTokenType() == 3) {
            ParseTreeNode classNameNode = fromPart.getChild(0);
            if (classNameNode.getToken().getTokenType() == 30) {
                StringBuffer sb = new StringBuffer();
                Enumeration e = classNameNode.children();
                while (e.hasMoreElements()) {
                    ParseTreeNode theChild = (ParseTreeNode)e.nextElement();
                    sb.append(theChild.getToken().getTokenValue()).append(".");
                }
                sb.setLength(sb.length() - 1);
                this._fromClassName = sb.toString();
            } else {
                this._fromClassName = classNameNode.getToken().getTokenValue();
            }
            this._fromClassAlias = fromPart.getChild(1).getToken().getTokenValue();
        } else {
            if (fromPart.getToken().getTokenType() == 30) {
                StringBuffer sb = new StringBuffer();
                Enumeration e = fromPart.children();
                while (e.hasMoreElements()) {
                    ParseTreeNode theChild = (ParseTreeNode)e.nextElement();
                    sb.append(theChild.getToken().getTokenValue()).append(".");
                }
                this._fromClassName = sb.deleteCharAt(sb.length() - 1).toString();
            } else {
                this._fromClassName = fromPart.getToken().getTokenValue();
            }
            this._fromClassAlias = this._fromClassName;
        }
        try {
            this._objClass = this._classLoader == null ? Class.forName(this._fromClassName) : this._classLoader.loadClass(this._fromClassName);
        }
        catch (ClassNotFoundException except) {
            throw new QueryException("Could not find class " + this._fromClassName);
        }
        this._engine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
        if (this._engine == null) {
            throw new QueryException("Could not find mapping for class " + this._fromClassName);
        }
        this._clsDesc = this._engine.getDescriptor();
        if (this._clsDesc == null) {
            throw new QueryException("Could not get a descriptor for class " + this._fromClassName);
        }
    }

    private void checkSelectPart(ParseTreeNode selectPart) throws QueryException {
        if (selectPart.getToken().getTokenType() == 3) {
            this.checkProjection(selectPart.getChild(0), true, false);
            this._projectionAlias = selectPart.getChild(1).getToken().getTokenValue();
        } else {
            this.checkProjection(selectPart, true, false);
            this._projectionAlias = "";
        }
    }

    private JDOFieldDescriptor getFieldDesc(String fieldName, JDOClassDescriptor clsDesc) {
        for (JDOClassDescriptor cd = clsDesc; cd != null; cd = (JDOClassDescriptor)cd.getExtends()) {
            JDOFieldDescriptor field = cd.getField(fieldName);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private Object[] getFieldAndClassDesc(String fieldName, JDOClassDescriptor clsDesc, QueryExpression expr, Vector path, int tableIndex) {
        JDOFieldDescriptor field = null;
        JDOClassDescriptor cd = clsDesc;
        JDOFieldDescriptor tempField = null;
        for (JDOClassDescriptor tempCd = clsDesc; tempCd != null; tempCd = (JDOClassDescriptor)tempCd.getExtends()) {
            tempField = tempCd.getField(fieldName);
            if (tempField == null) continue;
            field = tempField;
            cd = tempCd;
        }
        if (field == null) {
            return null;
        }
        Object[] retVal = new Object[]{field, cd};
        if (cd != clsDesc) {
            String tableAlias1 = clsDesc.getTableName();
            String tableAlias2 = cd.getTableName();
            if (tableIndex > 0) {
                tableAlias1 = this.buildTableAlias(tableAlias1, path, tableIndex);
                tableAlias2 = this.buildTableAlias(tableAlias2, path, tableIndex);
            }
            expr.addTable(cd.getTableName(), tableAlias2);
            expr.addInnerJoin(clsDesc.getTableName(), clsDesc.getIdentityColumnNames(), tableAlias1, cd.getTableName(), cd.getIdentityColumnNames(), tableAlias2);
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JDOFieldDescriptor checkProjection(ParseTreeNode projection, boolean topLevel, boolean onlySimple) throws QueryException {
        FieldDescriptorImpl field = null;
        if (projection.getChildCount() == 0) {
            if (topLevel) {
                this._projectionType = 3;
                this._projectionName = projection.getToken().getTokenValue();
                if (this._projectionName.equals(this._fromClassAlias)) return field;
                throw new QueryException("Object name not the same in SELECT and FROM - select: " + this._projectionName + ", from: " + this._fromClassAlias);
            }
            if (!onlySimple) return null;
            throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
        }
        int tokenType = projection.getToken().getTokenType();
        switch (tokenType) {
            case 2: {
                this._projectionType = 2;
                Enumeration e = projection.getChild(0).children();
                while (e.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)e.nextElement(), false, true);
                }
                return field;
            }
            case 30: {
                Enumeration e = projection.children();
                ParseTreeNode curNode = null;
                String curName = null;
                StringBuffer projectionName = new StringBuffer();
                Vector<String> projectionInfo = new Vector<String>();
                if (e.hasMoreElements()) {
                    curNode = (ParseTreeNode)e.nextElement();
                    curName = curNode.getToken().getTokenValue();
                    if (!(curName.equals(this._projectionName) || curName.equals(this._projectionAlias) || curName.equals(this._fromClassName) || curName.equals(this._fromClassAlias))) {
                        e = projection.children();
                        curName = this._fromClassAlias;
                    }
                    projectionName.append(curName);
                    projectionInfo.addElement(curName);
                }
                JDOClassDescriptor curClassDesc = this._clsDesc;
                FieldDescriptorImpl curField = null;
                int count = 0;
                while (e.hasMoreElements()) {
                    curField = null;
                    curName = null;
                    while (curField == null && e.hasMoreElements()) {
                        curNode = (ParseTreeNode)e.nextElement();
                        String curToken = curNode.getToken().getTokenValue();
                        curName = curName == null ? curToken : curName + "." + curToken;
                        curField = this.getFieldDesc(curName, curClassDesc);
                    }
                    if (curField == null) {
                        throw new QueryException("An unknown field was requested: " + curName + " (" + curClassDesc + ")");
                    }
                    projectionName.append(".").append(curName);
                    projectionInfo.addElement(curName);
                    curClassDesc = (JDOClassDescriptor)curField.getClassDescriptor();
                    if (curClassDesc == null && e.hasMoreElements()) {
                        throw new QueryException("An non-reference field was requested: " + curName + " (" + curClassDesc + ")");
                    }
                    ++count;
                }
                field = curField;
                this._pathInfo.put(projection, projectionInfo);
                this._fieldInfo.put(projection, curField);
                Class theClass = curField.getFieldType();
                boolean isSimple = Types.isSimpleType(theClass);
                if (topLevel) {
                    this._projectionName = projectionName.toString();
                    if (isSimple) {
                        if (count > 1 || field.getContainingClassDescriptor() != this._clsDesc) {
                            this._projectionType = 5;
                            return field;
                        }
                        this._projectionType = 6;
                        return field;
                    }
                    this._projectionType = 4;
                    return field;
                }
                if (isSimple || !onlySimple) return field;
                throw new QueryException("Only primitive values are allowed to be passed as parameters to Aggregate and SQL functions.");
            }
            case 50: {
                this._projectionType = 1;
                if (projection.getChild(0).getToken().getTokenType() == 20) return field;
                this.checkProjection(projection.getChild(0), false, false);
                return field;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this._projectionType = 1;
                this.checkProjection(projection.getChild(0), false, true);
                return field;
            }
            default: {
                this._projectionType = 2;
                Enumeration e = projection.children();
                while (e.hasMoreElements()) {
                    this.checkProjection((ParseTreeNode)e.nextElement(), false, false);
                }
                break block0;
            }
        }
        return field;
    }

    private void checkWhereClause(ParseTreeNode whereClause) throws QueryException {
        int tokenType = whereClause.getToken().getTokenType();
        switch (tokenType) {
            case 30: {
                this.checkProjection(whereClause, false, false);
                break;
            }
            case 2: {
                Enumeration e = whereClause.children();
                if (e.hasMoreElements()) {
                    if (whereClause.getChild(0).getToken().getTokenType() != 25) break;
                    while (e.hasMoreElements()) {
                        this.checkWhereClause((ParseTreeNode)e.nextElement());
                    }
                    break;
                }
                this.checkField(whereClause);
                break;
            }
            case 27: {
                this.checkParameter(whereClause);
                break;
            }
            case 6: {
                this.checkField(whereClause.getChild(0));
                this.checkInClauseRightSide(whereClause.getChild(1));
            }
            default: {
                Enumeration e = whereClause.children();
                while (e.hasMoreElements()) {
                    this.checkWhereClause((ParseTreeNode)e.nextElement());
                }
                break block0;
            }
        }
    }

    private void checkLimitClause(ParseTreeNode limitClause) throws QueryException {
        int tokenType = limitClause.getToken().getTokenType();
        switch (tokenType) {
            case 27: {
                this.checkParameter(limitClause);
                break;
            }
            default: {
                Enumeration e = limitClause.children();
                while (e.hasMoreElements()) {
                    this.checkLimitClause((ParseTreeNode)e.nextElement());
                }
                break block0;
            }
        }
    }

    private void checkOffsetClause(ParseTreeNode offsetClause) throws QueryException {
        int tokenType = offsetClause.getToken().getTokenType();
        switch (tokenType) {
            case 27: {
                this.checkParameter(offsetClause);
                break;
            }
            default: {
                Enumeration e = offsetClause.children();
                while (e.hasMoreElements()) {
                    this.checkLimitClause((ParseTreeNode)e.nextElement());
                }
                break block0;
            }
        }
    }

    private JDOFieldDescriptor checkField(ParseTreeNode fieldTree) throws QueryException {
        JDOFieldDescriptor field = (JDOFieldDescriptor)this._fieldInfo.get(fieldTree);
        if (field != null) {
            return field;
        }
        if (fieldTree.getToken().getTokenType() == 30) {
            field = this.checkProjection(fieldTree, false, false);
        } else {
            field = this.getFieldDesc(fieldTree.getToken().getTokenValue(), this._clsDesc);
            if (field != null) {
                this._fieldInfo.put(fieldTree, field);
            }
        }
        if (field == null) {
            throw new QueryException("The field " + fieldTree.getToken().getTokenValue() + " was not found.");
        }
        return field;
    }

    private void checkParameter(ParseTreeNode paramTree) throws QueryException {
        Integer paramNumber;
        String userDefinedType = "";
        if (paramTree.getChildCount() == 1) {
            paramNumber = Integer.decode(paramTree.getChild(0).getToken().getTokenValue());
        } else {
            paramNumber = Integer.decode(paramTree.getChild(1).getToken().getTokenValue());
            userDefinedType = paramTree.getChild(0).getToken().getTokenValue();
        }
        String systemType = "";
        JDOFieldDescriptor desc = null;
        int operation = paramTree.getParent().getToken().getTokenType();
        switch (operation) {
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 55: {
                systemType = "java.lang.Number";
                break;
            }
            case 56: {
                systemType = "java.lang.Number";
                break;
            }
            case 12: 
            case 19: {
                systemType = "java.lang.String";
                break;
            }
            case 8: 
            case 9: 
            case 24: {
                systemType = "java.lang.Boolean";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 40: {
                systemType = this.getParamTypeForComparison(paramTree.getParent());
                desc = this.getJDOFieldDescriptor(paramTree.getParent());
                break;
            }
            case 44: {
                systemType = this.getParamTypeForList(paramTree.getParent());
            }
        }
        ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(paramNumber);
        if (paramInfo == null) {
            paramInfo = new ParamInfo(userDefinedType, systemType, desc, this._classLoader);
            this._paramInfo.put(paramNumber, paramInfo);
        } else {
            paramInfo.check(userDefinedType, systemType);
        }
    }

    private String getParamTypeForComparison(ParseTreeNode comparisonTree) throws QueryException {
        Enumeration e = comparisonTree.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            switch (tokenType) {
                case 36: {
                    return "java.lang.String";
                }
                case 34: {
                    return "java.lang.Double";
                }
                case 33: {
                    return "java.lang.Long";
                }
                case 32: {
                    return "java.lang.Boolean";
                }
                case 35: {
                    return "java.lang.Character";
                }
                case 37: {
                    return "java.util.Date";
                }
                case 38: 
                case 39: {
                    return "java.util.Time";
                }
                case 2: 
                case 30: {
                    JDOFieldDescriptor field = this.checkField(curChild);
                    return field.getFieldType().getName();
                }
            }
        }
        throw new QueryException("Could not get type for comparison.");
    }

    private String getParamTypeForList(ParseTreeNode listTree) throws QueryException {
        Enumeration e = listTree.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            switch (tokenType) {
                case 36: {
                    return "java.lang.String";
                }
                case 34: {
                    return "java.lang.Double";
                }
                case 33: {
                    return "java.lang.Long";
                }
                case 32: {
                    return "java.lang.Boolean";
                }
                case 35: {
                    return "java.lang.Character";
                }
                case 37: {
                    return "java.util.Date";
                }
                case 38: 
                case 39: {
                    return "java.util.Time";
                }
                case 27: {
                    if (curChild.getChildCount() != 2) break;
                    String userDefinedType = curChild.getChild(0).getToken().getTokenValue();
                    try {
                        return Types.typeFromName(this._classLoader, userDefinedType).getName();
                    }
                    catch (ClassNotFoundException e1) {
                        throw new QueryException("Could not find class " + userDefinedType);
                    }
                }
            }
        }
        return "java.lang.String";
    }

    private JDOFieldDescriptor getJDOFieldDescriptor(ParseTreeNode comparisonTree) throws QueryException {
        Enumeration e = comparisonTree.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            if (tokenType != 30 && tokenType != 2) continue;
            return this.checkField(curChild);
        }
        return null;
    }

    private void checkInClauseRightSide(ParseTreeNode theList) throws QueryException {
        if (theList.getToken().getTokenType() != 44) {
            throw new QueryException("The right side of the IN operator must be a LIST.");
        }
        Enumeration e = theList.children();
        block4: while (e.hasMoreElements()) {
            ParseTreeNode node = (ParseTreeNode)e.nextElement();
            int tokenType = node.getToken().getTokenType();
            switch (tokenType) {
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    continue block4;
                }
                case 27: {
                    this.checkParameter(node);
                    continue block4;
                }
            }
            throw new QueryException("The LIST can only contain literals, bind variables and the keywords 'nil' and 'undefined'.");
        }
    }

    private void checkOrderClause(ParseTreeNode orderClause) throws QueryException {
        if (orderClause.getToken().getTokenType() != 46) {
            throw new QueryException("checkOrderClause was called on a subtree which is not an order clause.");
        }
        ParseTreeNode prevChild = null;
        Enumeration e = orderClause.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            switch (tokenType) {
                case 48: 
                case 49: {
                    curChild = curChild.getChild(0);
                    tokenType = curChild.getToken().getTokenType();
                }
            }
            switch (tokenType) {
                case 30: {
                    this.checkProjection(curChild, false, false);
                    break;
                }
                case 2: {
                    if (curChild.children().hasMoreElements()) {
                        if (curChild.getChild(0).getToken().getTokenType() != 25) break;
                        Enumeration arguments = curChild.getChild(0).children();
                        while (arguments.hasMoreElements()) {
                            ParseTreeNode nn = (ParseTreeNode)arguments.nextElement();
                            this.checkWhereClause(nn);
                        }
                        break;
                    }
                    this.checkField(curChild);
                    break;
                }
                case 25: {
                    if (prevChild != null && prevChild.getToken().getTokenType() == 2) break;
                    throw new QueryException("Illegal use of left parenthesis in ORDER BY clause.");
                }
                default: {
                    throw new QueryException("Only identifiers, path expressions, and the keywords ASC and DESC are allowed in the ORDER BY clause.");
                }
            }
            prevChild = curChild;
        }
    }

    private void createQueryExpression() throws SyntaxNotSupportedException {
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                this._queryExpr = this._engine.getFinder();
                break;
            }
            default: {
                this._queryExpr = this._engine.getQueryExpression();
                this.addSelectFromJoins();
            }
        }
        this._queryExpr.setDbMetaInfo(this._dbInfo);
        if (this._parseTree.getChild(0).getToken().getTokenType() == 41) {
            this._queryExpr.setDistinct(true);
        }
        Enumeration e = this._parseTree.children();
        while (e.hasMoreElements()) {
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            switch (tokenType) {
                case 7: {
                    this.addWhereClause(curChild);
                    break;
                }
                case 46: {
                    this._queryExpr.addOrderClause(this.getOrderClause(curChild));
                    break;
                }
                case 55: {
                    this.addLimitClause(curChild);
                    break;
                }
                case 56: {
                    this.addOffsetClause(curChild);
                }
            }
        }
    }

    private void addSelectFromJoins() {
        ParseTreeNode selectPart = null;
        selectPart = this._parseTree.getChild(0).getToken().getTokenType() == 41 ? this._parseTree.getChild(1) : this._parseTree.getChild(0);
        this._queryExpr.addTable(this._clsDesc.getTableName());
        this._queryExpr.addSelect(this.getSQLExpr(selectPart));
    }

    public String buildTableAlias(String tableName, Vector path, int tableIndex) {
        String tableAlias = tableName;
        if (path != null && path.size() > 2) {
            int index;
            Vector tablePath = new Vector(path.subList(0, tableIndex + 1));
            Integer i = (Integer)this._allPaths.get(tablePath);
            if (i == null) {
                index = this._allPaths.size();
                this._allPaths.put(tablePath, new Integer(index));
            } else {
                index = i;
            }
            String stringIndex = String.valueOf(index);
            if (tableAlias.length() + stringIndex.length() + 1 > 30) {
                tableAlias = tableAlias.substring(30 - (stringIndex.length() + 1));
            }
            tableAlias = tableAlias.replace('.', '_') + "_" + index;
        }
        return tableAlias;
    }

    private void addJoinsForPathExpression(Vector path) {
        if (path == null) {
            throw new IllegalStateException("path = null !");
        }
        JDOClassDescriptor sourceClass = this._clsDesc;
        for (int i = 1; i < path.size() - 1; ++i) {
            JDOFieldDescriptor identity;
            String sourceTableAlias;
            JDOFieldDescriptor fieldDesc = null;
            Object[] fieldAndClass = this.getFieldAndClassDesc((String)path.elementAt(i), sourceClass, this._queryExpr, path, i - 1);
            if (fieldAndClass == null) {
                throw new IllegalStateException("Field not found:" + path.elementAt(i));
            }
            fieldDesc = (JDOFieldDescriptor)fieldAndClass[0];
            sourceClass = (JDOClassDescriptor)fieldAndClass[1];
            JDOClassDescriptor clsDesc = (JDOClassDescriptor)fieldDesc.getClassDescriptor();
            if (clsDesc == null) continue;
            if (fieldDesc.getManyKey() == null) {
                JDOFieldDescriptor foreignKey = (JDOFieldDescriptor)clsDesc.getIdentity();
                sourceTableAlias = sourceClass.getTableName();
                if (i > 1) {
                    sourceTableAlias = this.buildTableAlias(sourceTableAlias, path, i - 1);
                }
                this._queryExpr.addInnerJoin(sourceClass.getTableName(), fieldDesc.getSQLName(), sourceTableAlias, clsDesc.getTableName(), foreignKey.getSQLName(), this.buildTableAlias(clsDesc.getTableName(), path, i));
            } else if (fieldDesc.getManyTable() == null) {
                identity = (JDOFieldDescriptor)sourceClass.getIdentity();
                sourceTableAlias = sourceClass.getTableName();
                if (i > 1) {
                    sourceTableAlias = this.buildTableAlias(sourceTableAlias, path, i - 1);
                }
                this._queryExpr.addInnerJoin(sourceClass.getTableName(), identity.getSQLName(), sourceTableAlias, clsDesc.getTableName(), fieldDesc.getManyKey(), this.buildTableAlias(clsDesc.getTableName(), path, i));
            } else {
                identity = (JDOFieldDescriptor)sourceClass.getIdentity();
                JDOFieldDescriptor foreignKey = (JDOFieldDescriptor)clsDesc.getIdentity();
                String manyTableAlias = fieldDesc.getManyTable();
                String sourceTableAlias2 = sourceClass.getTableName();
                if (i > 1) {
                    manyTableAlias = this.buildTableAlias(manyTableAlias, path, i - 1);
                    sourceTableAlias2 = this.buildTableAlias(sourceTableAlias2, path, i - 1);
                }
                this._queryExpr.addInnerJoin(sourceClass.getTableName(), identity.getSQLName(), sourceTableAlias2, fieldDesc.getManyTable(), fieldDesc.getManyKey(), manyTableAlias);
                this._queryExpr.addInnerJoin(fieldDesc.getManyTable(), fieldDesc.getSQLName(), manyTableAlias, clsDesc.getTableName(), foreignKey.getSQLName(), this.buildTableAlias(clsDesc.getTableName(), path, i));
            }
            sourceClass = clsDesc;
        }
    }

    private void addWhereClause(ParseTreeNode whereClause) {
        String sqlExpr = this.getSQLExpr(whereClause.getChild(0));
        this._queryExpr.addWhereClause(sqlExpr);
    }

    private void addLimitClause(ParseTreeNode limitClause) throws SyntaxNotSupportedException {
        String sqlExpr = this.getSQLExpr(limitClause);
        this._queryExpr.addLimitClause(sqlExpr);
    }

    private void addOffsetClause(ParseTreeNode offsetClause) throws SyntaxNotSupportedException {
        String sqlExpr = this.getSQLExpr(offsetClause);
        this._queryExpr.addOffsetClause(sqlExpr);
    }

    private String getSQLExpr(ParseTreeNode exprTree) {
        StringBuffer sb = null;
        int tokenType = exprTree.getToken().getTokenType();
        switch (tokenType) {
            case 25: {
                return "( " + this.getSQLExpr(exprTree.getChild(0)) + " )";
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                if (exprTree.getChildCount() == 1) {
                    return exprTree.getToken().getTokenValue() + " " + this.getSQLExpr(exprTree.getChild(0));
                }
                return this.getSQLExpr(exprTree.getChild(0)) + " " + exprTree.getToken().getTokenValue() + " " + this.getSQLExpr(exprTree.getChild(1));
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return this.getSQLExpr(exprTree.getChild(0)) + " " + exprTree.getToken().getTokenValue() + " " + this.getSQLExpr(exprTree.getChild(1));
            }
            case 40: {
                return this.getSQLExpr(exprTree.getChild(0)) + " " + exprTree.getToken().getTokenValue() + " " + this.getSQLExpr(exprTree.getChild(1)) + " AND " + this.getSQLExpr(exprTree.getChild(2));
            }
            case 42: {
                return this.getSQLExpr(exprTree.getChild(0)) + " IS NOT NULL ";
            }
            case 43: {
                return this.getSQLExpr(exprTree.getChild(0)) + " IS NULL ";
            }
            case 50: {
                if (exprTree.getChild(0).getToken().getTokenType() == 20) {
                    return " COUNT(*) ";
                }
                return " COUNT(" + this.getSQLExpr(exprTree.getChild(0)) + ") ";
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return " " + exprTree.getToken().getTokenValue() + "(" + this.getSQLExpr(exprTree.getChild(0)) + ") ";
            }
            case 44: {
                sb = new StringBuffer("( ");
                Enumeration e = exprTree.children();
                while (e.hasMoreElements()) {
                    sb.append(this.getSQLExpr((ParseTreeNode)e.nextElement())).append(" , ");
                }
                sb.replace(sb.length() - 2, sb.length() - 1, " )").append(" ");
                return sb.toString();
            }
            case 2: 
            case 30: {
                String clsTableAlias;
                JDOFieldDescriptor field;
                if (exprTree.getChildCount() > 0 && exprTree.getChild(0).getToken().getTokenType() == 25) {
                    sb = new StringBuffer(exprTree.getToken().getTokenValue()).append("(");
                    int paramCount = 0;
                    Enumeration e = exprTree.children();
                    e = ((ParseTreeNode)e.nextElement()).children();
                    while (e.hasMoreElements()) {
                        sb.append(this.getSQLExpr((ParseTreeNode)e.nextElement())).append(" , ");
                        ++paramCount;
                    }
                    if (paramCount > 0) {
                        sb.replace(sb.length() - 2, sb.length() - 1, " )");
                    } else {
                        sb.append(") ");
                    }
                    return sb.toString();
                }
                Vector path = (Vector)this._pathInfo.get(exprTree);
                if (tokenType == 30) {
                    if (path == null) {
                        System.err.println("exprTree=" + exprTree.toStringEx() + "\npathInfo = {");
                        Enumeration enumeration = this._pathInfo.keys();
                        while (enumeration.hasMoreElements()) {
                            ParseTreeNode n = (ParseTreeNode)enumeration.nextElement();
                            System.err.println("\t" + n.toStringEx());
                        }
                    }
                    this.addJoinsForPathExpression(path);
                }
                if ((field = (JDOFieldDescriptor)this._fieldInfo.get(exprTree)) == null) {
                    throw new IllegalStateException("fieldInfo for " + exprTree.toStringEx() + " not found");
                }
                JDOClassDescriptor clsDesc = (JDOClassDescriptor)field.getContainingClassDescriptor();
                if (clsDesc == null) {
                    throw new IllegalStateException("ContainingClass of " + field.toString() + " is null !");
                }
                if (tokenType == 30 && path != null && path.size() > 2) {
                    clsTableAlias = this.buildTableAlias(clsDesc.getTableName(), path, path.size() - 2);
                    JDOClassDescriptor srcDesc = this._clsDesc;
                    for (int i = 1; i < path.size(); ++i) {
                        Object[] fieldAndClass = this.getFieldAndClassDesc((String)path.elementAt(i), srcDesc, this._queryExpr, path, i - 1);
                        if (fieldAndClass == null) {
                            throw new IllegalStateException("Field not found: " + path.elementAt(i) + " class " + srcDesc.getJavaClass());
                        }
                        JDOFieldDescriptor fieldDesc = (JDOFieldDescriptor)fieldAndClass[0];
                        srcDesc = (JDOClassDescriptor)fieldDesc.getClassDescriptor();
                    }
                } else {
                    clsTableAlias = this.buildTableAlias(clsDesc.getTableName(), path, 9999);
                }
                return this._queryExpr.encodeColumn(clsTableAlias, field.getSQLName()[0]);
            }
            case 27: {
                return "?" + exprTree.getChild(exprTree.getChildCount() - 1).getToken().getTokenValue();
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return exprTree.getToken().getTokenValue();
            }
            case 36: {
                sb = new StringBuffer();
                String copy = new String(exprTree.getToken().getTokenValue());
                int pos = copy.indexOf("\\\"", 1);
                while (pos != -1) {
                    sb.append(copy.substring(0, pos)).append("\"\"");
                    copy = copy.substring(pos + 2);
                    pos = copy.indexOf("\\\"");
                }
                sb.append(copy);
                copy = sb.deleteCharAt(0).toString();
                sb.setLength(0);
                sb.append("'");
                pos = copy.indexOf("'", 1);
                while (pos != -1) {
                    sb.append(copy.substring(0, pos)).append("''");
                    copy = copy.substring(pos + 1);
                    pos = copy.indexOf("'");
                }
                sb.append(copy);
                sb.replace(sb.length() - 1, sb.length(), "'");
                return sb.toString();
            }
            case 37: 
            case 38: {
                return exprTree.getToken().getTokenValue().substring(5);
            }
            case 39: {
                return exprTree.getToken().getTokenValue().substring(10);
            }
            case 28: 
            case 29: {
                return " NULL ";
            }
            case 55: 
            case 56: {
                return this.getSQLExprForLimit(exprTree);
            }
        }
        return "";
    }

    private String getSQLExprForLimit(ParseTreeNode limitClause) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = limitClause.children();
        while (e.hasMoreElements()) {
            ParseTreeNode exprTree = (ParseTreeNode)e.nextElement();
            int tokenType = exprTree.getToken().getTokenType();
            switch (tokenType) {
                case 27: {
                    sb.append("?" + exprTree.getChild(exprTree.getChildCount() - 1).getToken().getTokenValue());
                    break;
                }
                case 45: {
                    sb.append(" , ");
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    return exprTree.getToken().getTokenValue();
                }
            }
        }
        return sb.toString();
    }

    private String getOrderClause(ParseTreeNode orderClause) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = orderClause.children();
        while (e.hasMoreElements()) {
            sb.append(", ");
            ParseTreeNode curChild = (ParseTreeNode)e.nextElement();
            int tokenType = curChild.getToken().getTokenType();
            switch (tokenType) {
                case 48: {
                    sb.append(this.getSQLExpr(curChild.getChild(0))).append(" ASC ");
                    break;
                }
                case 49: {
                    sb.append(this.getSQLExpr(curChild.getChild(0))).append(" DESC ");
                    break;
                }
                case 2: 
                case 30: {
                    sb.append(this.getSQLExpr(curChild)).append(" ");
                }
            }
        }
        sb.deleteCharAt(0).deleteCharAt(0);
        return sb.toString();
    }
}

