/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.jdo.engine.JDOConfLoader;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceEngineFactory;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DatabaseRegistry {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$engine$DatabaseRegistry == null ? (class$org$exolab$castor$jdo$engine$DatabaseRegistry = DatabaseRegistry.class$("org.exolab.castor.jdo.engine.DatabaseRegistry")) : class$org$exolab$castor$jdo$engine$DatabaseRegistry);
    public static final String GenericEngine = "generic";
    private String _jdbcUrl;
    private Properties _jdbcProps;
    private DataSource _dataSource;
    private MappingResolver _mapResolver;
    private String _name;
    private LockEngine _engine;
    private static Hashtable _databases = new Hashtable();
    private static Hashtable _byEngine = new Hashtable();
    public static String DefaultMapping = "mapping.xml";
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$DatabaseRegistry;

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory, String jdbcUrl, Properties jdbcProps) throws MappingException {
        this(name, mapResolver, factory);
        this._jdbcUrl = jdbcUrl;
        this._jdbcProps = jdbcProps;
    }

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory, DataSource dataSource) throws MappingException {
        this(name, mapResolver, factory);
        this._dataSource = dataSource;
    }

    DatabaseRegistry(String name, MappingResolver mapResolver, PersistenceFactory factory) throws MappingException {
        this._name = name;
        this._mapResolver = mapResolver;
        this._engine = new PersistenceEngineFactory().createEngine(mapResolver, factory);
        _byEngine.put(this._engine, this);
    }

    public MappingResolver getMappingResolver() {
        return this._mapResolver;
    }

    public String getName() {
        return this._name;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader) throws MappingException {
        Database[] databases = JDOConfLoader.getDatabases(jdoConf);
        DatabaseRegistry.loadDatabase(databases, resolver, loader, null);
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        Database[] databases = JDOConfLoader.getDatabases(source, resolver);
        DatabaseRegistry.loadDatabase(databases, resolver, loader, source.getSystemId());
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void loadDatabase(Database[] databases, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        try {
            for (int i = 0; i < databases.length; ++i) {
                void var7_10;
                DatabaseRegistry dbs;
                Database database = databases[i];
                if (_databases.get(database.getName()) != null) {
                    return;
                }
                PersistenceFactory factory = database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory(GenericEngine) : PersistenceFactoryRegistry.getPersistenceFactory(database.getEngine());
                if (factory == null) {
                    throw new MappingException("jdo.noSuchEngine", database.getEngine());
                }
                org.exolab.castor.mapping.Mapping mapping = new org.exolab.castor.mapping.Mapping(loader);
                if (resolver != null) {
                    mapping.setEntityResolver(resolver);
                }
                if (baseURI != null) {
                    mapping.setBaseURL(baseURI);
                }
                Enumeration mappings = database.enumerateMapping();
                while (mappings.hasMoreElements()) {
                    String mappingUrl = ((Mapping)mappings.nextElement()).getHref();
                    _log.debug((Object)("Loading the mapping descriptor: " + mappingUrl));
                    if (mappingUrl == null) continue;
                    mapping.loadMapping(mappingUrl);
                }
                if (database.getDatabaseChoice() == null) {
                    throw new MappingException("jdo.missingDataSource", database.getName());
                }
                if (database.getDatabaseChoice().getDriver() != null) {
                    dbs = DatabaseRegistry.initFromDriver(mapping, database, factory);
                } else if (database.getDatabaseChoice().getDataSource() != null) {
                    dbs = DatabaseRegistry.initFromDataSource(mapping, database, factory, loader);
                } else if (database.getDatabaseChoice().getJndi() != null) {
                    dbs = DatabaseRegistry.initFromJNDI(mapping, database, factory);
                } else {
                    throw new MappingException("jdo.missingDataSource", database.getName());
                }
                _databases.put(database.getName(), var7_10);
            }
        }
        catch (MappingException except) {
            throw except;
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
    }

    public static DatabaseRegistry initFromDataSource(org.exolab.castor.mapping.Mapping mapping, Database database, PersistenceFactory factory, ClassLoader classLoader) throws MappingException {
        DataSource dataSource = DatabaseRegistry.loadDataSource(database, classLoader);
        DatabaseRegistry dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, dataSource);
        _log.debug((Object)("Using DataSource: " + database.getDatabaseChoice().getDataSource().getClassName()));
        return dbs;
    }

    public static DataSource loadDataSource(Database database, ClassLoader classLoader) throws MappingException {
        DataSource dataSource;
        String className = database.getDatabaseChoice().getDataSource().getClassName();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            dataSource = (DataSource)Class.forName(className, true, classLoader).newInstance();
        }
        catch (Exception e) {
            throw new MappingException(Messages.format("jdo.engine.classNotInstantiable", className), e);
        }
        Param[] parameters = database.getDatabaseChoice().getDataSource().getParam();
        Unmarshaller unmarshaller = new Unmarshaller(dataSource);
        UnmarshalHandler handler = unmarshaller.createHandler();
        try {
            handler.startDocument();
            handler.startElement("data-source", null);
            for (int i = 0; i < parameters.length; ++i) {
                Param param = parameters[i];
                handler.startElement(param.getName(), null);
                handler.characters(param.getValue().toCharArray(), 0, param.getValue().length());
                handler.endElement(param.getName());
            }
            handler.endElement("data-source");
            handler.endDocument();
        }
        catch (SAXException e) {
            _log.error((Object)"Unable to parse <data-source> element.", (Throwable)e);
            throw new MappingException("Unable to parse <data-source> element.", e);
        }
        return dataSource;
    }

    private static DatabaseRegistry initFromDriver(org.exolab.castor.mapping.Mapping mapping, Database database, PersistenceFactory factory) throws MappingException, SQLException {
        String driverName = database.getDatabaseChoice().getDriver().getClassName();
        if (driverName != null) {
            try {
                Class.forName(database.getDatabaseChoice().getDriver().getClassName()).newInstance();
            }
            catch (InstantiationException e) {
                _log.error((Object)Messages.format("jdo.engine.classNotInstantiable", driverName), (Throwable)e);
                throw new MappingException(Messages.format("jdo.engine.classNotInstantiable", driverName), e);
            }
            catch (IllegalAccessException e) {
                _log.error((Object)Messages.format("jdo.engine.classNotAccessable", driverName, "constructor"), (Throwable)e);
                throw new MappingException(Messages.format("jdo.engine.classNotAccessable", driverName, "constructor"), e);
            }
            catch (ClassNotFoundException e) {
                _log.error((Object)("Can not load class " + driverName), (Throwable)e);
                throw new MappingException("Can not load class " + driverName, e);
            }
        }
        if (DriverManager.getDriver(database.getDatabaseChoice().getDriver().getUrl()) == null) {
            throw new MappingException("jdo.missingDriver", database.getDatabaseChoice().getDriver().getUrl());
        }
        Properties props = new Properties();
        Enumeration params = database.getDatabaseChoice().getDriver().enumerateParam();
        while (params.hasMoreElements()) {
            Param param = (Param)params.nextElement();
            props.put(param.getName(), param.getValue());
        }
        DatabaseRegistry dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, database.getDatabaseChoice().getDriver().getUrl(), props);
        _log.debug((Object)("Using driver: " + driverName));
        return dbs;
    }

    private static DatabaseRegistry initFromJNDI(org.exolab.castor.mapping.Mapping mapping, Database database, PersistenceFactory factory) throws MappingException {
        Object dataSource;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Using DataSource from JNDI ENC: " + database.getDatabaseChoice().getJndi().getName()));
        }
        try {
            InitialContext initialContext = new InitialContext();
            dataSource = initialContext.lookup(database.getDatabaseChoice().getJndi().getName());
        }
        catch (NameNotFoundException e) {
            throw new MappingException("jdo.jndiNameNotFound", database.getDatabaseChoice().getJndi().getName(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e);
        }
        if (!(dataSource instanceof DataSource)) {
            throw new MappingException("jdo.jndiNameNotFound", database.getDatabaseChoice().getJndi().getName());
        }
        DatabaseRegistry dbs = new DatabaseRegistry(database.getName(), mapping.getResolver(org.exolab.castor.mapping.Mapping.JDO, factory), factory, (DataSource)dataSource);
        return dbs;
    }

    public Connection createConnection() throws SQLException {
        if (this._dataSource != null) {
            return this._dataSource.getConnection();
        }
        return DriverManager.getConnection(this._jdbcUrl, this._jdbcProps);
    }

    static LockEngine getLockEngine(Class objType) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry dbs = (DatabaseRegistry)enumeration.nextElement();
            if (dbs._mapResolver.getDescriptor(objType) == null) continue;
            return dbs._engine;
        }
        return null;
    }

    static LockEngine getLockEngine(DatabaseRegistry dbs) {
        return dbs._engine;
    }

    public static DatabaseRegistry getDatabaseRegistry(Object obj) {
        return DatabaseRegistry.getDatabaseRegistry(obj.getClass());
    }

    public static boolean hasDatabaseRegistries() {
        return !_databases.isEmpty();
    }

    public static DatabaseRegistry getDatabaseRegistry(Class c) {
        Enumeration enumeration = _databases.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseRegistry dbs = (DatabaseRegistry)enumeration.nextElement();
            if (dbs._mapResolver.getDescriptor(c) == null) continue;
            return dbs;
        }
        return null;
    }

    public static synchronized DatabaseRegistry getDatabaseRegistry(String name) {
        DatabaseRegistry dbs = (DatabaseRegistry)_databases.get(name);
        return dbs;
    }

    static Connection createConnection(LockEngine engine) throws SQLException {
        DatabaseRegistry dbs = (DatabaseRegistry)_byEngine.get(engine);
        if (dbs._dataSource != null) {
            return dbs._dataSource.getConnection();
        }
        return DriverManager.getConnection(dbs._jdbcUrl, dbs._jdbcProps);
    }

    public static void clear() {
        _databases.clear();
        _byEngine.clear();
        JDOConfLoader.deleteConfiguration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

