/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.util;

import java.util.Iterator;
import java.util.LinkedList;

public class TemporaryList {
    public static final int DEFAULT_ITEM_TIMEOUT = 5000;
    private int timeout = 5000;
    private LinkedList list = new LinkedList();

    public synchronized void add(Object o) {
        long now = System.currentTimeMillis();
        if (this.list.size() > 0 && ((TemporaryListItem)this.list.getFirst()).atMaturity(now)) {
            this.list.removeFirst();
        }
        if (this.list.size() > 0 && ((TemporaryListItem)this.list.getLast()).atMaturity(now)) {
            this.list.removeLast();
        }
        this.list.addFirst(new TemporaryListItem(o));
    }

    public synchronized boolean contains(Object o) {
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            TemporaryListItem item = (TemporaryListItem)it.next();
            if (!item.getItem().equals(o)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean remove(Object o) {
        long now = System.currentTimeMillis();
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            TemporaryListItem item = (TemporaryListItem)it.next();
            if (item.getItem().equals(o)) {
                it.remove();
                return true;
            }
            if (!item.atMaturity(now)) continue;
            it.remove();
        }
        return false;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Iterator iterator() {
        return new TemporaryListIterator();
    }

    public int size() {
        return this.list.size();
    }

    public synchronized void clear() {
        this.list.clear();
    }

    class TemporaryListIterator
    implements Iterator {
        private Iterator iterator;

        public TemporaryListIterator() {
            this.iterator = TemporaryList.this.list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return ((TemporaryListItem)this.iterator.next()).getItem();
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    class TemporaryListItem {
        private Object item;
        private long timeOfMaturity;

        public TemporaryListItem(Object item) {
            this.item = item;
            this.timeOfMaturity = System.currentTimeMillis() + (long)TemporaryList.this.timeout;
        }

        public long getTimeOfMaturity() {
            return this.timeOfMaturity;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean equals(Object obj) {
            return this.item.equals(obj);
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean atMaturity(long referenceTime) {
            return referenceTime > this.timeOfMaturity;
        }
    }
}

