/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.test;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.ThreadPool;

public class TestAgent
extends BaseAgent {
    protected String address;

    public TestAgent(File bootCounterFile, File configFile) throws IOException {
        super(bootCounterFile, configFile, new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.agent.setThreadPool(ThreadPool.create((String)"RequestPool", (int)4));
    }

    protected void registerManagedObjects() {
        try {
            this.server.register(TestAgent.createStaticIfTable(), null);
        }
        catch (DuplicateRegistrationException ex) {
            ex.printStackTrace();
        }
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        targetMIB.addTargetAddress(new OctetString("notification"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("v2c"), 4);
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 2, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void addUsmUser(USM usm) {
        UsmUser user = new UsmUser(new OctetString("SHADES"), AuthSHA.ID, new OctetString("SHADESAuthPassword"), PrivDES.ID, new OctetString("SHADESPrivPassword"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("TEST"), AuthSHA.ID, new OctetString("maplesyrup"), PrivDES.ID, new OctetString("maplesyrup"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("SHA"), AuthSHA.ID, new OctetString("SHAAuthPassword"), null, null);
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
    }

    private static DefaultMOTable createStaticIfTable() {
        MOTableSubIndex[] subIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2)};
        MOTableIndex indexDef = new MOTableIndex(subIndexes, false);
        MOColumn[] columns = new MOColumn[8];
        int c = 0;
        columns[c++] = new MOColumn(c, 2, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOColumn(c, 4, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOColumn(c, 2, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOColumn(c, 2, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOColumn(c, 66, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOColumn(c, 4, MOAccessImpl.ACCESS_READ_ONLY);
        columns[c++] = new MOMutableColumn(c, 2, MOAccessImpl.ACCESS_READ_WRITE, null);
        columns[c++] = new MOColumn(c, 2, MOAccessImpl.ACCESS_READ_ONLY);
        DefaultMOTable ifTable = new DefaultMOTable(new OID("1.3.6.1.2.1.2.2.1"), indexDef, columns);
        MOMutableTableModel model = (MOMutableTableModel)ifTable.getModel();
        Variable[] rowValues1 = new Variable[]{new Integer32(1), new OctetString("eth0"), new Integer32(6), new Integer32(1500), new Gauge32(100000000L), new OctetString("00:00:00:00:01"), new Integer32(1), new Integer32(1)};
        Variable[] rowValues2 = new Variable[]{new Integer32(2), new OctetString("loopback"), new Integer32(24), new Integer32(1500), new Gauge32(10000000L), new OctetString("00:00:00:00:02"), new Integer32(1), new Integer32(1)};
        model.addRow(new DefaultMOMutableRow2PC(new OID("1"), rowValues1));
        model.addRow(new DefaultMOMutableRow2PC(new OID("2"), rowValues2));
        return ifTable;
    }

    protected void initTransportMappings() throws IOException {
        this.transportMappings = new TransportMapping[1];
        this.transportMappings[0] = new DefaultUdpTransportMapping(new UdpAddress(this.address));
    }

    public static void main(String[] args) {
        String address = args.length > 0 ? args[0] : "0.0.0.0/161";
        BasicConfigurator.configure();
        try {
            TestAgent testAgent1 = new TestAgent(new File("SNMP4JTestAgentBC.cfg"), new File("SNMP4JTestAgentConfig.cfg"));
            testAgent1.address = address;
            testAgent1.init();
            testAgent1.loadConfig(2);
            testAgent1.addShutdownHook();
            testAgent1.run();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex1) {
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void unregisterManagedObjects() {
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    static {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
    }
}

