/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class StorageType
extends MOMutableColumn {
    public static final int other = 1;
    public static final int volatile_ = 2;
    public static final int nonVolatile = 3;
    public static final int permanent = 4;
    public static final int readOnly = 5;

    public StorageType(int columnID, MOAccess access, Integer32 defaultValue, boolean mutableInService) {
        super(columnID, 2, access, (Variable)defaultValue, mutableInService);
    }

    public synchronized int validate(Variable newValue, Variable oldValue) {
        int v = ((Integer32)newValue).getValue();
        if (v < 1 || v > 5) {
            return 10;
        }
        if (oldValue != null) {
            int ov = ((Integer32)oldValue).getValue();
            if (ov < 4 && v >= 4) {
                return 10;
            }
            if (ov >= 4) {
                return 10;
            }
        }
        return super.validate(newValue, oldValue);
    }

    public boolean isVolatile(MOTableRow row, int column) {
        Integer32 value = (Integer32)row.getValue(column);
        if (value != null) {
            int storageType = value.getValue();
            switch (storageType) {
                case 1: 
                case 2: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

