/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.agent.ProxyForwardRequest;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OctetString;

public class ProxyForwarderImpl
implements ProxyForwarder {
    private static final LogAdapter logger = LogFactory.getLogger((Class)(class$org$snmp4j$agent$mo$snmp$ProxyForwarderImpl == null ? (class$org$snmp4j$agent$mo$snmp$ProxyForwarderImpl = ProxyForwarderImpl.class$("org.snmp4j.agent.mo.snmp.ProxyForwarderImpl")) : class$org$snmp4j$agent$mo$snmp$ProxyForwarderImpl));
    private Snmp session;
    private SnmpProxyMIB proxyMIB;
    private SnmpTargetMIB targetMIB;
    static /* synthetic */ Class class$org$snmp4j$agent$mo$snmp$ProxyForwarderImpl;

    public ProxyForwarderImpl(Snmp session, SnmpProxyMIB proxyMIB, SnmpTargetMIB targetMIB) {
        this.session = session;
        this.proxyMIB = proxyMIB;
        this.targetMIB = targetMIB;
    }

    public boolean forward(ProxyForwardRequest request) {
        int pduType = request.getCommandEvent().getPDU().getType();
        if (SnmpRequest.getViewType(pduType) == 0) {
            return this.multipleForward(request);
        }
        ResponseEvent resp = this.singleForward(request);
        if (resp != null && resp.getResponse() != null) {
            request.setResponsePDU(resp.getResponse());
            return true;
        }
        return false;
    }

    protected List getMatches(ProxyForwardRequest request) {
        List matches = this.proxyMIB.getProxyRows(request.getProxyType(), request.getContextEngineID(), request.getContext());
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            SnmpProxyMIB.SnmpProxyRow possibleMatch = (SnmpProxyMIB.SnmpProxyRow)((MOTableRow)it.next());
            OctetString paramIn = possibleMatch.getSnmpProxyTargetParamsIn();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking possible match for in parameter: " + paramIn));
            }
            if (this.matchParameters(request.getCommandEvent(), paramIn)) continue;
            it.remove();
        }
        return matches;
    }

    protected boolean matchParameters(CommandResponderEvent request, OctetString paramIn) {
        MOTableRow param2Match = this.targetMIB.getTargetParamsRow(paramIn, true);
        if (param2Match != null) {
            int mpModel = param2Match.getValue(0).toInt();
            int secModel = param2Match.getValue(1).toInt();
            int secLevel = param2Match.getValue(3).toInt();
            OctetString secName = (OctetString)param2Match.getValue(2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Matching request " + request + "  with mpModel=" + mpModel + ", secModel=" + secModel + ", secLevel=" + secLevel + ", secName=" + secName));
            }
            if (mpModel == request.getMessageProcessingModel() && secName.equals((Object)request.getSecurityName()) && (secModel == 0 || secModel == request.getSecurityModel()) && secLevel == request.getSecurityLevel()) {
                return true;
            }
        }
        return false;
    }

    protected ResponseEvent singleForward(ProxyForwardRequest request) {
        List matches = this.getMatches(request);
        if (matches == null || matches.isEmpty()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No matching proxy entry found for contextEngineID=" + request.getContextEngineID() + ", context=" + request.getContext() + " and request=" + request));
            }
            return null;
        }
        OctetString outParam = (OctetString)((MOTableRow)matches.get(0)).getValue(4);
        Target target = this.targetMIB.getTarget(outParam, request.getContextEngineID(), request.getContext());
        if (target == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("No matching target with name '" + outParam + "'"));
            }
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Forwarding proxy request " + request + " to " + target));
        }
        PDU pdu = (PDU)request.getCommandEvent().getPDU().clone();
        try {
            ResponseEvent response = this.session.send(pdu, target);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Received proxy response from " + response.getPeerAddress() + " is " + response.getResponse()));
            }
            return response;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            logger.error((Object)("Failed to send proxy request to " + target + " because: " + ex.getMessage()));
            return null;
        }
    }

    protected boolean multipleForward(ProxyForwardRequest request) {
        List matches = this.getMatches(request);
        boolean allOK = true;
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            SnmpProxyMIB.SnmpProxyRow item = (SnmpProxyMIB.SnmpProxyRow)it.next();
            OctetString outParam = item.getSnmpProxyMultipleTargetOut();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Proxy multiple targets out with tag " + outParam));
            }
            Collection targets = this.targetMIB.getTargetAddrRowsForTag(outParam);
            Iterator tit = targets.iterator();
            while (tit.hasNext()) {
                SnmpTargetMIB.SnmpTargetAddrEntryRow targetRow = (SnmpTargetMIB.SnmpTargetAddrEntryRow)tit.next();
                Target target = targetRow.getTarget(request.getContextEngineID(), request.getContext());
                if (target != null) {
                    try {
                        ResponseEvent resp = this.session.send(request.getCommandEvent().getPDU(), target);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Forwarded " + request.getCommandEvent() + " to target " + target + " with response " + resp));
                        }
                        if (request.getCommandEvent().getPDU().getType() != -90 || resp.getResponse() != null && resp.getResponse().getType() != -88 && resp.getResponse().getErrorStatus() == 0) continue;
                        allOK = false;
                    }
                    catch (IOException ex) {
                        if (logger.isDebugEnabled()) {
                            ex.printStackTrace();
                        }
                        logger.error((Object)("Failed to forward request " + request + " to target " + target));
                        allOK = false;
                    }
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Parameters for target " + targetRow + " not found"));
            }
        }
        return allOK;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

