/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class DateAndTime
extends MOMutableColumn {
    public DateAndTime(int columnID, MOAccess access, Variable defaultValue, boolean mutableInService) {
        super(columnID, 4, access, defaultValue, mutableInService);
    }

    public static int validateDateAndTime(Variable dateAndTime) {
        if (dateAndTime instanceof OctetString) {
            OctetString os = (OctetString)dateAndTime;
            if (os.length() != 8 && os.length() != 11) {
                return 8;
            }
            int month = os.get(2) & 0xFF;
            int date = os.get(3) & 0xFF;
            int hour = os.get(4) & 0xFF;
            int minute = os.get(5) & 0xFF;
            int second = os.get(6) & 0xFF;
            int deci = os.get(7) & 0xFF;
            if (month < 1 || month > 12 || date < 1 || date > 31 || hour > 23 || second > 59 || minute > 59 || deci > 9) {
                return 10;
            }
            if (os.length() == 11 && os.get(8) != 43 && os.get(8) != 45) {
                return 10;
            }
            return 0;
        }
        return 7;
    }

    public static OctetString makeDateAndTime(GregorianCalendar dateAndTime) {
        OctetString os = new OctetString();
        os.append((byte)(dateAndTime.get(1) / 256));
        os.append((byte)(dateAndTime.get(1) % 256));
        os.append((byte)dateAndTime.get(2));
        os.append((byte)dateAndTime.get(5));
        os.append((byte)dateAndTime.get(11));
        os.append((byte)dateAndTime.get(12));
        os.append((byte)dateAndTime.get(13));
        os.append((byte)(dateAndTime.get(14) / 100));
        if (dateAndTime.getTimeZone() != null) {
            TimeZone tz = dateAndTime.getTimeZone();
            os.append(tz.getRawOffset() >= 0 ? "+" : "-");
            os.append((byte)(tz.getRawOffset() / 60000));
            os.append((byte)(tz.getRawOffset() / 1000));
        }
        return os;
    }

    public static GregorianCalendar makeCalendar(OctetString dateAndTimeValue) {
        int year = (dateAndTimeValue.get(0) & 0xFF) * 256 + (dateAndTimeValue.get(1) & 0xFF);
        int month = dateAndTimeValue.get(2) & 0xFF;
        int date = dateAndTimeValue.get(3) & 0xFF;
        int hour = dateAndTimeValue.get(4) & 0xFF;
        int minute = dateAndTimeValue.get(5) & 0xFF;
        int second = dateAndTimeValue.get(6) & 0xFF;
        int deci = dateAndTimeValue.get(7) & 0xFF;
        String timezone = "GMT" + dateAndTimeValue.get(8) + dateAndTimeValue.get(9) + ":" + dateAndTimeValue.get(10);
        GregorianCalendar gc = new GregorianCalendar(year, month, date, hour, minute, second);
        gc.set(14, deci * 100);
        gc.setTimeZone(TimeZone.getTimeZone(timezone));
        return gc;
    }

    public synchronized int validate(Variable newValue, Variable oldValue) {
        return DateAndTime.validateDateAndTime(newValue);
    }

    public static MOScalar createMOScalar(OID oid, MOAccess access, OctetString value, final boolean localtime) {
        return new MOScalar(oid, access, (Variable)value){

            public int isValueOK(SubRequest sreq) {
                return DateAndTime.validateDateAndTime(sreq.getVariableBinding().getVariable());
            }

            public Variable getValue() {
                Variable value = super.getValue();
                if (localtime) {
                    value = DateAndTime.makeDateAndTime(new GregorianCalendar());
                }
                return value;
            }
        };
    }
}

