/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.util.Vector;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MOScalar
implements ManagedObject,
MOScope,
SerializableManagedObject {
    private OID oid;
    private Variable value;
    private MOAccess access;
    private boolean isVolatile;
    private transient Vector moValueValidationListeners;

    public MOScalar(OID id, MOAccess access, Variable value) {
        this.oid = id;
        this.access = access;
        this.value = value;
        this.isVolatile = MOScalar.isVolatileByDefault(value);
    }

    private static boolean isVolatileByDefault(Variable value) {
        if (value == null) {
            return true;
        }
        switch (value.getSyntax()) {
            case 65: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    public MOScope getScope() {
        return this;
    }

    public OID find(MOScope range) {
        if (this.access.isAccessibleForRead() && range.isCovered(this)) {
            return this.oid;
        }
        return null;
    }

    public void get(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (this.access.isAccessibleForRead()) {
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(this.getOid());
            vb.setVariable((Variable)this.getValue().clone());
            request.completed();
        } else {
            status.setErrorStatus(6);
        }
    }

    public boolean next(SubRequest request) {
        if (this.access.isAccessibleForRead() && request.getScope().isCovered(this)) {
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(this.getOid());
            vb.setVariable((Variable)this.getValue().clone());
            request.completed();
            return true;
        }
        return false;
    }

    public int isValueOK(SubRequest request) {
        if (this.moValueValidationListeners != null) {
            Variable oldValue = this.value;
            Variable newValue = request.getVariableBinding().getVariable();
            MOValueValidationEvent event = new MOValueValidationEvent(this, oldValue, newValue);
            this.fireValidate(event);
            return event.getValidationStatus();
        }
        return 0;
    }

    public void prepare(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (this.access.isAccessibleForWrite()) {
            VariableBinding vb = request.getVariableBinding();
            if (vb.getVariable().getSyntax() != this.getValue().getSyntax()) {
                status.setErrorStatus(7);
                return;
            }
            int valueOK = this.isValueOK(request);
            status.setErrorStatus(valueOK);
            status.setPhaseComplete(true);
        } else {
            status.setErrorStatus(17);
        }
    }

    public void commit(SubRequest request) {
        RequestStatus status = request.getStatus();
        VariableBinding vb = request.getVariableBinding();
        request.setUndoValue(this.getValue());
        this.setValue(vb.getVariable());
        status.setPhaseComplete(true);
    }

    public void undo(SubRequest request) {
        RequestStatus status = request.getStatus();
        if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
            int errorStatus = this.setValue((Variable)request.getUndoValue());
            status.setErrorStatus(errorStatus);
            status.setPhaseComplete(true);
        } else {
            status.setErrorStatus(15);
        }
    }

    public void cleanup(SubRequest request) {
        request.setUndoValue(null);
        request.getStatus().setPhaseComplete(true);
    }

    public OID getOid() {
        return this.oid;
    }

    public OID getLowerBound() {
        return this.oid;
    }

    public OID getUpperBound() {
        return this.oid;
    }

    public boolean isCovered(MOScope other) {
        return other.isLowerIncluded() && other.isUpperIncluded() && this.oid.equals((Object)other.getLowerBound()) && this.oid.equals((Object)other.getUpperBound());
    }

    public boolean isLowerIncluded() {
        return true;
    }

    public boolean isUpperIncluded() {
        return true;
    }

    public Variable getValue() {
        return this.value;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int setValue(Variable value) {
        this.value = value;
        return 0;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    public synchronized void addMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners == null) {
            this.moValueValidationListeners = new Vector(2);
        }
        this.moValueValidationListeners.add(l);
    }

    public synchronized void removeMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners != null) {
            this.moValueValidationListeners.remove(l);
        }
    }

    protected void fireValidate(MOValueValidationEvent validationEvent) {
        if (this.moValueValidationListeners != null) {
            Vector listeners = this.moValueValidationListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOValueValidationListener)listeners.elementAt(i)).validate(validationEvent);
            }
        }
    }

    public OID getID() {
        return this.getOid();
    }

    public synchronized void load(MOInput input) throws IOException {
        Variable v = input.readVariable();
        this.setValue(v);
    }

    public synchronized void save(MOOutput output) throws IOException {
        output.writeVariable(this.value);
    }

    public boolean covers(OID oid) {
        return this.oid.equals((Object)oid);
    }
}

