/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.smi.OID;

public class DefaultMOTableModel
implements MOTableModel {
    protected SortedMap rows = Collections.synchronizedSortedMap(new TreeMap());
    protected int columnCount = 0;

    public MOTableRow addRow(MOTableRow row) {
        this.columnCount = Math.max(row.size(), this.columnCount);
        return this.rows.put(row.getIndex(), row);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public synchronized MOTableRow getRow(OID index) {
        return (MOTableRow)this.rows.get(index);
    }

    public OID firstIndex() {
        if (this.rows.size() > 0) {
            return (OID)this.rows.firstKey();
        }
        return null;
    }

    public synchronized Iterator iterator() {
        return this.rows.values().iterator();
    }

    public synchronized MOTableRow firstRow() {
        OID index = this.firstIndex();
        if (index != null) {
            return (MOTableRow)this.rows.get(index);
        }
        return null;
    }

    public OID lastIndex() {
        if (this.rows.size() > 0) {
            return (OID)this.rows.lastKey();
        }
        return null;
    }

    public synchronized MOTableRow lastRow() {
        OID index = this.lastIndex();
        if (index != null) {
            return (MOTableRow)this.rows.get(index);
        }
        return null;
    }

    public boolean containsRow(OID index) {
        return this.rows.containsKey(index);
    }

    public synchronized Iterator tailIterator(OID lowerBound) {
        if (lowerBound == null) {
            return this.iterator();
        }
        return this.rows.tailMap(lowerBound).values().iterator();
    }
}

