/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.Vector;
import org.snmp4j.agent.mo.DefaultMOTableModel;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTableModelEvent;
import org.snmp4j.agent.mo.MOTableModelListener;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOMutableTableModel
extends DefaultMOTableModel
implements MOMutableTableModel {
    protected MOTableRowFactory rowFactory;
    private transient Vector moTableModelListeners;

    public MOTableRowFactory getRowFactory() {
        return this.rowFactory;
    }

    public synchronized List getRows(OID lowerBound, OID upperBoundEx) {
        ArrayList view = new ArrayList(this.getView(lowerBound, upperBoundEx).values());
        return view;
    }

    public synchronized List getRows(OID lowerBound, OID upperBoundEx, MOTableRowFilter filter) {
        LinkedList<MOTableRow> result = new LinkedList<MOTableRow>();
        SortedMap view = this.getView(lowerBound, upperBoundEx);
        Iterator it = view.values().iterator();
        while (it.hasNext()) {
            MOTableRow row = (MOTableRow)it.next();
            if (!filter.passesFilter(row)) continue;
            result.add(row);
        }
        return result;
    }

    private SortedMap getView(OID lowerBound, OID upperBoundEx) {
        SortedMap view = lowerBound == null && upperBoundEx == null ? this.rows : (lowerBound == null ? this.rows.headMap(upperBoundEx) : (upperBoundEx == null ? this.rows.tailMap(lowerBound) : this.rows.subMap(lowerBound, upperBoundEx)));
        return view;
    }

    public synchronized MOTableRow removeRow(OID index) {
        MOTableRow row = (MOTableRow)this.rows.remove(index);
        if (row != null && this.moTableModelListeners != null) {
            MOTableModelEvent event = new MOTableModelEvent(this, 2, row);
            this.fireTableModelChanged(event);
        }
        return row;
    }

    public synchronized void removeRows(OID lowerBoundIncl, OID upperBoundExcl) {
        Map.Entry item;
        SortedMap m = this.rows.tailMap(lowerBoundIncl);
        Iterator it = m.entrySet().iterator();
        while (it.hasNext() && upperBoundExcl.compareTo((item = it.next()).getKey()) > 0) {
            if (this.moTableModelListeners != null) {
                MOTableModelEvent event = new MOTableModelEvent(this, 2, (MOTableRow)item.getValue());
                this.fireTableModelChanged(event);
            }
            it.remove();
        }
    }

    public synchronized void clear() {
        this.fireTableModelChanged(new MOTableModelEvent(this, 3));
        this.rows.clear();
    }

    public synchronized void clear(MOTableRowFilter filter) {
        Iterator it = this.rows.values().iterator();
        while (it.hasNext()) {
            MOTableRow row = (MOTableRow)it.next();
            if (filter.passesFilter(row)) continue;
            it.remove();
        }
    }

    public synchronized Iterator iterator(MOTableRowFilter filter) {
        return new FilteredRowIterator(filter);
    }

    public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
        if (this.rowFactory == null) {
            throw new UnsupportedOperationException("No row factory");
        }
        return this.rowFactory.createRow(index, values);
    }

    public void setRowFactory(MOTableRowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void freeRow(MOTableRow row) {
        if (this.rowFactory != null) {
            this.rowFactory.freeRow(row);
        }
    }

    public synchronized void addMOTableModelListener(MOTableModelListener l) {
        if (this.moTableModelListeners == null) {
            this.moTableModelListeners = new Vector(2);
        }
        this.moTableModelListeners.add(l);
    }

    public synchronized void removeMOTableModelListener(MOTableModelListener l) {
        if (this.moTableModelListeners != null) {
            this.moTableModelListeners.remove(l);
        }
    }

    protected void fireTableModelChanged(MOTableModelEvent event) {
        if (this.moTableModelListeners != null) {
            Vector listeners = this.moTableModelListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((MOTableModelListener)listeners.elementAt(i)).tableModelChanged(event);
            }
        }
    }

    public MOTableRow addRow(MOTableRow row) {
        MOTableRow newRow = super.addRow(row);
        if (this.moTableModelListeners != null) {
            MOTableModelEvent event = new MOTableModelEvent(this, 1, row);
            this.fireTableModelChanged(event);
        }
        return newRow;
    }

    public class FilteredRowIterator
    implements Iterator {
        private Iterator iterator;
        private MOTableRowFilter filter;
        private MOTableRow next;

        FilteredRowIterator(MOTableRowFilter filter) {
            this.filter = filter;
            this.iterator = DefaultMOMutableTableModel.this.iterator();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.findNext();
            return this.next != null;
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.next = (MOTableRow)this.iterator.next();
                if (this.filter.passesFilter(this.next)) break;
                this.next = null;
            }
        }

        public Object next() {
            if (this.next == null) {
                this.findNext();
            }
            if (this.next != null) {
                MOTableRow retval = this.next;
                this.next = null;
                return retval;
            }
            throw new NoSuchElementException();
        }
    }
}

