/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.snmp4j.agent.ContextEvent;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OctetString;

public class DefaultMOServer
implements MOServer {
    private static final LogAdapter logger = LogFactory.getLogger((Class)(class$org$snmp4j$agent$DefaultMOServer == null ? (class$org$snmp4j$agent$DefaultMOServer = DefaultMOServer.class$("org.snmp4j.agent.DefaultMOServer")) : class$org$snmp4j$agent$DefaultMOServer));
    private Set contexts;
    private SortedMap registry = Collections.synchronizedSortedMap(new TreeMap(new MOScopeComparator()));
    private Map lockList;
    private Map lookupListener;
    private transient Vector contextListeners;
    static /* synthetic */ Class class$org$snmp4j$agent$DefaultMOServer;

    public DefaultMOServer() {
        this.contexts = new LinkedHashSet(10);
        this.lockList = new Hashtable(10);
    }

    public ManagedObject lookup(MOQuery query) {
        SortedMap scope = this.registry.tailMap(query);
        Iterator it = scope.values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof ManagedObject) {
                ManagedObject mo = (ManagedObject)o;
                MOScope moScope = mo.getScope();
                if (!query.getScope().isOverlapping(moScope) || !query.matchesQuery(mo)) continue;
                this.fireLookupEvent(mo, query);
                return mo;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn((Object)("Object looked up is not a ManagedObject: " + o));
        }
        return null;
    }

    protected void fireLookupEvent(ManagedObject mo, MOQuery query) {
        List l;
        if (this.lookupListener != null && (l = (List)this.lookupListener.get(mo)) != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MOServerLookupListener item = (MOServerLookupListener)it.next();
                item.lookupEvent(event);
            }
        }
    }

    public OctetString[] getContexts() {
        return this.contexts.toArray(new OctetString[0]);
    }

    public boolean isContextSupported(OctetString context) {
        if (context == null) {
            return true;
        }
        return this.contexts.contains(context);
    }

    public SortedMap getRegistry() {
        return this.registry;
    }

    public void register(ManagedObject mo, OctetString context) throws DuplicateRegistrationException {
        if (context == null) {
            if (this.registry.get(mo.getScope()) != null) {
                throw new DuplicateRegistrationException(mo.getScope());
            }
            this.registry.put(mo.getScope(), mo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered MO " + mo + " in default context with scope " + mo.getScope()));
            }
        } else {
            DefaultMOContextScope scope = new DefaultMOContextScope(context, mo.getScope());
            if (this.registry.get(scope) != null) {
                throw new DuplicateRegistrationException(scope);
            }
            this.registry.put(scope, mo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered MO " + mo + " in context " + context + "with scope " + scope));
            }
        }
    }

    public void unregister(ManagedObject mo, OctetString context) {
        if (context == null) {
            this.registry.remove(mo.getScope());
        } else {
            this.registry.remove(new DefaultMOContextScope(context, mo.getScope()));
        }
    }

    public void addContext(OctetString context) {
        this.contexts.add(context);
    }

    public void removeContext(OctetString context) {
        this.contexts.remove(context);
    }

    public synchronized void lock(Object owner, ManagedObject managedObject) {
        Lock lock;
        do {
            if ((lock = (Lock)this.lockList.get(managedObject)) == null) {
                this.lockList.put(managedObject, new Lock(owner));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Acquired lock on " + managedObject + " for " + owner));
                continue;
            }
            if (lock.getOwner() != owner) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Waiting for lock on " + managedObject));
                    }
                    this.wait();
                    continue;
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            lock.add();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added lock on " + managedObject + " for " + owner));
            }
            return;
        } while (lock != null);
    }

    public synchronized void unlock(Object owner, ManagedObject managedObject) {
        Lock lock = (Lock)this.lockList.get(managedObject);
        if (lock == null) {
            return;
        }
        if (lock.getOwner() != owner) {
            throw new IllegalStateException("Object '" + owner + "' is not owner of lock: " + lock);
        }
        if (lock.remove()) {
            this.lockList.remove(managedObject);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed lock on " + managedObject + " by " + owner));
            }
            this.notify();
        }
    }

    public Iterator iterator() {
        return this.getRegistry().values().iterator();
    }

    public void addLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List<MOServerLookupListener> l;
        if (this.lookupListener == null) {
            this.lookupListener = Collections.synchronizedMap(new HashMap());
        }
        if ((l = (List<MOServerLookupListener>)this.lookupListener.get(mo)) == null) {
            l = Collections.synchronizedList(new LinkedList());
            this.lookupListener.put(mo, l);
        }
        l.add(listener);
    }

    public boolean removeLookupListener(MOServerLookupListener listener, ManagedObject mo) {
        List l;
        if (this.lookupListener != null && (l = (List)this.lookupListener.get(mo)) != null) {
            return l.remove(listener);
        }
        return false;
    }

    public synchronized void addContextListener(ContextListener l) {
        if (this.contextListeners == null) {
            this.contextListeners = new Vector(2);
        }
        this.contextListeners.add(l);
    }

    public synchronized void removeContextListener(ContextListener l) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(l);
        }
    }

    protected void fireContextChanged(ContextEvent event) {
        if (this.contextListeners != null) {
            Vector listeners = this.contextListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ContextListener)listeners.elementAt(i)).contextChanged(event);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("[contexts=" + this.contexts);
        buf.append("[keys={");
        Iterator it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            MOScope scope = (MOScope)it.next();
            buf.append(scope.getLowerBound());
            if (scope.isLowerIncluded()) {
                buf.append("+");
            }
            buf.append("-");
            buf.append(scope.getUpperBound());
            if (scope.isUpperIncluded()) {
                buf.append("+");
            }
            if (scope instanceof MOContextScope) {
                buf.append("(" + ((MOContextScope)scope).getContext() + ")");
            }
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        buf.append(",registry=" + this.registry);
        buf.append(",lockList=" + this.lockList);
        buf.append(",lookupListener=" + this.lookupListener);
        buf.append("]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Lock {
        private Object owner;
        private long creationTime = System.currentTimeMillis();
        private int count = 0;

        private Lock() {
        }

        Lock(Object owner) {
            this();
            this.owner = owner;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void add() {
            ++this.count;
        }

        public synchronized boolean remove() {
            return --this.count <= 0;
        }

        public Object getOwner() {
            return this.owner;
        }
    }
}

