/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.io.DefaultMOInput;
import org.snmp4j.agent.io.DefaultMOOutput;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.ProxyForwarderImpl;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpFrameworkMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public abstract class BaseAgent
implements Runnable,
MOPersistenceProvider {
    private static final LogAdapter logger = LogFactory.getLogger((Class)(class$org$snmp4j$agent$BaseAgent == null ? (class$org$snmp4j$agent$BaseAgent = BaseAgent.class$("org.snmp4j.agent.BaseAgent")) : class$org$snmp4j$agent$BaseAgent));
    protected SNMPv2MIB snmpv2MIB;
    protected SnmpFrameworkMIB snmpFrameworkMIB;
    protected SnmpTargetMIB snmpTargetMIB;
    protected SnmpNotificationMIB snmpNotificationMIB;
    protected SnmpProxyMIB snmpProxyMIB;
    protected SnmpCommunityMIB snmpCommunityMIB;
    protected Snmp4jLogMib snmp4jLogMIB;
    protected Snmp4jConfigMib snmp4jConfigMIB;
    protected UsmMIB usmMIB;
    protected VacmMIB vacmMIB;
    protected DefaultMOServer server;
    protected Snmp session;
    protected TransportMapping[] transportMappings;
    protected MessageDispatcherImpl dispatcher;
    protected CommandProcessor agent;
    protected MPv3 mpv3;
    protected USM usm;
    protected File configFile;
    protected File bootCounterFile;
    protected NotificationOriginator notificationOriginator;
    protected ProxyForwarder defaultProxyForwarder;
    protected OctetString sysDescr = new OctetString("SNMP4J-Agent - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
    protected OID sysOID = new OID("1.3.6.1.4.1.4976");
    protected Integer32 sysServices = new Integer32(10);
    static /* synthetic */ Class class$org$snmp4j$agent$BaseAgent;

    protected BaseAgent() {
        this.server = new DefaultMOServer();
    }

    protected BaseAgent(File bootCounterFile, File configFile, CommandProcessor commandProcessor) {
        this();
        this.configFile = configFile;
        this.bootCounterFile = bootCounterFile;
        this.agent = commandProcessor;
    }

    public void init() throws IOException {
        this.initTransportMappings();
        this.initMessageDispatcher();
        this.server.addContext(new OctetString());
        this.snmpv2MIB = new SNMPv2MIB(this.sysDescr, this.sysOID, this.sysServices);
        this.dispatcher.addCounterListener((CounterListener)this.snmpv2MIB);
        this.agent.addCounterListener(this.snmpv2MIB);
        this.snmpFrameworkMIB = new SnmpFrameworkMIB((USM)this.mpv3.getSecurityModel(3), this.dispatcher.getTransportMappings());
        this.usmMIB = new UsmMIB(this.usm, SecurityProtocols.getInstance());
        this.usm.addUsmUserListener((UsmUserListener)this.usmMIB);
        this.vacmMIB = new VacmMIB(this.server);
        this.snmpTargetMIB = new SnmpTargetMIB(this.session);
        this.snmpNotificationMIB = new SnmpNotificationMIB();
        this.snmpCommunityMIB = new SnmpCommunityMIB(this.snmpTargetMIB);
        this.snmp4jLogMIB = new Snmp4jLogMib();
        this.snmp4jConfigMIB = new Snmp4jConfigMib(this.snmpv2MIB.getSysUpTime());
        this.snmp4jConfigMIB.setSnmpCommunityMIB(this.snmpCommunityMIB);
        this.snmp4jConfigMIB.setDefaultConfigFile(this.configFile);
        this.snmp4jConfigMIB.setPersistenceProvider(1, this);
        this.snmpProxyMIB = new SnmpProxyMIB();
        this.notificationOriginator = new NotificationOriginatorImpl(this.session, this.vacmMIB, this.snmpv2MIB.getSysUpTime(), this.snmpTargetMIB, this.snmpNotificationMIB);
        this.setupDefaultProxyForwarder();
        this.addUsmUser(this.usm);
        this.addCommunities(this.snmpCommunityMIB);
        this.registerSnmpMIBs();
        this.finishInit();
    }

    protected void registerSnmpMIBs() {
        try {
            this.snmpTargetMIB.registerMOs(this.server, null);
            this.snmpNotificationMIB.registerMOs(this.server, null);
            this.vacmMIB.registerMOs(this.server, null);
            this.usmMIB.registerMOs(this.server, null);
            this.snmpv2MIB.registerMOs(this.server, null);
            this.snmpFrameworkMIB.registerMOs(this.server, null);
            this.snmpCommunityMIB.registerMOs(this.server, null);
            this.snmp4jLogMIB.registerMOs(this.server, null);
            this.snmp4jConfigMIB.registerMOs(this.server, null);
            this.snmpProxyMIB.registerMOs(this.server, null);
            this.registerManagedObjects();
        }
        catch (DuplicateRegistrationException ex) {
            ex.printStackTrace();
        }
    }

    protected void unregisterSnmpMIBs() {
        this.snmpTargetMIB.unregisterMOs(this.server, null);
        this.snmpNotificationMIB.unregisterMOs(this.server, null);
        this.vacmMIB.unregisterMOs(this.server, null);
        this.usmMIB.unregisterMOs(this.server, null);
        this.snmpv2MIB.unregisterMOs(this.server, null);
        this.snmpFrameworkMIB.unregisterMOs(this.server, null);
        this.snmpCommunityMIB.unregisterMOs(this.server, null);
        this.snmp4jLogMIB.unregisterMOs(this.server, null);
        this.snmp4jConfigMIB.unregisterMOs(this.server, null);
        this.snmpProxyMIB.unregisterMOs(this.server, null);
        this.unregisterManagedObjects();
    }

    protected abstract void registerManagedObjects();

    protected abstract void unregisterManagedObjects();

    protected void setupDefaultProxyForwarder() {
        this.defaultProxyForwarder = new ProxyForwarderImpl(this.session, this.snmpProxyMIB, this.snmpTargetMIB);
        this.agent.addProxyForwarder(this.defaultProxyForwarder, null, 0);
    }

    public void loadConfig(int importMode) {
        try {
            FileInputStream fis = null;
            fis = new FileInputStream(this.configFile);
            this.loadConfig(fis, importMode);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    public void loadConfig(InputStream configFile, int importMode) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(configFile);
        DefaultMOInput is = new DefaultMOInput(ois);
        is.setOverwriteMode(importMode);
        MOServerPersistence p = new MOServerPersistence(this.server);
        p.loadData(is);
        ois.close();
    }

    public void saveConfig() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.configFile);
            this.saveConfig(fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    public void saveConfig(OutputStream configFile) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(configFile);
        DefaultMOOutput os = new DefaultMOOutput(oos);
        MOServerPersistence p = new MOServerPersistence(this.server);
        p.saveData(os);
        oos.flush();
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                BaseAgent.this.saveConfig();
            }
        });
    }

    protected void finishInit() {
        this.agent.addMOServer(this.server);
        this.agent.setCoexistenceProvider(this.snmpCommunityMIB);
        this.addViews(this.vacmMIB);
        this.addNotificationTargets(this.snmpTargetMIB, this.snmpNotificationMIB);
        this.agent.setVacm(this.vacmMIB);
        this.dispatcher.addCommandResponder((CommandResponder)this.agent);
        this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
    }

    public void run() {
        try {
            this.session.listen();
        }
        catch (IOException iox) {
            logger.error((Object)iox);
        }
    }

    protected void initMessageDispatcher() {
        this.dispatcher = new MessageDispatcherImpl();
        this.session = new Snmp((MessageDispatcher)this.dispatcher);
        this.mpv3 = new MPv3(this.agent.getContextEngineID().getValue());
        this.usm = new USM(SecurityProtocols.getInstance(), this.agent.getContextEngineID(), this.updateEngineBoots());
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        SecurityProtocols.getInstance().addDefaultProtocols();
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        this.dispatcher.addMessageProcessingModel((MessageProcessingModel)this.mpv3);
        for (int i = 0; i < this.transportMappings.length; ++i) {
            this.session.addTransportMapping(this.transportMappings[i]);
        }
    }

    protected int updateEngineBoots() {
        int boots = this.getEngineBoots();
        if (++boots <= 0) {
            boots = 1;
        }
        this.setEngineBoots(boots);
        return boots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getEngineBoots() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.bootCounterFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            int boots = ois.readInt();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Engine boots is: " + boots));
            }
            int n = boots;
            return n;
        }
        catch (FileNotFoundException ex) {
            logger.warn((Object)("Could not find conig file: " + this.configFile));
        }
        catch (IOException iox) {
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            logger.error((Object)("Failed to read boot counter: " + iox.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex1) {
                    logger.warn((Object)ex1);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEngineBoots(int engineBoots) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.bootCounterFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(engineBoots);
            oos.close();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Wrote boot counter: " + engineBoots));
            }
        }
        catch (FileNotFoundException fnfex) {
            logger.error((Object)("Boot counter configuration file not found: " + fnfex.getMessage()));
        }
        catch (IOException iox) {
            logger.error((Object)("Failed to write boot counter: " + iox.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex1) {
                    logger.warn((Object)ex1);
                }
            }
        }
    }

    protected abstract void addUsmUser(USM var1);

    protected abstract void addNotificationTargets(SnmpTargetMIB var1, SnmpNotificationMIB var2);

    protected abstract void addViews(VacmMIB var1);

    protected abstract void addCommunities(SnmpCommunityMIB var1);

    protected void initTransportMappings() throws IOException {
        this.transportMappings = new TransportMapping[1];
        this.transportMappings[0] = new DefaultUdpTransportMapping(new UdpAddress("0.0.0.0/161"));
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public void setDefaultProxyForwarder(ProxyForwarder defaultProxyForwarder) {
        this.defaultProxyForwarder = defaultProxyForwarder;
    }

    public void setSysDescr(OctetString sysDescr) {
        this.sysDescr = sysDescr;
    }

    public void setSysOID(OID sysOID) {
        this.sysOID = sysOID;
    }

    public void setSysServices(Integer32 sysServices) {
        this.sysServices = sysServices;
    }

    public void setAgent(CommandProcessor agent) {
        this.agent = agent;
    }

    public void setBootCounterFile(File bootCounterFile) {
        this.bootCounterFile = bootCounterFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public ProxyForwarder getDefaultProxyForwarder() {
        return this.defaultProxyForwarder;
    }

    public OctetString getSysDescr() {
        return this.sysDescr;
    }

    public OID getSysOID() {
        return this.sysOID;
    }

    public Integer32 getSysServices() {
        return this.sysServices;
    }

    public CommandProcessor getAgent() {
        return this.agent;
    }

    public File getBootCounterFile() {
        return this.bootCounterFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Snmp4jConfigMib getSnmp4jConfigMIB() {
        return this.snmp4jConfigMIB;
    }

    public Snmp4jLogMib getSnmp4jLogMIB() {
        return this.snmp4jLogMIB;
    }

    public SnmpCommunityMIB getSnmpCommunityMIB() {
        return this.snmpCommunityMIB;
    }

    public SnmpFrameworkMIB getSnmpFrameworkMIB() {
        return this.snmpFrameworkMIB;
    }

    public SnmpNotificationMIB getSnmpNotificationMIB() {
        return this.snmpNotificationMIB;
    }

    public SnmpProxyMIB getSnmpProxyMIB() {
        return this.snmpProxyMIB;
    }

    public SnmpTargetMIB getSnmpTargetMIB() {
        return this.snmpTargetMIB;
    }

    public SNMPv2MIB getSnmpv2MIB() {
        return this.snmpv2MIB;
    }

    public UsmMIB getUsmMIB() {
        return this.usmMIB;
    }

    public VacmMIB getVacmMIB() {
        return this.vacmMIB;
    }

    public Snmp getSession() {
        return this.session;
    }

    public DefaultMOServer getServer() {
        return this.server;
    }

    public MPv3 getMPv3() {
        return this.mpv3;
    }

    public USM getUsm() {
        return this.usm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

