/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.operations;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.OnmsDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.importer.operations.DefaultImportStatistics;
import org.opennms.netmgt.importer.operations.ImportOperation;
import org.opennms.netmgt.importer.operations.ImportOperationFactory;
import org.opennms.netmgt.importer.operations.ImportStatistics;
import org.opennms.netmgt.importer.operations.InsertOperation;
import org.opennms.netmgt.importer.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.importer.operations.UpdateOperation;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOperationsManager {
    private List<ImportOperation> m_inserts = new LinkedList<ImportOperation>();
    private List<ImportOperation> m_updates = new LinkedList<ImportOperation>();
    private Map<String, Integer> m_foreignIdToNodeMap;
    private ImportOperationFactory m_operationFactory;
    private ImportStatistics m_stats = new DefaultImportStatistics();
    private EventIpcManager m_eventMgr;
    private int m_scanThreads = 50;
    private int m_writeThreads = 4;
    private String m_foreignSource;

    public ImportOperationsManager(Map<String, Integer> foreignIdToNodeMap, ImportOperationFactory operationFactory) {
        this.m_foreignIdToNodeMap = new HashMap<String, Integer>(foreignIdToNodeMap);
        this.m_operationFactory = operationFactory;
    }

    public SaveOrUpdateOperation foundNode(String foreignId, String nodeLabel, String building, String city) {
        if (this.nodeExists(foreignId)) {
            return this.updateNode(foreignId, nodeLabel, building, city);
        }
        return this.insertNode(foreignId, nodeLabel, building, city);
    }

    private boolean nodeExists(String foreignId) {
        return this.m_foreignIdToNodeMap.containsKey(foreignId);
    }

    private SaveOrUpdateOperation insertNode(String foreignId, String nodeLabel, String building, String city) {
        InsertOperation insertOperation = this.m_operationFactory.createInsertOperation(this.getForeignSource(), foreignId, nodeLabel, building, city);
        this.m_inserts.add(insertOperation);
        return insertOperation;
    }

    private SaveOrUpdateOperation updateNode(String foreignId, String nodeLabel, String building, String city) {
        Integer nodeId = this.processForeignId(foreignId);
        UpdateOperation updateOperation = this.m_operationFactory.createUpdateOperation(nodeId, this.getForeignSource(), foreignId, nodeLabel, building, city);
        this.m_updates.add(updateOperation);
        return updateOperation;
    }

    private Integer processForeignId(String foreignId) {
        return this.m_foreignIdToNodeMap.remove(foreignId);
    }

    public int getOperationCount() {
        return this.m_inserts.size() + this.m_updates.size() + this.m_foreignIdToNodeMap.size();
    }

    public int getInsertCount() {
        return this.m_inserts.size();
    }

    public int getUpdateCount() {
        return this.m_updates.size();
    }

    public int getDeleteCount() {
        return this.m_foreignIdToNodeMap.size();
    }

    public void persistOperations(TransactionTemplate template, OnmsDao dao) {
        this.m_stats.beginProcessingOps();
        this.m_stats.setDeleteCount(this.getDeleteCount());
        this.m_stats.setInsertCount(this.getInsertCount());
        this.m_stats.setUpdateCount(this.getUpdateCount());
        PooledExecutor dbPool = new PooledExecutor((Channel)new LinkedQueue());
        dbPool.setMinimumPoolSize(this.m_writeThreads);
        this.preprocessOperations(template, dao, new OperationIterator(), dbPool);
        dbPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        try {
            dbPool.awaitTerminationAfterShutdown();
        }
        catch (InterruptedException e) {
            this.log().error((Object)"persister interrupted!", (Throwable)e);
        }
        this.m_stats.finishProcessingOps();
    }

    private void preprocessOperations(final TransactionTemplate template, final OnmsDao dao, OperationIterator iterator, final PooledExecutor dbPool) {
        this.m_stats.beginPreprocessingOps();
        PooledExecutor threadPool = new PooledExecutor((Channel)new LinkedQueue());
        threadPool.setMinimumPoolSize(this.m_scanThreads);
        OperationIterator it = iterator;
        while (it.hasNext()) {
            final ImportOperation oper = (ImportOperation)it.next();
            Runnable r = new Runnable(){

                public void run() {
                    ImportOperationsManager.this.preprocessOperation(oper, template, dao, dbPool);
                }
            };
            try {
                threadPool.execute(r);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted!");
                e.printStackTrace();
            }
            it.remove();
        }
        threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        try {
            threadPool.awaitTerminationAfterShutdown();
        }
        catch (InterruptedException e) {
            this.log().error((Object)"preprocessor interrupted!", (Throwable)e);
        }
        this.m_stats.finishPreprocessingOps();
    }

    protected void preprocessOperation(final ImportOperation oper, final TransactionTemplate template, final OnmsDao dao, PooledExecutor dbPool) {
        this.m_stats.beginPreprocessing(oper);
        this.log().info((Object)("Preprocess: " + oper));
        oper.gatherAdditionalData();
        Runnable r = new Runnable(){

            public void run() {
                ImportOperationsManager.this.persistOperation(oper, template, dao);
            }
        };
        try {
            dbPool.execute(r);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.m_stats.finishPreprocessing(oper);
    }

    protected void persistOperation(final ImportOperation oper, TransactionTemplate template, OnmsDao dao) {
        this.m_stats.beginPersisting(oper);
        this.log().info((Object)("Persist: " + oper));
        List events = (List)template.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                List result = oper.persist();
                return result;
            }
        });
        this.m_stats.finishPersisting(oper);
        if (this.m_eventMgr != null && events != null) {
            this.m_stats.beginSendingEvents(oper, events);
            this.log().info((Object)("Send Events: " + oper));
            for (Event event : events) {
                this.m_eventMgr.sendNow(event);
            }
            this.m_stats.finishSendingEvents(oper, events);
        }
        this.log().info((Object)("Clear cache: " + oper));
        dao.clear();
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setScanThreads(int scanThreads) {
        this.m_scanThreads = scanThreads;
    }

    public void setWriteThreads(int writeThreads) {
        this.m_writeThreads = writeThreads;
    }

    public EventIpcManager getEventMgr() {
        return this.m_eventMgr;
    }

    public void setEventMgr(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public ImportStatistics getStats() {
        return this.m_stats;
    }

    public void setStats(ImportStatistics stats) {
        this.m_stats = stats;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    class OperationIterator
    implements Iterator {
        Iterator m_iterIter;
        Iterator m_currentIter;

        OperationIterator() {
            ArrayList iters = new ArrayList(3);
            iters.add(new DeleteIterator());
            iters.add(ImportOperationsManager.this.m_updates.iterator());
            iters.add(ImportOperationsManager.this.m_inserts.iterator());
            this.m_iterIter = iters.iterator();
        }

        public boolean hasNext() {
            while ((this.m_currentIter == null || !this.m_currentIter.hasNext()) && this.m_iterIter.hasNext()) {
                this.m_currentIter = (Iterator)this.m_iterIter.next();
                this.m_iterIter.remove();
            }
            return this.m_currentIter == null ? false : this.m_currentIter.hasNext();
        }

        public Object next() {
            return this.m_currentIter.next();
        }

        public void remove() {
            this.m_currentIter.remove();
        }
    }

    class DeleteIterator
    implements Iterator {
        private Iterator m_foreignIdIterator;

        DeleteIterator() {
            this.m_foreignIdIterator = ImportOperationsManager.this.m_foreignIdToNodeMap.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.m_foreignIdIterator.hasNext();
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.m_foreignIdIterator.next();
            Integer nodeId = (Integer)entry.getValue();
            String foreignId = (String)entry.getKey();
            return ImportOperationsManager.this.m_operationFactory.createDeleteOperation(nodeId, ImportOperationsManager.this.m_foreignSource, foreignId);
        }

        public void remove() {
            this.m_foreignIdIterator.remove();
        }
    }
}

