/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.xml.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RMISecurityManager;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.oss.fm.monitor.JVTAlarmMonitorHome;
import javax.oss.fm.monitor.JVTAlarmMonitorSession;
import javax.rmi.PortableRemoteObject;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitor;
import org.openoss.ossj.xml.tests.PropertiesLoader;

public class TestJmsXml {
    private static Properties env;
    private static PropertiesLoader props;
    private static String jnp_host;
    private static JVTAlarmMonitorHome home;
    private static JVTAlarmMonitorSession session;
    private static AlarmMonitor alarmInternals;
    private static Object ref;
    private static Topic eventTopic;
    private static TopicSession jmsSession;
    private static TopicConnection conn;
    private static TopicSession jmsSession2;
    private static TopicConnection conn2;
    private static Topic xvteventTopic;
    private static QueueSession jmsSession3;
    private static QueueConnection queueConnection;
    private static Queue xmlMessageQueue;
    private static boolean CONNECTED;
    private AlarmMonitor am = null;
    int NotifyAlarmListRebuiltEvent_count = 0;
    int NotifyNewAlarmEvent_count = 0;
    int NotifyClearedAlarmEvent_count = 0;
    int NotifyChangedAlarmEvent_count = 0;
    int NotifyAckStateChangedEvent_count = 0;
    int NotifyAlarmCommentsEvent_count = 0;
    int UnknownObjectMessage_count = 0;
    int NonObjectMessage_count = 0;
    int UnknownIRPEvt_count = 0;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void main(String[] args) {
        String helptxt = "Valid input options:\n-h : help\n-t : test\n";
        int run_mode = -1;
        String host = "";
        boolean port = false;
        System.out.print("***starting xml test***\n");
        if (args.length == 0) {
            System.out.print("Error: No args set:\n");
            System.out.print(helptxt);
        } else if ("-h".equals(args[0])) {
            System.out.print("Help:\n");
        } else if ("-t".equals(args[0])) {
            System.out.print("test load of variables:\n");
            TestJmsXml t = new TestJmsXml();
            t.loadClientProperties();
            try {
                System.out.println("Initialise Session: ");
                t.init();
                t.testone();
                t.testtwo();
                t.testthree();
            }
            catch (Exception e) {
                System.out.print("failed init:\n");
            }
            try {
                t.kill();
            }
            catch (Exception e) {
                System.out.print("failed kill:\n");
            }
        }
        System.out.print("*** End of Program ***\n");
    }

    public void testone() {
        TopicSubscriber eventSubscriber = null;
        try {
            System.out.println(" - subscribing to messages: ");
            eventSubscriber = jmsSession.createSubscriber(eventTopic);
        }
        catch (Exception e) {
            System.out.println("Error Session subscribed: " + e);
        }
        TopicPublisher eventPublisher = null;
        try {
            String s = " this is a test message";
            System.out.println("creating message: ");
            eventPublisher = jmsSession.createPublisher(eventTopic);
            System.out.println("publisher created");
            System.out.println("Sending JMS message");
            eventPublisher.publish((Message)jmsSession.createObjectMessage((Serializable)((Object)s)));
            System.out.println("sendTestMessage() - JMS event sent");
        }
        catch (Exception e) {
            System.out.println("Error creating message: " + e);
        }
        try {
            System.out.println(" - waiting for messages: ");
            Message msg = eventSubscriber.receive();
            Serializable o = ((ObjectMessage)msg).getObject();
            if (o instanceof String) {
                System.out.println("Recieved message :" + o);
            }
            System.out.println("Message received: " + msg.toString());
        }
        catch (Exception e) {
            System.out.println("Error Session receive: " + e);
        }
    }

    public void testtwo() {
        TopicSubscriber eventSubscriber = null;
        try {
            System.out.println("test two - subscribing to queue messages: ");
            eventSubscriber = jmsSession2.createSubscriber(xvteventTopic);
        }
        catch (Exception e) {
            System.out.println("Error Session subscribed: " + e);
        }
        TopicPublisher eventPublisher = null;
        try {
            String s = " this is a test text message";
            System.out.println("creating message: ");
            eventPublisher = jmsSession2.createPublisher(xvteventTopic);
            System.out.println("publisher created");
            System.out.println("Sending JMS message");
            eventPublisher.publish((Message)jmsSession2.createTextMessage(s));
            System.out.println("sendTestMessage() - JMS event sent");
        }
        catch (Exception e) {
            System.out.println("Error creating message: " + e);
        }
        try {
            System.out.println(" - waiting for messages: ");
            TextMessage tm = (TextMessage)eventSubscriber.receive();
            String received = tm.getText();
            System.out.println("Recieved message :" + received);
            System.out.println("msg.toString(): " + tm.toString());
        }
        catch (Exception e) {
            System.out.println("Error Session receive: " + e);
        }
    }

    public void testthree() {
        QueueReceiver queueReceiver = null;
        try {
            System.out.println("test two - subscribing to receiving queue xvt messages: ");
            queueReceiver = jmsSession3.createReceiver(xmlMessageQueue);
        }
        catch (Exception e) {
            System.out.println("Error Session subscribed: " + e);
        }
        QueueSender queueSender = null;
        try {
            String s = " this is a queue test text message";
            System.out.println("creating message: ");
            queueSender = jmsSession3.createSender(xmlMessageQueue);
            System.out.println("sender created");
            System.out.println("Sending JMS message");
            queueSender.send((Message)jmsSession3.createTextMessage(s));
            System.out.println("sendTestMessage() - JMS  sent");
        }
        catch (Exception e) {
            System.out.println("Error creating message: " + e);
        }
        try {
            System.out.println(" - waiting for messages: ");
            TextMessage tm = (TextMessage)queueReceiver.receive();
            String received = tm.getText();
            System.out.println("Recieved message :" + received);
            System.out.println("msg.toString(): " + tm.toString());
        }
        catch (Exception e) {
            System.out.println("Error Session receive: " + e);
        }
    }

    private void loadClientProperties() {
        try {
            props = PropertiesLoader.getInstance();
        }
        catch (FileNotFoundException fnf_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            System.out.println("Could not find properties file: " + propertiesFilename + fnf_ex);
            throw new UndeclaredThrowableException(fnf_ex);
        }
        catch (IOException io_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            System.out.println("Could not read from properties file: " + propertiesFilename + "\n\t\t\t\tPlease check the file permissions" + io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        System.out.println("Client Properties File Loaded");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        if (props.getProperty("org.openoss.qosclient.naming.provider") != null) {
            jnp_host = props.getProperty("org.openoss.qosclient.naming.provider");
            System.out.println("Using JNP: " + jnp_host);
        } else {
            System.out.println("Naming provider property not set, Using default: jnp://jbossjmsserver1:1099");
            jnp_host = "jnp://jbossjmsserver1:1099";
        }
        env = new Properties();
        env.setProperty("java.naming.provider.url", jnp_host);
        env.setProperty("java.naming.factory.initial", props.getProperty("org.openoss.qosclient.naming.contextfactory"));
        env.setProperty("java.naming.factory.url.pkgs", props.getProperty("org.openoss.qosclient.naming.pkg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.loadClientProperties();
        System.out.println("java.naming.provider.url= " + env.getProperty("java.naming.provider.url"));
        System.out.println("java.naming.factory.initial= " + env.getProperty("java.naming.factory.initial"));
        System.out.println("java.naming.factory.url.pkgs= " + env.getProperty("java.naming.factory.url.pkgs"));
        if (System.getSecurityManager() == null) {
            System.out.println("java.security.policy= " + System.getProperty("java.security.policy"));
            System.setSecurityManager(new RMISecurityManager());
        }
        InitialContext ic = new InitialContext(env);
        System.out.println("Initial context created");
        try {
            ref = ic.lookup(props.getProperty("org.openoss.qosclient.jvthome"));
            home = (JVTAlarmMonitorHome)PortableRemoteObject.narrow((Object)ref, JVTAlarmMonitorHome.class);
            session = home.create();
            System.out.println("Obtained home, and created Session");
            this.am = (AlarmMonitor)PortableRemoteObject.narrow((Object)session, AlarmMonitor.class);
            alarmInternals = (AlarmMonitor)PortableRemoteObject.narrow((Object)session.getHandle().getEJBObject(), AlarmMonitor.class);
            TopicConnectionFactory tcf = (TopicConnectionFactory)ic.lookup(props.getProperty("org.openoss.qosclient.jms.topicconnectionfactory"));
            conn = tcf.createTopicConnection();
            jmsSession = conn.createTopicSession(false, 1);
            eventTopic = (Topic)ic.lookup(props.getProperty("org.openoss.qosclient.jms.topic"));
            conn.start();
            conn2 = tcf.createTopicConnection();
            jmsSession2 = conn2.createTopicSession(false, 1);
            xvteventTopic = (Topic)ic.lookup(props.getProperty("org.openoss.qosclient.jms.xvttopic"));
            conn2.start();
            QueueConnectionFactory qcf = (QueueConnectionFactory)ic.lookup(props.getProperty("org.openoss.qosclient.jms.queueconnectionfactory"));
            queueConnection = qcf.createQueueConnection();
            jmsSession3 = queueConnection.createQueueSession(false, 1);
            xmlMessageQueue = (Queue)ic.lookup(props.getProperty("org.openoss.qosclient.jms.messagequeue"));
            queueConnection.start();
        }
        finally {
            ic.close();
        }
    }

    public void kill() throws Exception {
        session.remove();
        this.am = null;
        alarmInternals = null;
        conn.stop();
        jmsSession.close();
        conn.close();
        conn2.stop();
        queueConnection.stop();
        jmsSession2.close();
        jmsSession3.close();
        queueConnection.close();
    }

    static {
        eventTopic = null;
        jmsSession = null;
        conn = null;
        jmsSession2 = null;
        conn2 = null;
        xvteventTopic = null;
        jmsSession3 = null;
        queueConnection = null;
        xmlMessageQueue = null;
        CONNECTED = false;
    }
}

