/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.rmi.RMISecurityManager;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.oss.UnsupportedOperationException;
import javax.oss.fm.monitor.JVTAlarmMonitorHome;
import javax.oss.fm.monitor.JVTAlarmMonitorSession;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitor;
import org.openoss.ossj.fm.monitor.spring.AlarmMonitorDaoImpl;
import org.openoss.ossj.fm.monitor.spring.OssBean;
import org.openoss.ossj.fm.monitor.spring.OssBeanAlarmMonitorConnector;

public class OssBeanAlarmMonitorConnectorImpl
implements OssBean,
OssBeanAlarmMonitorConnector {
    protected Properties env;
    protected JVTAlarmMonitorHome home;
    protected JVTAlarmMonitorSession session;
    protected AlarmMonitor alarmMonitor;
    protected Object ref;
    protected boolean connected = false;
    protected boolean run_connector = false;
    protected String logname = "not set";
    protected int status = 1;
    protected static Log logger = LogFactory.getLog(AlarmMonitorDaoImpl.class);
    protected String ossBeanName = "name_not_set";
    private int connection_retry_period = 10000;
    private String jndi_fact_class_name = null;
    private String jndi_url = null;
    private String bean_naming_package = null;
    private String jvt_home = null;

    public void setLogName(String _logName) {
        this.logname = _logName;
        logger = LogFactory.getLog((String)_logName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".setLogger() alarm logger set; Logname: " + _logName));
        }
    }

    public String getLogName() {
        return this.logname;
    }

    public String getName() {
        return this.ossBeanName;
    }

    public void setName(String _name) {
        if (_name == null) {
            throw new IllegalStateException("OssBean" + this.getClass().getSimpleName() + " Name cannot be set null");
        }
        this.ossBeanName = _name;
    }

    public void setConnection_retry_period(int _connection_retry_period) {
        this.connection_retry_period = _connection_retry_period;
    }

    public void setbean_naming_package(String _bean_naming_package) {
        this.bean_naming_package = _bean_naming_package;
    }

    public void setjndi_fact_class_name(String _jndi_fact_class_name) {
        this.jndi_fact_class_name = _jndi_fact_class_name;
    }

    public void setjndi_url(String _jndi_url) {
        this.jndi_url = _jndi_url;
    }

    public void setjvt_home(String _jvt_home) {
        this.jvt_home = _jvt_home;
    }

    public synchronized AlarmMonitor getalarmMonitorSession() throws IllegalStateException {
        if (this.alarmMonitor == null) {
            this.notify();
            throw new IllegalStateException("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Error AlarmMonitor is not connected");
        }
        return this.alarmMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.run_connector = true;
        Thread thisThread = Thread.currentThread();
        while (this.run_connector) {
            block15: {
                if (!this.run_connector || this.connected) continue;
                this.status = 1;
                try {
                    this.setupConnections();
                    this.connected = true;
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block15;
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": setupConnections() threw the following error:"), (Throwable)ex);
                }
            }
            if (this.connected) {
                this.status = 3;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": CONNECTED TO JVTHOME: " + this.jvt_home));
                }
                this.test_connection();
            }
            if (this.run_connector) {
                this.status = 1;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": NOT CONNECTED Waiting " + this.connection_retry_period + "ms before trying to reconnect"));
                }
                Thread.sleep(this.connection_retry_period);
            }
            catch (InterruptedException ex) {}
        }
        this.status = 4;
        try {
            this.kill();
            this.status = 5;
        }
        catch (Exception ex) {
            logger.error((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".run(): Exception in kill(): " + ex));
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": STOPPED"));
            }
            this.status = 5;
        }
    }

    public synchronized void stop() {
        if (this.run_connector) {
            this.status = 4;
            this.run_connector = false;
            this.connected = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".stop(): stopping process"));
        }
    }

    public synchronized void init() {
        logger.error((Object)(this.getClass().getSimpleName() + ".init(): init() not needed by this bean as instantiated in START_PENDING state"));
    }

    public synchronized void pause() throws UnsupportedOperationException {
        logger.error((Object)(this.getClass().getSimpleName() + ".pause() PAUSE NOT IMPLIMENTED"));
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".pause() PAUSE NOT IMPLIMENTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupConnections() throws Exception {
        block18: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getStaticConfiguration());
            }
            InitialContext ic = null;
            try {
                this.env = new Properties();
                this.env.setProperty("java.naming.provider.url", this.jndi_url);
                this.env.setProperty("java.naming.factory.initial", this.jndi_fact_class_name);
                this.env.setProperty("java.naming.factory.url.pkgs", this.bean_naming_package);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.provider.url= " + this.env.getProperty("java.naming.provider.url")));
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.initial= " + this.env.getProperty("java.naming.factory.initial")));
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": InitialContext env property java.naming.factory.url.pkgs= " + this.env.getProperty("java.naming.factory.url.pkgs")));
                }
                if (System.getSecurityManager() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": setting java.security.policy= " + System.getProperty("java.security.policy")));
                    }
                    System.setSecurityManager(new RMISecurityManager());
                }
                ic = new InitialContext(this.env);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Initial context created"));
                }
            }
            catch (NamingException ne) {
                logger.error((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem creating InitialContext:" + ne));
                ic = null;
            }
            if (ic != null) {
                try {
                    if (this.jvt_home == null) break block18;
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Trying to connect to AlarmMonitorBean "));
                        }
                        this.ref = ic.lookup(this.jvt_home);
                        this.home = (JVTAlarmMonitorHome)PortableRemoteObject.narrow((Object)this.ref, JVTAlarmMonitorHome.class);
                        this.session = this.home.create();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Obtained home, and created Session"));
                        }
                        this.alarmMonitor = (AlarmMonitor)PortableRemoteObject.narrow((Object)this.session.getHandle().getEJBObject(), AlarmMonitor.class);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": success - connected to AlarmMonitorBean "));
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Problem connecting to AlarmMonitor bean - (may not exist if spring session):" + ex));
                        this.alarmMonitor = null;
                        this.session = null;
                        this.home = null;
                        this.ref = null;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ": Unknown problem connecting receiver: " + ex));
                }
                finally {
                    ic.close();
                }
            }
        }
    }

    private void kill() throws Exception {
        if (this.alarmMonitor != null) {
            this.session.remove();
            this.alarmMonitor = null;
            this.session = null;
            this.home = null;
            this.ref = null;
        }
        this.connected = false;
    }

    public synchronized boolean isConnected() {
        if (!this.connected) {
            return false;
        }
        if (this.alarmMonitor == null) {
            this.notify();
            return false;
        }
        return this.connected;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        String s = "UNKNOWN-STATE";
        try {
            s = STATUS_NAMES[this.status];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            s = "UNKNOWN-STATE";
        }
        return s;
    }

    public String getRuntimeStatistics() {
        String statistics = "NOT DEFINED ";
        return statistics;
    }

    public String getStaticConfiguration() {
        String connectioninfo = "CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + " - connection properties:\n" + "\t   jndi_fact_class_name =" + this.jndi_fact_class_name + "\n" + "\t   jndi_url =" + this.jndi_url + "\n" + "\t   bean_naming_package =" + this.bean_naming_package + "\n" + "\t   jvt_home =" + this.jvt_home + "\n";
        return connectioninfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test_connection() {
        while (this.connected) {
            try {
                if (this.alarmMonitor == null) {
                    this.connected = false;
                    continue;
                }
                String ejbName = this.alarmMonitor.getClass().getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".test_connection(): CONNECTED TO:" + ejbName + " Waiting to retest connection"));
                }
                OssBeanAlarmMonitorConnectorImpl ossBeanAlarmMonitorConnectorImpl = this;
                synchronized (ossBeanAlarmMonitorConnectorImpl) {
                    try {
                        this.wait(this.connection_retry_period);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".test_connection(): NOT CONNECTED. Exception: "), (Throwable)ex);
                }
                this.connected = false;
            }
        }
        try {
            this.connected = false;
        }
        catch (Exception ex) {
            logger.error((Object)("CO:" + this.ossBeanName + ":" + this.getClass().getSimpleName() + ".test_connection(): Exception : " + ex));
        }
    }
}

