/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;

public class SimpleNode
implements Node {
    static Hashtable oidNames = new Hashtable();
    static Hashtable oidVarsTableName = new Hashtable();
    static Hashtable entryNameAndTableName = new Hashtable();
    static Hashtable tableAndIndex = new Hashtable();
    static Hashtable typeNameTable = new Hashtable();
    static Vector orderList = new Vector();
    static final String rfc1155TextOID = ".iso.org.dod.internet";
    static final String rfc1155NumericOID = ".1.3.6.1";
    static final String baseTextOID = ".iso.org.dod.internet.private";
    static final String baseNumericOID = ".1.3.6.1.4";
    static final String TOO_LONG = "TOOLONG";
    static final int tooLongSize = 19;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected ParseMib parser;
    static final String DEFAULT = "default";
    protected String identifier_text = "default";
    protected String identifier_parent_text = "default";
    protected boolean visited = false;
    protected boolean isOidInTable = false;
    protected static boolean printDebug = false;

    public static void setDebug(boolean b) {
        printDebug = b;
    }

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(ParseMib p, int i) {
        this(i);
        this.parser = p;
    }

    public int getId() {
        return this.id;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void setVisited(boolean b) {
        this.visited = b;
    }

    public void setName(String str) {
        this.identifier_text = str;
    }

    public String getName() {
        return this.identifier_text;
    }

    public void setParentName(String str) {
        this.identifier_parent_text = str;
    }

    public String getParentName() {
        return this.identifier_parent_text;
    }

    public void setIsOidInTable(boolean b) {
        this.isOidInTable = b;
    }

    public boolean getIsOidInTable() {
        return this.isOidInTable;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ParseMibTreeConstants.jjtNodeName[this.id] + " " + this.getName() + " visited=" + (this.getVisited() ? "true" : "false") + " children=" + (this.children == null ? "0" : "" + this.children.length);
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        if (printDebug) {
            System.out.println(this.toString(prefix));
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public void markNotVisited() {
        this.setVisited(false);
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.setVisited(false);
                n.markNotVisited();
            }
        }
    }

    public void collectOids() {
        if (this.getVisited()) {
            return;
        }
        boolean foundDeclOID = ParseMibTreeConstants.jjtNodeName[this.id].equals("DeclOID") || ParseMibTreeConstants.jjtNodeName[this.id].equals("ModuleIdentity");
        boolean processMultipleOids = false;
        if (this.children != null) {
            String parent = null;
            String textOid = null;
            String numericOid = null;
            String typeId = null;
            String accessName = OidValues.NOT_ACCESSIBLE;
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("Parent")) {
                        parent = n.identifier_parent_text;
                        textOid = n.identifier_text;
                    } else if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("PartialOID")) {
                        numericOid = n.identifier_text;
                    } else if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("GetTypeIdentifier")) {
                        typeId = n.identifier_text;
                    } else if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("GetAccessIdentifier")) {
                        accessName = n.identifier_text;
                    } else if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("MultipleOids")) {
                        processMultipleOids = true;
                    }
                }
                if (n == null) continue;
                n.collectOids();
                n.setVisited(true);
            }
            if (foundDeclOID) {
                String tableName;
                if (printDebug) {
                    System.out.println("found parent=" + parent + " textOid=" + textOid + " numericOid=" + numericOid);
                }
                if ((tableName = (String)oidVarsTableName.get(textOid)) != null) {
                    if (printDebug) {
                        System.out.println("the OID " + textOid + " is in table=" + tableName);
                    }
                    if (printDebug) {
                        System.out.println("the index name=" + (String)tableAndIndex.get(tableName));
                    }
                }
                OidValues parentOid = (OidValues)oidNames.get(parent);
                if (printDebug) {
                    System.out.println("found numericOid=" + numericOid);
                }
                if (processMultipleOids) {
                    String curTextOid = textOid;
                    String curNumericOid = numericOid;
                    if (printDebug) {
                        System.out.println("process multiple oids in a list");
                    }
                    for (int i = 0; i < this.children.length; ++i) {
                        SimpleNode nouter = (SimpleNode)this.children[i];
                        if (nouter == null || !ParseMibTreeConstants.jjtNodeName[nouter.getId()].equals("MultipleOids")) continue;
                        for (int j = 0; j < nouter.jjtGetNumChildren(); ++j) {
                            SimpleNode n = (SimpleNode)nouter.jjtGetChild(j);
                            if (n == null) continue;
                            if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("ChildTextIdentifier")) {
                                textOid = n.identifier_text;
                                continue;
                            }
                            if (!ParseMibTreeConstants.jjtNodeName[n.getId()].equals("ChildNumericIdentifier")) continue;
                            if (printDebug) {
                                System.out.println("processing multiple ids in a declaration");
                            }
                            numericOid = n.identifier_text;
                            OidValues currentOid = new OidValues();
                            String fullOid = parentOid.getTextOid();
                            if (printDebug) {
                                System.out.println("found fullOid * =" + fullOid);
                            }
                            fullOid = fullOid + "." + textOid;
                            currentOid.setTextOid(fullOid);
                            if (printDebug) {
                                System.out.println("added text oid * : " + fullOid);
                            }
                            fullOid = parentOid.getNumericOid();
                            fullOid = fullOid + "." + numericOid;
                            currentOid.setNumericOid(fullOid);
                            if (printDebug) {
                                System.out.println("added numeric oid * : " + fullOid);
                            }
                            accessName = OidValues.READ_ONLY;
                            currentOid.setAccess(accessName);
                            if (printDebug) {
                                System.out.println("added access=" + accessName);
                            }
                            oidNames.put(textOid, currentOid);
                            orderList.addElement(textOid);
                            parentOid = (OidValues)oidNames.get(textOid);
                        }
                        OidValues currentOid = new OidValues();
                        String fullOid = parentOid.getTextOid();
                        if (printDebug) {
                            System.out.println("found fullOid ** =" + fullOid);
                        }
                        fullOid = fullOid + "." + curTextOid;
                        currentOid.setTextOid(fullOid);
                        if (printDebug) {
                            System.out.println("added text oid ** : " + fullOid);
                        }
                        fullOid = parentOid.getNumericOid();
                        fullOid = fullOid + "." + curNumericOid;
                        currentOid.setNumericOid(fullOid);
                        if (printDebug) {
                            System.out.println("added numeric oid ** : " + fullOid);
                        }
                        accessName = OidValues.READ_ONLY;
                        currentOid.setAccess(accessName);
                        if (printDebug) {
                            System.out.println("added access=" + accessName);
                        }
                        oidNames.put(curTextOid, currentOid);
                        orderList.addElement(curTextOid);
                    }
                } else {
                    OidValues currentOid = new OidValues();
                    String fullOid = null;
                    try {
                        fullOid = parentOid.getTextOid();
                    }
                    catch (Throwable t) {
                        System.err.println("ERROR: can't find parent '" + parent + "' for textOid '" + textOid + "'\nFind which MIB the parent is defined in and add that to the command line\n");
                        if (printDebug) {
                            this.dumpOidNamesSymbolTable();
                        }
                        System.exit(2);
                    }
                    if (printDebug) {
                        System.out.println("found fullOid *** =" + fullOid);
                    }
                    fullOid = fullOid + "." + textOid;
                    currentOid.setTextOid(fullOid);
                    if (printDebug) {
                        System.out.println("added text oid *** : " + fullOid);
                    }
                    fullOid = parentOid.getNumericOid();
                    fullOid = fullOid + "." + numericOid;
                    currentOid.setNumericOid(fullOid);
                    if (printDebug) {
                        System.out.println("added numeric oid *** : " + fullOid);
                    }
                    if (typeId != null) {
                        currentOid.setTypeId(typeId);
                        if (printDebug) {
                            System.out.println("added typeId=" + typeId);
                        }
                    } else if (printDebug) {
                        System.out.println("typeId was null and not added");
                    }
                    currentOid.setAccess(accessName);
                    if (printDebug) {
                        System.out.println("added access=" + accessName);
                    }
                    oidNames.put(textOid, currentOid);
                    orderList.addElement(textOid);
                }
            }
        }
    }

    public void collectTableInfo() {
        if (this.getVisited()) {
            return;
        }
        boolean declOidFound = ParseMibTreeConstants.jjtNodeName[this.id].equals("DeclOID");
        if (this.children != null) {
            String tableName = null;
            String entryName = null;
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("Parent")) {
                        tableName = n.identifier_text;
                    } else if (ParseMibTreeConstants.jjtNodeName[n.getId()].equals("TableSequenceOf")) {
                        entryName = n.identifier_text;
                    }
                }
                if (n == null) continue;
                n.collectTableInfo();
                n.setVisited(true);
            }
            if (declOidFound && entryName != null) {
                if (printDebug) {
                    System.out.println("collectTableInfo adding " + entryName + "/" + tableName);
                }
                entryNameAndTableName.put(entryName, tableName);
            }
        }
    }

    public void collectSequenceInfo() {
        if (this.getVisited()) {
            return;
        }
        String entryName = this.getName();
        String tableName = (String)entryNameAndTableName.get(entryName);
        if (this.children != null) {
            Object indexName = null;
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n.getIsOidInTable()) {
                    if (printDebug) {
                        System.out.println("adding OID " + n.getName() + " to table");
                    }
                    oidVarsTableName.put(n.getName(), tableName);
                }
                if (n == null) continue;
                n.collectSequenceInfo();
                n.setVisited(true);
            }
        }
    }

    public void collectTableIndexInfo() {
        if (this.getVisited()) {
            return;
        }
        String entryName = this.getName();
        String tableName = (String)entryNameAndTableName.get(entryName);
        if (this.children != null) {
            String indexName = null;
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (i == 0 && ParseMibTreeConstants.jjtNodeName[n.getId()].equals("IdentifierInSequenceOfVars")) {
                    indexName = n.identifier_text;
                }
                if (n.getIsOidInTable()) {
                    if (printDebug) {
                        System.out.println("adding OID " + n.getName() + " to table");
                    }
                    oidVarsTableName.put(n.getName(), tableName);
                }
                if (n == null) continue;
                n.collectTableIndexInfo();
                n.setVisited(true);
            }
            if (indexName != null) {
                if (printDebug) {
                    System.out.println("collectTableIndexInfo indexName=" + indexName);
                }
                if (printDebug) {
                    System.out.println("collectTableIndexInfo entryName=" + entryName);
                }
                if (printDebug) {
                    System.out.println("collectTableIndexInfo tableName=" + tableName);
                }
                tableAndIndex.put(tableName, indexName);
            }
        }
    }

    public void collectTextualConventionsInfo() {
        if (this.getVisited()) {
            return;
        }
        boolean textConventionFound = ParseMibTreeConstants.jjtNodeName[this.id].equals("TextConvention") || ParseMibTreeConstants.jjtNodeName[this.id].equals("Assignment");
        String typeName = this.getName();
        String baseTypeName = null;
        if (this.children != null) {
            Object indexName = null;
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (textConventionFound) {
                    if (printDebug) {
                        System.out.println("adding OID " + n.getName() + "/" + typeName + " to typeNametable");
                    }
                    baseTypeName = n.getName();
                    typeNameTable.put(typeName, baseTypeName);
                }
                if (n == null) continue;
                n.collectTextualConventionsInfo();
                n.setVisited(true);
            }
        }
    }

    public void writeOids() {
        StringBuffer sb = new StringBuffer();
        OidValues oidValues = null;
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        if (printDebug) {
            System.out.println("Sorted OIDS from Vector");
        }
        sb = new StringBuffer();
        for (int i = 0; i < orderList.size(); ++i) {
            String name = (String)orderList.elementAt(i);
            oidValues = (OidValues)oidNames.get(name);
            if (!oidValues.getTypeId().equals("DEFAULT") && !oidValues.getAccess().equals(OidValues.NOT_ACCESSIBLE)) {
                String instanceVar = "0";
                String aliasVar = oidValues.getTextOid();
                int index = aliasVar.lastIndexOf(".") + 1;
                String lastOidStr = aliasVar.substring(index);
                String tableName = (String)oidVarsTableName.get(lastOidStr);
                String numericOid = oidValues.getNumericOid();
                String typeName = oidValues.getTypeId();
                String typeFromTable = (String)typeNameTable.get(typeName);
                if (typeFromTable != null) {
                    typeName = typeFromTable;
                }
                if (tableName != null) {
                    instanceVar = (String)tableAndIndex.get(tableName);
                }
                if (lastOidStr.length() > 19) {
                    lastOidStr = lastOidStr + TOO_LONG;
                }
                sb.append("<mibObj oid=\"").append(numericOid).append("\" ");
                sb.append("instance=\"").append(instanceVar).append("\" ");
                sb.append("alias=\"").append(lastOidStr).append("\" ");
                sb.append("type=\"").append(typeName).append("\" />").append("\n");
                System.out.print(sb.toString());
                sortedMap.put(numericOid, sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if (printDebug && oidValues.getTypeId().equals("DEFAULT")) {
                System.out.println("skipping oid with DEFAULT type, oid=" + oidValues.getTextOid());
            }
            if (!printDebug || !oidValues.getAccess().equals(OidValues.NOT_ACCESSIBLE)) continue;
            System.out.println("skipping oid with no ACCESS, oid=" + oidValues.getAccess());
        }
    }

    public void dumpOidNamesSymbolTable() {
        StringBuffer sb = new StringBuffer();
        OidValues oidValues = null;
        String key = null;
        Object oidName = null;
        sb.append("Symbol Table oidNames for text OID/OidValues\n");
        Enumeration e = oidNames.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            oidValues = (OidValues)oidNames.get(key);
            sb.append(key + "/" + oidValues.toString()).append("\n");
        }
        if (printDebug) {
            System.out.println(sb.toString());
        }
    }

    public void dumpSymbolTables() {
        StringBuffer sb = new StringBuffer();
        Object oidValues = null;
        String key = null;
        String oidName = null;
        String entryName = null;
        String indexName = null;
        String baseType = null;
        this.dumpOidNamesSymbolTable();
        sb.append("Symbol Table oidVarsTableName for tableName/OidName\n");
        Enumeration e = oidVarsTableName.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            oidName = (String)oidVarsTableName.get(key);
            sb.append(key + "/" + oidName).append("\n");
        }
        sb.append("Symbol Table entryNameAndTableName for entryName/tableName\n");
        e = entryNameAndTableName.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            entryName = (String)entryNameAndTableName.get(key);
            sb.append(key + "/" + entryName).append("\n");
        }
        sb.append("Symbol Table tableAndIndex for tableName/indexName\n");
        e = tableAndIndex.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            indexName = (String)tableAndIndex.get(key);
            sb.append(key + "/" + indexName).append("\n");
        }
        sb.append("Symbol Table typeNameTable for type/baseType\n");
        e = typeNameTable.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            baseType = (String)typeNameTable.get(key);
            sb.append(key + "/" + baseType).append("\n");
        }
        if (printDebug) {
            System.out.println(sb.toString());
        }
    }

    static {
        try {
            if (printDebug) {
                System.out.println("building oidNames of oids");
            }
            OidValues oids = new OidValues();
            oids.setTextOid(".iso");
            oids.setNumericOid(".1");
            oidNames.put("iso", oids);
            oids = new OidValues();
            oids.setTextOid(".iso.org.dod.internet.directory");
            oids.setNumericOid(".1.3.6.1.1");
            oidNames.put("directory", oids);
            oids = new OidValues();
            oids.setTextOid(".iso.org.dod.internet.mgmt");
            oids.setNumericOid(".1.3.6.1.2");
            oidNames.put("mgmt", oids);
            oids = new OidValues();
            oids.setTextOid(".iso.org.dod.internet.experimental");
            oids.setNumericOid(".1.3.6.1.3");
            oidNames.put("experimental", oids);
            oids = new OidValues();
            oids.setTextOid(baseTextOID);
            oids.setNumericOid(baseNumericOID);
            oidNames.put("private", oids);
            oids = new OidValues();
            oids.setTextOid(".iso.org.dod.internet.private.enterprises");
            oids.setNumericOid(".1.3.6.1.4.1");
            oidNames.put("enterprises", oids);
        }
        catch (Exception e) {
            System.err.println("exception during oidNames init" + e.getMessage());
        }
    }
}

