/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class IPv4Address
implements Serializable {
    static final long serialVersionUID = 1946711645921732057L;
    private byte[] m_addr;

    private byte[] dup(byte[] src) {
        byte[] cpy = null;
        if (src != null) {
            cpy = new byte[src.length];
            for (int x = 0; x < src.length; ++x) {
                cpy[x] = src[x];
            }
        }
        return cpy;
    }

    private static int byteToInt(byte b) {
        int r = b;
        if (r < 0) {
            r += 256;
        }
        return r;
    }

    public static String addressToString(int ipv4Addr) {
        StringBuffer buf = new StringBuffer();
        buf.append(ipv4Addr >> 24 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr >> 16 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr >> 8 & 0xFF);
        buf.append('.');
        buf.append(ipv4Addr & 0xFF);
        return buf.toString();
    }

    public static String addressToString(byte[] buf) {
        if (buf.length != 4) {
            throw new IllegalArgumentException("IPv4 Address must be 4-bytes in length");
        }
        int a = IPv4Address.byteToInt(buf[0]);
        int b = IPv4Address.byteToInt(buf[1]);
        int c = IPv4Address.byteToInt(buf[2]);
        int d = IPv4Address.byteToInt(buf[3]);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(a).append('.').append(b).append('.').append(c).append('.').append(d);
        return sbuf.toString();
    }

    public IPv4Address() {
        this.m_addr = new byte[4];
        this.m_addr[0] = 0;
        this.m_addr[1] = 0;
        this.m_addr[2] = 0;
        this.m_addr[3] = 0;
    }

    public IPv4Address(IPv4Address second) {
        this.m_addr = this.dup(second.m_addr);
    }

    public IPv4Address(byte[] addr) {
        if (addr.length != 4) {
            throw new IllegalArgumentException("Invalid address length");
        }
        this.m_addr = this.dup(addr);
    }

    public IPv4Address(int ipv4Addr) {
        this.m_addr = new byte[4];
        this.m_addr[0] = (byte)(ipv4Addr >>> 24);
        this.m_addr[1] = (byte)(ipv4Addr >> 16 & 0xFF);
        this.m_addr[2] = (byte)(ipv4Addr >> 8 & 0xFF);
        this.m_addr[3] = (byte)(ipv4Addr & 0xFF);
    }

    public IPv4Address(String ipv4Addr) {
        StringTokenizer tok = new StringTokenizer(ipv4Addr, ".");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid Dotted Decimal IPv4 Address");
        }
        this.m_addr = new byte[4];
        for (int x = 0; x < 4; ++x) {
            int converted = Integer.parseInt(tok.nextToken());
            if (converted < 0 || converted > 255) {
                throw new IllegalArgumentException("Invalid IPv4 Address string");
            }
            this.m_addr[x] = (byte)(converted & 0xFF);
        }
    }

    public IPv4Address(InetAddress addr) {
        this.m_addr = this.dup(addr.getAddress());
    }

    public int getAddress() {
        int addr = IPv4Address.byteToInt(this.m_addr[0]) << 24;
        addr |= IPv4Address.byteToInt(this.m_addr[1]) << 16;
        addr |= IPv4Address.byteToInt(this.m_addr[2]) << 8;
        return addr |= IPv4Address.byteToInt(this.m_addr[3]);
    }

    public byte[] getAddressBytes() {
        return this.m_addr;
    }

    public void setAddress(IPv4Address second) {
        this.m_addr = this.dup(second.m_addr);
    }

    public void setAddress(byte[] addr) {
        if (addr.length != 4) {
            throw new IllegalArgumentException("Invalid address length");
        }
        this.m_addr = this.dup(addr);
    }

    public void setAddress(int ipv4Addr) {
        this.m_addr = new byte[4];
        this.m_addr[0] = (byte)(ipv4Addr >>> 24);
        this.m_addr[1] = (byte)(ipv4Addr >> 16 & 0xFF);
        this.m_addr[2] = (byte)(ipv4Addr >> 8 & 0xFF);
        this.m_addr[3] = (byte)(ipv4Addr & 0xFF);
    }

    public void setAddress(String ipv4Addr) {
        StringTokenizer tok = new StringTokenizer(ipv4Addr, ".");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid Dotted Decimal IPv4 Address");
        }
        this.m_addr = new byte[4];
        for (int x = 0; x < 4; ++x) {
            int converted = Integer.parseInt(tok.nextToken());
            if (converted < 0 || converted > 255) {
                throw new IllegalArgumentException("Invalid IPv4 Address string");
            }
            this.m_addr[x] = (byte)(converted & 0xFF);
        }
    }

    public void setAddress(InetAddress addr) {
        this.m_addr = this.dup(addr.getAddress());
    }

    public boolean equals(Object obj) {
        boolean bRC;
        block4: {
            block5: {
                block3: {
                    bRC = false;
                    if (!(obj instanceof IPv4Address)) break block3;
                    byte[] t = ((IPv4Address)obj).m_addr;
                    bRC = true;
                    for (int x = 0; x < 4; ++x) {
                        if (this.m_addr[x] == t[x]) continue;
                        bRC = false;
                    }
                    break block4;
                }
                if (!(obj instanceof Integer)) break block5;
                if (((Integer)obj).intValue() != this.getAddress()) break block4;
                bRC = true;
                break block4;
            }
            if (!(obj instanceof String)) break block4;
            try {
                IPv4Address addr = new IPv4Address((String)obj);
                bRC = this.equals(addr);
            }
            catch (IllegalArgumentException e) {
                bRC = false;
            }
        }
        return bRC;
    }

    public String toString() {
        return IPv4Address.addressToString(this.m_addr);
    }
}

