/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.ping.Packet;
import org.opennms.netmgt.ping.Reply;

public final class IcmpSocket {
    private FileDescriptor m_rawFd;

    private native void initSocket() throws IOException;

    public IcmpSocket() throws IOException {
        String property = System.getProperty("opennms.library.jicmp");
        if (property != null) {
            System.load(property);
        } else {
            System.loadLibrary("jicmp");
        }
        this.m_rawFd = new FileDescriptor();
        this.initSocket();
    }

    public final native DatagramPacket receive() throws IOException;

    public final native void send(DatagramPacket var1) throws IOException;

    public final native void close();

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("incorrect number of command-line arguments.");
            System.err.println("usage: java -cp ... " + IcmpSocket.class.getName() + " <host>");
            System.exit(1);
        }
        String host = argv[0];
        IcmpSocket m_socket = null;
        try {
            m_socket = new IcmpSocket();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("UnsatisfiedLinkError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.  Try setting the property 'opennms.library.jicmp' to point at the full path name of the libjicmp.so shared library (e.g. 'java -Dopennms.library.jicmp=/some/path/libjicmp.so ...')");
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("IOException while creating an IcmpSocket.");
            e.printStackTrace();
            System.exit(1);
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            System.err.println("UnknownHostException when looking up " + host + ".");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("PING " + host + " (" + addr.getHostAddress() + "): 56 data bytes");
        short m_icmpId = 2;
        Stuff s = new Stuff(m_socket, m_icmpId);
        Thread t = new Thread(s);
        t.start();
        long m_fiberId = 0L;
        while (true) {
            Packet pingPkt = new Packet(m_fiberId);
            pingPkt.setIdentity(m_icmpId);
            pingPkt.computeChecksum();
            byte[] buf = pingPkt.toBytes();
            DatagramPacket sendPkt = new DatagramPacket(buf, buf.length, addr, 0);
            buf = null;
            pingPkt = null;
            try {
                m_socket.send(sendPkt);
            }
            catch (IOException e) {
                System.err.println("IOException received when sending packet.");
                e.printStackTrace();
                System.exit(1);
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++m_fiberId;
        }
    }

    public static class Stuff
    implements Runnable {
        private IcmpSocket m_socket;
        private short m_icmpId;

        public Stuff(IcmpSocket socket, short icmpId) {
            this.m_socket = socket;
            this.m_icmpId = icmpId;
        }

        public void run() {
            try {
                while (true) {
                    Reply reply;
                    DatagramPacket pkt = this.m_socket.receive();
                    try {
                        reply = Reply.create(pkt);
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    if (!reply.isEchoReply() || reply.getIdentity() != this.m_icmpId) continue;
                    float rtt = (float)reply.getPacket().getPingRTT() / 1000.0f;
                    StringBuilder stringBuilder = new StringBuilder();
                    reply.getPacket();
                    System.out.println(stringBuilder.append(Packet.getNetworkSize()).append(" bytes from ").append(pkt.getAddress().getHostAddress()).append(": icmp_seq=").append(reply.getPacket().getTID()).append(". time=").append(rtt).append(" ms").toString());
                }
            }
            catch (Throwable t) {
                System.err.println("An exception occured processing the datagram, thread exiting.");
                t.printStackTrace();
                System.exit(1);
                return;
            }
        }
    }
}

