/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

class RrdCreateCmd
extends RrdToolCmd {
    static final String DEFAULT_START = "now-10s";
    static final String DEFAULT_STEP = "300";
    private RrdDef rrdDef;

    RrdCreateCmd() {
    }

    String getCmdType() {
        return "create";
    }

    Object execute() throws RrdException, IOException {
        String string = this.getOptionValue("b", "start", DEFAULT_START);
        long l = Util.getTimestamp(string);
        String string2 = this.getOptionValue("s", "step", DEFAULT_STEP);
        long l2 = RrdCreateCmd.parseLong(string2);
        String[] stringArray = this.getRemainingWords();
        if (stringArray.length < 2) {
            throw new RrdException("RRD file path not specified");
        }
        String string3 = stringArray[1];
        this.rrdDef = new RrdDef(string3, l, l2);
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("DS:")) {
                this.parseDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("RRA:")) {
                this.parseRra(stringArray[i]);
                continue;
            }
            throw new RrdException("Invalid rrdcreate syntax: " + stringArray[i]);
        }
        return this.createRrdDb();
    }

    private void parseDef(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 6) {
            throw new RrdException("Invalid DS definition: " + string);
        }
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        long l = RrdCreateCmd.parseLong(stringArray[3]);
        double d = RrdCreateCmd.parseDouble(stringArray[4]);
        double d2 = RrdCreateCmd.parseDouble(stringArray[5]);
        this.rrdDef.addDatasource(string2, string3, l, d, d2);
    }

    private void parseRra(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length < 5) {
            throw new RrdException("Invalid RRA definition: " + string);
        }
        String string2 = stringArray[1];
        double d = RrdCreateCmd.parseDouble(stringArray[2]);
        int n = RrdCreateCmd.parseInt(stringArray[3]);
        int n2 = RrdCreateCmd.parseInt(stringArray[4]);
        this.rrdDef.addArchive(string2, d, n, n2);
    }

    private String createRrdDb() throws IOException, RrdException {
        RrdDb rrdDb = RrdCreateCmd.getRrdDbReference(this.rrdDef);
        RrdCreateCmd.releaseRrdDbReference(rrdDb);
        return this.rrdDef.getPath();
    }
}

