/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class AspectJWeaverMessageHandler
implements IMessageHandler {
    private static final String AJ_ID = "[AspectJ] ";
    private final Log logger = LogFactory.getLog((String)"AspectJ Weaver");

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if ((this.logger.isDebugEnabled() || this.logger.isTraceEnabled()) && messageKind == IMessage.DEBUG) {
            this.logger.debug((Object)this.makeMessageFor(message));
            return true;
        }
        if (this.logger.isInfoEnabled() && (messageKind == IMessage.INFO || messageKind == IMessage.WEAVEINFO)) {
            this.logger.info((Object)this.makeMessageFor(message));
            return true;
        }
        if (this.logger.isWarnEnabled() && messageKind == IMessage.WARNING) {
            this.logger.warn((Object)this.makeMessageFor(message));
            return true;
        }
        if (this.logger.isErrorEnabled() && messageKind == IMessage.ERROR) {
            this.logger.error((Object)this.makeMessageFor(message));
            return true;
        }
        if (this.logger.isFatalEnabled() && messageKind == IMessage.ABORT) {
            this.logger.fatal((Object)this.makeMessageFor(message));
            return true;
        }
        return false;
    }

    private String makeMessageFor(IMessage aMessage) {
        return AJ_ID + aMessage.getMessage();
    }

    public boolean isIgnoring(IMessage.Kind messageKind) {
        return false;
    }

    public void dontIgnore(IMessage.Kind messageKind) {
    }
}

