/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Correlator
extends AbstractServiceDaemon
implements CorrelationEngineRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(Correlator.class);
    public static final String EVENT_PARM_PERSIST_STATE = "persistState";
    private EventIpcManager m_eventIpcManager;
    private Map<String, CorrelationEngine> m_engines = new HashMap<String, CorrelationEngine>();
    private final List<EngineAdapter> m_adapters = new LinkedList<EngineAdapter>();
    private boolean m_initialized = false;

    protected Correlator() {
        super("correlator");
    }

    protected void onInit() {
        Assert.notNull((Object)this.m_eventIpcManager, (String)"property eventIpcManager must be set");
        Assert.notNull(this.m_engines, (String)"property engines must be set");
        for (CorrelationEngine engine : this.m_engines.values()) {
            LOG.info("Registering correlation engine: {}", (Object)engine);
            this.m_adapters.add(new EngineAdapter(engine));
        }
        this.m_initialized = true;
    }

    protected void onStop() {
        for (CorrelationEngine engine : this.m_engines.values()) {
            LOG.info("Tearing down correlation engine: {}", (Object)engine);
            engine.tearDown();
        }
    }

    public void setCorrelationEngines(Collection<CorrelationEngine> engines) {
        this.m_engines.clear();
        engines.stream().forEach(engine -> this.m_engines.put(engine.getName(), (CorrelationEngine)engine));
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    @Override
    public void addCorrelationEngine(CorrelationEngine engine) {
        this.m_engines.put(engine.getName(), engine);
        if (this.m_initialized) {
            LOG.debug("addCorrelationEngine: adding engine {}", (Object)engine.getName());
            this.m_adapters.add(new EngineAdapter(engine));
        }
    }

    @Override
    public void removeCorrelationEngine(String engineName) {
        this.m_adapters.stream().filter(a -> a.getName().endsWith(engineName)).findFirst().ifPresent(a -> {
            LOG.debug("removeCorrelationEngine: removing engine {}", (Object)engineName);
            a.tearDown();
            this.m_adapters.remove(a);
            this.m_engines.get(engineName).tearDown();
            this.m_engines.remove(engineName);
        });
    }

    @Override
    public void addCorrelationEngines(CorrelationEngine ... engines) {
        for (CorrelationEngine engine : engines) {
            this.addCorrelationEngine(engine);
        }
    }

    @Override
    public CorrelationEngine findEngineByName(String name) {
        return this.m_engines.get(name);
    }

    @Override
    public Collection<CorrelationEngine> getEngines() {
        return this.m_engines.values();
    }

    private class EngineAdapter
    implements EventListener {
        private final String m_name;
        private final CorrelationEngine m_engine;

        public EngineAdapter(CorrelationEngine engine) {
            this.m_engine = engine;
            this.m_name = this.m_engine.getClass().getSimpleName() + '-' + this.m_engine.getName();
            Map mdc = Logging.getCopyOfContextMap();
            Logging.putPrefix((String)this.m_name);
            this.registerEventListeners();
            Logging.setContextMap((Map)mdc);
        }

        public String getName() {
            return this.m_name;
        }

        public void onEvent(IEvent e) {
            if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
                this.handleReloadEvent(e);
                return;
            }
            this.m_engine.correlate(Event.copyFrom((IEvent)e));
        }

        public void tearDown() {
            Correlator.this.m_eventIpcManager.removeEventListener((EventListener)this);
        }

        private void registerEventListeners() {
            List<String> interesting = this.m_engine.getInterestingEvents();
            if (interesting.contains("*")) {
                LOG.warn("Registering engine {} for ALL events", (Object)this.m_engine.getName());
                Correlator.this.m_eventIpcManager.addEventListener((EventListener)this);
            } else {
                Correlator.this.m_eventIpcManager.addEventListener((EventListener)this, interesting);
                Correlator.this.m_eventIpcManager.addEventListener((EventListener)this, "uei.opennms.org/internal/reloadDaemonConfig");
            }
        }

        private void handleReloadEvent(IEvent e) {
            boolean engineNameMatched = false;
            boolean persistState = true;
            List parmCollection = e.getParmCollection();
            for (IParm parm : parmCollection) {
                String parmName = parm.getParmName();
                if ("daemonName".equals(parmName)) {
                    if (parm.getValue() == null || parm.getValue().getContent() == null) {
                        LOG.warn("The daemonName parameter has no value, ignoring.");
                        return;
                    }
                    if (parm.getValue().getContent().contains(this.getName())) {
                        engineNameMatched = true;
                    }
                }
                if (!parmName.equals(Correlator.EVENT_PARM_PERSIST_STATE) || parm.getValue() == null || parm.getValue().getContent() == null || !parm.getValue().getContent().equals("false")) continue;
                persistState = false;
            }
            if (engineNameMatched) {
                Correlator.this.m_eventIpcManager.removeEventListener((EventListener)this);
                this.m_engine.reloadConfig(persistState);
                this.registerEventListeners();
            }
        }
    }
}

