/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCorrelationEngine
implements CorrelationEngine {
    private static int s_lastTimerId = 0;
    private EventIpcManager m_eventIpcManager;
    private Timer m_scheduler;
    private Map<Integer, TimerTask> m_pendingTasks = Collections.synchronizedMap(new HashMap());

    @Override
    public abstract void correlate(Event var1);

    @Override
    public abstract List<String> getInterestingEvents();

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void sendEvent(Event e) {
        this.m_eventIpcManager.sendNow(e);
    }

    public Integer setTimer(long millis) {
        RuleTimerTask task = this.getTimerTask();
        this.m_scheduler.schedule((TimerTask)task, millis);
        return task.getId();
    }

    public RuleTimerTask getTimerTask() {
        RuleTimerTask timerTask = new RuleTimerTask();
        this.m_pendingTasks.put(timerTask.getId(), timerTask);
        return timerTask;
    }

    public void cancelTimer(Integer timerId) {
        TimerTask task = this.m_pendingTasks.remove(timerId);
        if (task != null) {
            task.cancel();
        }
    }

    protected abstract void timerExpired(Integer var1);

    public void setScheduler(Timer scheduler) {
        this.m_scheduler = scheduler;
    }

    public void runTimer(RuleTimerTask task) {
        this.m_pendingTasks.remove(task.getId());
        this.timerExpired(task.getId());
    }

    static /* synthetic */ int access$004() {
        return ++s_lastTimerId;
    }

    private class RuleTimerTask
    extends TimerTask {
        private Integer m_id = AbstractCorrelationEngine.access$004();

        public Integer getId() {
            return this.m_id;
        }

        public void run() {
            AbstractCorrelationEngine.this.runTimer(this);
        }
    }
}

