/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Correlator
extends AbstractServiceDaemon
implements CorrelationEngineRegistrar {
    private EventIpcManager m_eventIpcManager;
    private List<CorrelationEngine> m_engines;
    private List<EngineAdapter> m_adapters = new LinkedList<EngineAdapter>();
    private boolean m_initialized = false;

    protected Correlator() {
        super("OpenNMS.Correlator");
    }

    protected void onInit() {
        Assert.notNull((Object)this.m_eventIpcManager, (String)"property eventIpcManager must be set");
        Assert.notNull(this.m_engines, (String)"property engines must be set");
        this.log().info((Object)("m_engines.size = " + this.m_engines.size()));
        for (CorrelationEngine engine : this.m_engines) {
            this.log().info((Object)("Registering engine " + engine));
            this.m_adapters.add(new EngineAdapter(engine));
        }
        this.m_initialized = true;
    }

    public void setCorrelationEngines(List<CorrelationEngine> engines) {
        this.m_engines = engines;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    @Override
    public void addCorrelationEngine(CorrelationEngine engine) {
        this.m_engines.add(engine);
        if (this.m_initialized) {
            this.m_adapters.add(new EngineAdapter(engine));
        }
    }

    @Override
    public CorrelationEngine findEngineByName(String name) {
        for (CorrelationEngine engine : this.m_engines) {
            if (!name.equals(engine.getName())) continue;
            return engine;
        }
        return null;
    }

    @Override
    public List<CorrelationEngine> getEngines() {
        return this.m_engines;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private class EngineAdapter
    implements EventListener {
        private final CorrelationEngine m_engine;

        public EngineAdapter(CorrelationEngine engine) {
            this.m_engine = engine;
            Correlator.this.m_eventIpcManager.addEventListener((EventListener)this, this.m_engine.getInterestingEvents());
        }

        public String getName() {
            return this.m_engine.getClass().getSimpleName();
        }

        public void onEvent(Event e) {
            this.m_engine.correlate(e);
        }
    }
}

