/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.DatabaseSchemaConfig;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.DatabaseSchema;
import org.opennms.netmgt.config.filter.Join;
import org.opennms.netmgt.config.filter.Table;
import org.opennms.netmgt.filter.api.FilterParseException;

public final class DatabaseSchemaConfigFactory
implements DatabaseSchemaConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static DatabaseSchemaConfig m_singleton = null;
    private DatabaseSchema m_config;
    private Map<String, Join> m_primaryJoins = null;
    private static boolean m_loaded = false;

    public DatabaseSchemaConfigFactory() throws IOException {
        this(DatabaseSchemaConfigFactory.class.getResourceAsStream("/database-schema.xml"));
    }

    public DatabaseSchemaConfigFactory(InputStream is) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is);){
            this.m_config = (DatabaseSchema)JaxbUtils.unmarshal(DatabaseSchema.class, (Reader)reader);
        }
        this.finishConstruction();
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        m_singleton = new DatabaseSchemaConfigFactory();
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        DatabaseSchemaConfigFactory.init();
    }

    public static synchronized DatabaseSchemaConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(DatabaseSchemaConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public DatabaseSchema getDatabaseSchema() {
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            DatabaseSchema databaseSchema = this.m_config;
            return databaseSchema;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getPrimaryTable() {
        this.getReadLock().lock();
        try {
            for (Table t : this.getDatabaseSchema().getTables()) {
                if (t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true") || t.getKey() == null || !t.getKey().equals("primary")) continue;
                Table table = t;
                return table;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void finishConstruction() {
        HashSet<String> joinableSet = new HashSet<String>();
        ConcurrentHashMap<String, Join> primaryJoins = new ConcurrentHashMap<String, Join>();
        joinableSet.add(this.getPrimaryTable().getName());
        int joinableCount = 0;
        while (joinableCount < joinableSet.size()) {
            joinableCount = joinableSet.size();
            HashSet<String> newSet = new HashSet<String>(joinableSet);
            for (Table t : this.getDatabaseSchema().getTables()) {
                if (joinableSet.contains(t.getName()) || t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true")) continue;
                for (Join j : t.getJoins()) {
                    if (!joinableSet.contains(j.getTable())) continue;
                    newSet.add(t.getName());
                    primaryJoins.put(t.getName(), j);
                }
            }
            joinableSet = newSet;
        }
        this.m_primaryJoins = primaryJoins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableByName(String name) {
        this.getReadLock().lock();
        try {
            for (Table t : this.getDatabaseSchema().getTables()) {
                if (t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true") || t.getName() == null || !t.getName().equals(name)) continue;
                Table table = t;
                return table;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findTableByVisibleColumn(String colName) {
        Table table = null;
        this.getReadLock().lock();
        try {
            block3: for (Table t : this.getDatabaseSchema().getTables()) {
                for (Column col : t.getColumns()) {
                    if (col.getVisible() != null && !col.getVisible().equalsIgnoreCase("true") || !col.getName().equalsIgnoreCase(colName)) continue;
                    table = t;
                    break block3;
                }
            }
            Iterator iterator = table;
            return iterator;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public int getTableCount() {
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            int n = this.getDatabaseSchema().getTables().size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getJoinTables(List<Table> tables) {
        ArrayList<String> joinedTables = new ArrayList<String>();
        this.getReadLock().lock();
        try {
            for (int i = 0; i < tables.size(); ++i) {
                int insertPosition = joinedTables.size();
                String currentTable = tables.get(i).getName();
                while (currentTable != null && !joinedTables.contains(currentTable)) {
                    joinedTables.add(insertPosition, currentTable);
                    Join next = this.m_primaryJoins.get(currentTable);
                    if (next != null) {
                        currentTable = next.getTable();
                        continue;
                    }
                    currentTable = null;
                }
            }
            ArrayList<String> arrayList = joinedTables;
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String constructJoinExprForTables(List<Table> tables) {
        StringBuilder joinExpr = new StringBuilder();
        this.getReadLock().lock();
        try {
            List<String> joinTables = this.getJoinTables(tables);
            joinExpr.append(joinTables.get(0));
            for (int i = 1; i < joinTables.size(); ++i) {
                Join currentJoin = this.m_primaryJoins.get(joinTables.get(i));
                if (currentJoin.getType() != null && !currentJoin.getType().equalsIgnoreCase("inner")) {
                    joinExpr.append(" " + currentJoin.getType().toUpperCase());
                }
                joinExpr.append(" JOIN " + joinTables.get(i) + " ON (");
                joinExpr.append(currentJoin.getTable() + "." + currentJoin.getTableColumn() + " = ");
                joinExpr.append(joinTables.get(i) + "." + currentJoin.getColumn() + ")");
            }
            if (joinExpr.length() > 0) {
                String string = "FROM " + joinExpr.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addColumn(List<Table> tables, String column) throws FilterParseException {
        this.getReadLock().lock();
        try {
            Table table = this.findTableByVisibleColumn(column);
            if (table == null) {
                String message = "Could not find the column '" + column + "' in filter rule";
                throw new FilterParseException(message);
            }
            if (!tables.contains(table)) {
                tables.add(table);
            }
            String string = table.getName() + "." + column;
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

