/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.capsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.common.Range;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolConfiguration
implements Serializable {
    private String _scan = "on";
    private String _userDefined = "false";
    private List<String> _specificList;
    private List<Range> _rangeList;
    private List<Property> _propertyList;

    public ProtocolConfiguration() {
        this.setScan("on");
        this.setUserDefined("false");
        this._specificList = new ArrayList<String>();
        this._rangeList = new ArrayList<Range>();
        this._propertyList = new ArrayList<Property>();
    }

    public void addProperty(Property vProperty) throws IndexOutOfBoundsException {
        this._propertyList.add(vProperty);
    }

    public void addProperty(int index, Property vProperty) throws IndexOutOfBoundsException {
        this._propertyList.add(index, vProperty);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public Enumeration<Property> enumerateProperty() {
        return Collections.enumeration(this._propertyList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this._rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    public Property getProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._propertyList.size()) {
            throw new IndexOutOfBoundsException("getProperty: Index value '" + index + "' not in range [0.." + (this._propertyList.size() - 1) + "]");
        }
        return this._propertyList.get(index);
    }

    public Property[] getProperty() {
        Property[] array = new Property[]{};
        return this._propertyList.toArray(array);
    }

    public List<Property> getPropertyCollection() {
        return this._propertyList;
    }

    public int getPropertyCount() {
        return this._propertyList.size();
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        return this._rangeList.get(index);
    }

    public Range[] getRange() {
        Range[] array = new Range[]{};
        return this._rangeList.toArray(array);
    }

    public List<Range> getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public String getScan() {
        return this._scan;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public String[] getSpecific() {
        String[] array = new String[]{};
        return this._specificList.toArray(array);
    }

    public List<String> getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public String getUserDefined() {
        return this._userDefined;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Property> iterateProperty() {
        return this._propertyList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this._rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this._specificList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllProperty() {
        this._propertyList.clear();
    }

    public void removeAllRange() {
        this._rangeList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeProperty(Property vProperty) {
        boolean removed = this._propertyList.remove(vProperty);
        return removed;
    }

    public Property removePropertyAt(int index) {
        Property obj = this._propertyList.remove(index);
        return obj;
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this._rangeList.remove(vRange);
        return removed;
    }

    public Range removeRangeAt(int index) {
        Range obj = this._rangeList.remove(index);
        return obj;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public String removeSpecificAt(int index) {
        String obj = this._specificList.remove(index);
        return obj;
    }

    public void setProperty(int index, Property vProperty) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._propertyList.size()) {
            throw new IndexOutOfBoundsException("setProperty: Index value '" + index + "' not in range [0.." + (this._propertyList.size() - 1) + "]");
        }
        this._propertyList.set(index, vProperty);
    }

    public void setProperty(Property[] vPropertyArray) {
        this._propertyList.clear();
        for (int i = 0; i < vPropertyArray.length; ++i) {
            this._propertyList.add(vPropertyArray[i]);
        }
    }

    public void setProperty(List<Property> vPropertyList) {
        this._propertyList.clear();
        this._propertyList.addAll(vPropertyList);
    }

    public void setPropertyCollection(List<Property> propertyList) {
        this._propertyList = propertyList;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this._rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this._rangeList.clear();
        this._rangeList.addAll(vRangeList);
    }

    public void setRangeCollection(List<Range> rangeList) {
        this._rangeList = rangeList;
    }

    public void setScan(String scan) {
        this._scan = scan;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<String> specificList) {
        this._specificList = specificList;
    }

    public void setUserDefined(String userDefined) {
        this._userDefined = userDefined;
    }

    public static ProtocolConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ProtocolConfiguration)Unmarshaller.unmarshal(ProtocolConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

