/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.snmp.Definition;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpConfig
implements Serializable {
    private int _port;
    private boolean _has_port;
    private int _retry;
    private boolean _has_retry;
    private int _timeout;
    private boolean _has_timeout;
    private String _readCommunity;
    private String _writeCommunity;
    private String _proxyHost;
    private String _version;
    private int _maxVarsPerPdu = 10;
    private boolean _has_maxVarsPerPdu;
    private int _maxRepetitions = 2;
    private boolean _has_maxRepetitions;
    private int _maxRequestSize = 65535;
    private boolean _has_maxRequestSize;
    private String _securityName;
    private String _authPassphrase;
    private String _authProtocol;
    private String _engineId;
    private String _contextEngineId;
    private String _contextName;
    private String _privacyPassphrase;
    private String _privacyProtocol;
    private String _enterpriseId;
    private List<Definition> _definitionList = new ArrayList<Definition>();

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public void deleteMaxRepetitions() {
        this._has_maxRepetitions = false;
    }

    public void deleteMaxRequestSize() {
        this._has_maxRequestSize = false;
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration<Definition> enumerateDefinition() {
        return Collections.enumeration(this._definitionList);
    }

    public String getAuthPassphrase() {
        return this._authPassphrase;
    }

    public String getAuthProtocol() {
        return this._authProtocol;
    }

    public String getContextEngineId() {
        return this._contextEngineId;
    }

    public String getContextName() {
        return this._contextName;
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("getDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        return this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        Definition[] array = new Definition[]{};
        return this._definitionList.toArray(array);
    }

    public List<Definition> getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    public String getEngineId() {
        return this._engineId;
    }

    public String getEnterpriseId() {
        return this._enterpriseId;
    }

    public int getMaxRepetitions() {
        return this._maxRepetitions;
    }

    public int getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public int getPort() {
        return this._port;
    }

    public String getPrivacyPassphrase() {
        return this._privacyPassphrase;
    }

    public String getPrivacyProtocol() {
        return this._privacyProtocol;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public String getReadCommunity() {
        return this._readCommunity;
    }

    public int getRetry() {
        return this._retry;
    }

    public String getSecurityName() {
        return this._securityName;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWriteCommunity() {
        return this._writeCommunity;
    }

    public boolean hasMaxRepetitions() {
        return this._has_maxRepetitions;
    }

    public boolean hasMaxRequestSize() {
        return this._has_maxRequestSize;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Definition> iterateDefinition() {
        return this._definitionList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllDefinition() {
        this._definitionList.clear();
    }

    public boolean removeDefinition(Definition vDefinition) {
        boolean removed = this._definitionList.remove(vDefinition);
        return removed;
    }

    public Definition removeDefinitionAt(int index) {
        Definition obj = this._definitionList.remove(index);
        return obj;
    }

    public void setAuthPassphrase(String authPassphrase) {
        this._authPassphrase = authPassphrase;
    }

    public void setAuthProtocol(String authProtocol) {
        this._authProtocol = authProtocol;
    }

    public void setContextEngineId(String contextEngineId) {
        this._contextEngineId = contextEngineId;
    }

    public void setContextName(String contextName) {
        this._contextName = contextName;
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("setDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] vDefinitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < vDefinitionArray.length; ++i) {
            this._definitionList.add(vDefinitionArray[i]);
        }
    }

    public void setDefinition(List<Definition> vDefinitionList) {
        this._definitionList.clear();
        this._definitionList.addAll(vDefinitionList);
    }

    public void setDefinitionCollection(List<Definition> definitionList) {
        this._definitionList = definitionList;
    }

    public void setEngineId(String engineId) {
        this._engineId = engineId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this._enterpriseId = enterpriseId;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this._maxRepetitions = maxRepetitions;
        this._has_maxRepetitions = true;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this._maxRequestSize = maxRequestSize;
        this._has_maxRequestSize = true;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this._privacyPassphrase = privacyPassphrase;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this._privacyProtocol = privacyProtocol;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setReadCommunity(String readCommunity) {
        this._readCommunity = readCommunity;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setSecurityName(String securityName) {
        this._securityName = securityName;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setWriteCommunity(String writeCommunity) {
        this._writeCommunity = writeCommunity;
    }

    public static SnmpConfig unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SnmpConfig)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

