/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.config.notifications.Varbind;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notification
implements Serializable {
    private String _name;
    private String _status;
    private String _writeable = "yes";
    private String _uei;
    private String _description;
    private String _rule;
    private String _noticeQueue;
    private String _destinationPath;
    private String _textMessage;
    private String _subject;
    private String _numericMessage;
    private String _eventSeverity;
    private List<Parameter> _parameterList;
    private Varbind _varbind;

    public Notification() {
        this.setWriteable("yes");
        this._parameterList = new ArrayList<Parameter>();
    }

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this._parameterList);
    }

    public String getDescription() {
        return this._description;
    }

    public String getDestinationPath() {
        return this._destinationPath;
    }

    public String getEventSeverity() {
        return this._eventSeverity;
    }

    public String getName() {
        return this._name;
    }

    public String getNoticeQueue() {
        return this._noticeQueue;
    }

    public String getNumericMessage() {
        return this._numericMessage;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        return this._parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this._parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this._parameterList;
    }

    public int getParameterCount() {
        return this._parameterList.size();
    }

    public String getRule() {
        return this._rule;
    }

    public String getStatus() {
        return this._status;
    }

    public String getSubject() {
        return this._subject;
    }

    public String getTextMessage() {
        return this._textMessage;
    }

    public String getUei() {
        return this._uei;
    }

    public Varbind getVarbind() {
        return this._varbind;
    }

    public String getWriteable() {
        return this._writeable;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Parameter> iterateParameter() {
        return this._parameterList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParameter() {
        this._parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this._parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this._parameterList.remove(index);
        return obj;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDestinationPath(String destinationPath) {
        this._destinationPath = destinationPath;
    }

    public void setEventSeverity(String eventSeverity) {
        this._eventSeverity = eventSeverity;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNoticeQueue(String noticeQueue) {
        this._noticeQueue = noticeQueue;
    }

    public void setNumericMessage(String numericMessage) {
        this._numericMessage = numericMessage;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        this._parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this._parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this._parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this._parameterList.clear();
        this._parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this._parameterList = parameterList;
    }

    public void setRule(String rule) {
        this._rule = rule;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public void setTextMessage(String textMessage) {
        this._textMessage = textMessage;
    }

    public void setUei(String uei) {
        this._uei = uei;
    }

    public void setVarbind(Varbind varbind) {
        this._varbind = varbind;
    }

    public void setWriteable(String writeable) {
        this._writeable = writeable;
    }

    public static Notification unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Notification)Unmarshaller.unmarshal(Notification.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

