/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.capsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.capsd.IpManagement;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.SmbConfig;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapsdConfiguration
implements Serializable {
    private long _rescanFrequency = 0L;
    private boolean _has_rescanFrequency;
    private long _initialSleepTime = 0L;
    private boolean _has_initialSleepTime;
    private int _maxSuspectThreadPoolSize;
    private boolean _has_maxSuspectThreadPoolSize;
    private int _maxRescanThreadPoolSize;
    private boolean _has_maxRescanThreadPoolSize;
    private String _managementPolicy = "managed";
    private String _abortProtocolScansIfNoRoute = "false";
    private String _deletePropagationEnabled = "true";
    private String _xmlrpc = "false";
    private List<ProtocolPlugin> _protocolPluginList;
    private SmbConfig _smbConfig;
    private List<IpManagement> _ipManagementList;

    public CapsdConfiguration() {
        this.setManagementPolicy("managed");
        this.setAbortProtocolScansIfNoRoute("false");
        this.setDeletePropagationEnabled("true");
        this.setXmlrpc("false");
        this._protocolPluginList = new ArrayList<ProtocolPlugin>();
        this._ipManagementList = new ArrayList<IpManagement>();
    }

    public void addIpManagement(IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(vIpManagement);
    }

    public void addIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(index, vIpManagement);
    }

    public void addProtocolPlugin(ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(vProtocolPlugin);
    }

    public void addProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(index, vProtocolPlugin);
    }

    public void deleteInitialSleepTime() {
        this._has_initialSleepTime = false;
    }

    public void deleteMaxRescanThreadPoolSize() {
        this._has_maxRescanThreadPoolSize = false;
    }

    public void deleteMaxSuspectThreadPoolSize() {
        this._has_maxSuspectThreadPoolSize = false;
    }

    public void deleteRescanFrequency() {
        this._has_rescanFrequency = false;
    }

    public Enumeration<IpManagement> enumerateIpManagement() {
        return Collections.enumeration(this._ipManagementList);
    }

    public Enumeration<ProtocolPlugin> enumerateProtocolPlugin() {
        return Collections.enumeration(this._protocolPluginList);
    }

    public String getAbortProtocolScansIfNoRoute() {
        return this._abortProtocolScansIfNoRoute;
    }

    public String getDeletePropagationEnabled() {
        return this._deletePropagationEnabled;
    }

    public long getInitialSleepTime() {
        return this._initialSleepTime;
    }

    public IpManagement getIpManagement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException("getIpManagement: Index value '" + index + "' not in range [0.." + (this._ipManagementList.size() - 1) + "]");
        }
        return this._ipManagementList.get(index);
    }

    public IpManagement[] getIpManagement() {
        IpManagement[] array = new IpManagement[]{};
        return this._ipManagementList.toArray(array);
    }

    public List<IpManagement> getIpManagementCollection() {
        return this._ipManagementList;
    }

    public int getIpManagementCount() {
        return this._ipManagementList.size();
    }

    public String getManagementPolicy() {
        return this._managementPolicy;
    }

    public int getMaxRescanThreadPoolSize() {
        return this._maxRescanThreadPoolSize;
    }

    public int getMaxSuspectThreadPoolSize() {
        return this._maxSuspectThreadPoolSize;
    }

    public ProtocolPlugin getProtocolPlugin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException("getProtocolPlugin: Index value '" + index + "' not in range [0.." + (this._protocolPluginList.size() - 1) + "]");
        }
        return this._protocolPluginList.get(index);
    }

    public ProtocolPlugin[] getProtocolPlugin() {
        ProtocolPlugin[] array = new ProtocolPlugin[]{};
        return this._protocolPluginList.toArray(array);
    }

    public List<ProtocolPlugin> getProtocolPluginCollection() {
        return this._protocolPluginList;
    }

    public int getProtocolPluginCount() {
        return this._protocolPluginList.size();
    }

    public long getRescanFrequency() {
        return this._rescanFrequency;
    }

    public SmbConfig getSmbConfig() {
        return this._smbConfig;
    }

    public String getXmlrpc() {
        return this._xmlrpc;
    }

    public boolean hasInitialSleepTime() {
        return this._has_initialSleepTime;
    }

    public boolean hasMaxRescanThreadPoolSize() {
        return this._has_maxRescanThreadPoolSize;
    }

    public boolean hasMaxSuspectThreadPoolSize() {
        return this._has_maxSuspectThreadPoolSize;
    }

    public boolean hasRescanFrequency() {
        return this._has_rescanFrequency;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<IpManagement> iterateIpManagement() {
        return this._ipManagementList.iterator();
    }

    public Iterator<ProtocolPlugin> iterateProtocolPlugin() {
        return this._protocolPluginList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpManagement() {
        this._ipManagementList.clear();
    }

    public void removeAllProtocolPlugin() {
        this._protocolPluginList.clear();
    }

    public boolean removeIpManagement(IpManagement vIpManagement) {
        boolean removed = this._ipManagementList.remove(vIpManagement);
        return removed;
    }

    public IpManagement removeIpManagementAt(int index) {
        IpManagement obj = this._ipManagementList.remove(index);
        return obj;
    }

    public boolean removeProtocolPlugin(ProtocolPlugin vProtocolPlugin) {
        boolean removed = this._protocolPluginList.remove(vProtocolPlugin);
        return removed;
    }

    public ProtocolPlugin removeProtocolPluginAt(int index) {
        ProtocolPlugin obj = this._protocolPluginList.remove(index);
        return obj;
    }

    public void setAbortProtocolScansIfNoRoute(String abortProtocolScansIfNoRoute) {
        this._abortProtocolScansIfNoRoute = abortProtocolScansIfNoRoute;
    }

    public void setDeletePropagationEnabled(String deletePropagationEnabled) {
        this._deletePropagationEnabled = deletePropagationEnabled;
    }

    public void setInitialSleepTime(long initialSleepTime) {
        this._initialSleepTime = initialSleepTime;
        this._has_initialSleepTime = true;
    }

    public void setIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException("setIpManagement: Index value '" + index + "' not in range [0.." + (this._ipManagementList.size() - 1) + "]");
        }
        this._ipManagementList.set(index, vIpManagement);
    }

    public void setIpManagement(IpManagement[] vIpManagementArray) {
        this._ipManagementList.clear();
        for (int i = 0; i < vIpManagementArray.length; ++i) {
            this._ipManagementList.add(vIpManagementArray[i]);
        }
    }

    public void setIpManagement(List<IpManagement> vIpManagementList) {
        this._ipManagementList.clear();
        this._ipManagementList.addAll(vIpManagementList);
    }

    public void setIpManagementCollection(List<IpManagement> ipManagementList) {
        this._ipManagementList = ipManagementList;
    }

    public void setManagementPolicy(String managementPolicy) {
        this._managementPolicy = managementPolicy;
    }

    public void setMaxRescanThreadPoolSize(int maxRescanThreadPoolSize) {
        this._maxRescanThreadPoolSize = maxRescanThreadPoolSize;
        this._has_maxRescanThreadPoolSize = true;
    }

    public void setMaxSuspectThreadPoolSize(int maxSuspectThreadPoolSize) {
        this._maxSuspectThreadPoolSize = maxSuspectThreadPoolSize;
        this._has_maxSuspectThreadPoolSize = true;
    }

    public void setProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException("setProtocolPlugin: Index value '" + index + "' not in range [0.." + (this._protocolPluginList.size() - 1) + "]");
        }
        this._protocolPluginList.set(index, vProtocolPlugin);
    }

    public void setProtocolPlugin(ProtocolPlugin[] vProtocolPluginArray) {
        this._protocolPluginList.clear();
        for (int i = 0; i < vProtocolPluginArray.length; ++i) {
            this._protocolPluginList.add(vProtocolPluginArray[i]);
        }
    }

    public void setProtocolPlugin(List<ProtocolPlugin> vProtocolPluginList) {
        this._protocolPluginList.clear();
        this._protocolPluginList.addAll(vProtocolPluginList);
    }

    public void setProtocolPluginCollection(List<ProtocolPlugin> protocolPluginList) {
        this._protocolPluginList = protocolPluginList;
    }

    public void setRescanFrequency(long rescanFrequency) {
        this._rescanFrequency = rescanFrequency;
        this._has_rescanFrequency = true;
    }

    public void setSmbConfig(SmbConfig smbConfig) {
        this._smbConfig = smbConfig;
    }

    public void setXmlrpc(String xmlrpc) {
        this._xmlrpc = xmlrpc;
    }

    public static CapsdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CapsdConfiguration)Unmarshaller.unmarshal(CapsdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

