/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class SnmpPeerFactory
implements SnmpAgentConfigFactory {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpPeerFactory.class);
    private static final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private static final Lock m_readLock = m_globalLock.readLock();
    private static final Lock m_writeLock = m_globalLock.writeLock();
    private static SnmpPeerFactory m_singleton = null;
    public static SnmpConfig m_config;
    private static File m_configFile;
    private static boolean m_loaded;

    private SnmpPeerFactory(File configFile) throws IOException {
        this((Resource)new FileSystemResource(configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(Resource resource) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(Reader rdr) throws IOException {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Reader)rdr);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(String configString) throws IOException {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (String)configString);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(InputStream stream) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (InputSource)new InputSource(stream), null);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public static Lock getReadLock() {
        return m_readLock;
    }

    public static Lock getWriteLock() {
        return m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws IOException {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            if (m_loaded) {
                return;
            }
            File cfgFile = SnmpPeerFactory.getFile();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            m_singleton = new SnmpPeerFactory(cfgFile);
            m_loaded = true;
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public static void saveCurrent() throws IOException {
        SnmpPeerFactory.saveToFile(SnmpPeerFactory.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        FileOutputStream out = null;
        OutputStreamWriter fileWriter = null;
        SnmpPeerFactory.getWriteLock().lock();
        try {
            if (marshalledConfig != null) {
                out = new FileOutputStream(file);
                fileWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                fileWriter.write(marshalledConfig);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(out);
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpPeerFactory getInstance() {
        SnmpPeerFactory.getReadLock().lock();
        try {
            if (!m_loaded) {
                throw new IllegalStateException("The factory has not been initialized");
            }
            SnmpPeerFactory snmpPeerFactory = m_singleton;
            return snmpPeerFactory;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFile(File configFile) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            File oldFile = m_configFile;
            m_configFile = configFile;
            if (oldFile == null || m_configFile == null || !oldFile.equals(m_configFile)) {
                m_singleton = null;
                m_loaded = false;
            }
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile() throws IOException {
        SnmpPeerFactory.getReadLock().lock();
        try {
            if (m_configFile == null) {
                SnmpPeerFactory.setFile(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
            }
            File file = m_configFile;
            return file;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(SnmpPeerFactory singleton) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            m_singleton = singleton;
            m_loaded = true;
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        SnmpPeerFactory.getReadLock().lock();
        try {
            if (m_config == null) {
                SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
                if (requestedSnmpVersion == -1) {
                    agentConfig.setVersion(1);
                } else {
                    agentConfig.setVersion(requestedSnmpVersion);
                }
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
            AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agentInetAddress);
            m_config.visit((SnmpConfigVisitor)visitor);
            Definition matchingDef = visitor.getDefinition();
            if (matchingDef != null) {
                this.setSnmpAgentConfig(agentConfig, matchingDef, requestedSnmpVersion);
            }
            SnmpAgentConfig snmpAgentConfig = agentConfig;
            return snmpAgentConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.getVersionCode(def, m_config, requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(def.getSecurityLevel().intValue());
        agentConfig.setSecurityName(def.getSecurityName());
        agentConfig.setAuthProtocol(def.getAuthProtocol());
        agentConfig.setAuthPassPhrase(def.getAuthPassphrase());
        agentConfig.setPrivPassPhrase(def.getPrivacyPassphrase());
        agentConfig.setPrivProtocol(def.getPrivacyProtocol());
        agentConfig.setReadCommunity(def.getReadCommunity());
        agentConfig.setWriteCommunity(def.getWriteCommunity());
        agentConfig.setContextName(def.getContextName());
        agentConfig.setEngineId(def.getEngineId());
        agentConfig.setContextEngineId(def.getContextEngineId());
        agentConfig.setEnterpriseId(def.getEnterpriseId());
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(def.getPort().intValue());
        agentConfig.setRetries(def.getRetry().intValue());
        agentConfig.setTimeout(def.getTimeout().intValue());
        agentConfig.setMaxRequestSize(def.getMaxRequestSize().intValue());
        agentConfig.setMaxVarsPerPdu(def.getMaxVarsPerPdu().intValue());
        agentConfig.setMaxRepetitions(def.getMaxRepetitions().intValue());
        InetAddress proxyHost = InetAddressUtils.addr((String)def.getProxyHost());
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(proxyHost);
        }
    }

    public int getVersionCode(Definition def, SnmpConfig config, int requestedSnmpVersion) {
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (config.getVersion() == null) {
                    return 1;
                }
                return SnmpConfiguration.stringToVersion((String)config.getVersion());
            }
            return SnmpConfiguration.stringToVersion((String)def.getVersion());
        }
        return requestedSnmpVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpConfig getSnmpConfig() {
        SnmpPeerFactory.getReadLock().lock();
        try {
            SnmpConfig snmpConfig = m_config;
            return snmpConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void define(SnmpEventInfo info) {
        SnmpPeerFactory.getWriteLock().lock();
        try {
            SnmpConfigManager mgr = new SnmpConfigManager(m_config);
            mgr.mergeIntoConfig(info.createDef());
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshallConfig() {
        SnmpPeerFactory.getReadLock().lock();
        try {
            String marshalledConfig = null;
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                JaxbUtils.marshal((Object)m_config, (Writer)writer);
                marshalledConfig = writer.toString();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            String string = marshalledConfig;
            return string;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    static {
        m_loaded = false;
    }
}

