/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.config.snmpinterfacepoller.CriticalService;
import org.opennms.netmgt.config.snmpinterfacepoller.ExcludeRange;
import org.opennms.netmgt.config.snmpinterfacepoller.IncludeRange;
import org.opennms.netmgt.config.snmpinterfacepoller.Interface;
import org.opennms.netmgt.config.snmpinterfacepoller.Package;
import org.opennms.netmgt.config.snmpinterfacepoller.SnmpInterfacePollerConfiguration;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpInterfacePollerConfigManager
implements SnmpInterfacePollerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpInterfacePollerConfigManager.class);
    private SnmpInterfacePollerConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<InetAddress>> m_pkgIpMap;
    private Map<String, Map<String, Interface>> m_pkgIntMap;
    private static boolean m_verifyServer;
    private static String m_localServer;

    public SnmpInterfacePollerConfigManager(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = localServer;
        m_verifyServer = verifyServer;
        this.reloadXML(stream);
    }

    @Override
    public abstract void update() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXml(String var1) throws IOException;

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.fetch((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    protected synchronized void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.m_config = (SnmpInterfacePollerConfiguration)CastorUtils.unmarshal(SnmpInterfacePollerConfiguration.class, (InputStream)stream);
        this.createUrlIpMap();
        this.createPackageIpListMap();
    }

    public synchronized void save() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.update();
    }

    public synchronized SnmpInterfacePollerConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized Package getPackage(String name) {
        for (Package pkg : this.packages()) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    public synchronized void addPackage(Package pkg) {
        this.m_config.addPackage(pkg);
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    @Override
    public synchronized String[] getCriticalServiceIds() {
        CriticalService[] cs = this.m_config.getNodeOutage().getCriticalService();
        String[] criticalServiceNames = new String[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            criticalServiceNames[i] = cs[i].getName();
        }
        return criticalServiceNames;
    }

    private void createPackageIpListMap() {
        this.m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
        this.m_pkgIntMap = new HashMap<String, Map<String, Interface>>();
        for (Package pkg : this.packages()) {
            HashMap<String, Interface> interfaceMap = new HashMap<String, Interface>();
            for (Interface interf : pkg.getInterfaceCollection()) {
                interfaceMap.put(interf.getName(), interf);
            }
            this.m_pkgIntMap.put(pkg.getName(), interfaceMap);
            try {
                List<InetAddress> ipList = this.getIpList(pkg);
                LOG.debug("createPackageIpMap: package {}: ipList size = {}", (Object)ipList.size(), (Object)pkg.getName());
                if (ipList.size() <= 0) continue;
                LOG.debug("createPackageIpMap: package {}. IpList size is {}", (Object)ipList.size(), (Object)pkg.getName());
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                LOG.error("createPackageIpMap: failed to map package: {} to an IP List", (Object)pkg.getName(), (Object)t);
            }
        }
    }

    public List<InetAddress> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        LOG.debug("createPackageIpMap: package is {}. filer rules are {}", (Object)filterRules, (Object)pkg.getName());
        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
        List<InetAddress> ipList = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
        return ipList;
    }

    @Override
    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        boolean filterPassed = false;
        List<InetAddress> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{filterPassed, iface, pkg.getName()});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecificCollection()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    public synchronized Package getPackageForAddress(String ipaddr) {
        for (Package pkg : this.packages()) {
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public synchronized List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : this.packages()) {
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            matchingPkgs.add(pkg.getName());
        }
        return matchingPkgs;
    }

    @Override
    public synchronized String getPackageName(String ipaddr) {
        for (Package pkg : this.packages()) {
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            return pkg.getName();
        }
        return null;
    }

    @Override
    public synchronized Set<String> getInterfaceOnPackage(String pkgName) {
        if (this.m_pkgIntMap.containsKey(pkgName)) {
            return Collections.unmodifiableSet(this.m_pkgIntMap.get(pkgName).keySet());
        }
        Set retval = Collections.emptySet();
        return Collections.unmodifiableSet(retval);
    }

    @Override
    public synchronized boolean getStatus(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getStatus().equals("on");
    }

    @Override
    public synchronized long getInterval(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getInterval();
    }

    @Override
    public synchronized String getCriteria(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getCriteria();
    }

    @Override
    public synchronized boolean hasPort(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).hasPort();
    }

    @Override
    public synchronized int getPort(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getPort();
    }

    @Override
    public synchronized boolean hasTimeout(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).hasTimeout();
    }

    @Override
    public synchronized int getTimeout(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getTimeout();
    }

    @Override
    public synchronized boolean hasRetries(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).hasRetry();
    }

    @Override
    public synchronized int getRetries(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getRetry();
    }

    @Override
    public synchronized boolean hasMaxVarsPerPdu(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).hasMaxVarsPerPdu();
    }

    @Override
    public synchronized int getMaxVarsPerPdu(String pkgName, String pkgInterfaceName) {
        return this.m_pkgIntMap.get(pkgName).get(pkgInterfaceName).getMaxVarsPerPdu();
    }

    public Enumeration<Package> enumeratePackage() {
        return this.getConfiguration().enumeratePackage();
    }

    public Iterable<Package> packages() {
        return this.getConfiguration().getPackageCollection();
    }

    public Iterable<String> includeURLs(Package pkg) {
        return pkg.getIncludeUrlCollection();
    }

    @Override
    public int getThreads() {
        return this.getConfiguration().getThreads();
    }

    @Override
    public long getInterval() {
        return this.getConfiguration().getInterval();
    }

    @Override
    public String getService() {
        return this.getConfiguration().getService();
    }

    @Override
    public boolean useCriteriaFilters() {
        return Boolean.parseBoolean(this.getConfiguration().getUseCriteriaFilters());
    }
}

