/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.config.ConfigObjectRetrievalFailureException;
import org.opennms.netmgt.config.DefaultServiceMonitorLocator;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.CriticalService;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollerConfigManager
implements PollerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected PollerConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private AtomicReference<Map<Package, List<InetAddress>>> m_pkgIpMap = new AtomicReference();
    private Map<String, ServiceMonitor> m_svcMonitors = new ConcurrentSkipListMap<String, ServiceMonitor>();
    private static boolean m_verifyServer;
    private static String m_localServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollerConfigManager(InputStream stream, String localServer, boolean verifyServer) {
        m_localServer = localServer;
        m_verifyServer = verifyServer;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(stream);
            this.m_config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (Reader)isr);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        this.setUpInternalData();
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    protected void setUpInternalData() {
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.initializeServiceMonitors();
    }

    @Override
    public abstract void update() throws IOException;

    protected abstract void saveXml(String var1) throws IOException;

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.fetch((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        try {
            this.getWriteLock().lock();
            this.saveXml(JaxbUtils.marshal((Object)this.m_config));
            this.update();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollerConfiguration getConfiguration() {
        try {
            this.getReadLock().lock();
            PollerConfiguration pollerConfiguration = this.m_config;
            return pollerConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!pkg.getName().equals(name)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceSelector getServiceSelectorForPackage(Package pkg) {
        try {
            this.getReadLock().lock();
            LinkedList<String> svcNames = new LinkedList<String>();
            for (Service svc : this.services(pkg)) {
                svcNames.add(svc.getName());
            }
            String filter = pkg.getFilter().getContent();
            ServiceSelector serviceSelector = new ServiceSelector(filter, svcNames);
            return serviceSelector;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackage(Package pkg) {
        try {
            this.getWriteLock().lock();
            this.m_config.addPackage(pkg);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMonitor(String svcName, String className) {
        try {
            this.getWriteLock().lock();
            Monitor monitor = new Monitor();
            monitor.setService(svcName);
            monitor.setClassName(className);
            this.m_config.addMonitor(monitor);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldNotifyXmlrpc() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getXmlrpc());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPathOutageEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getPathOutageEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCriticalService() {
        try {
            this.getReadLock().lock();
            CriticalService service = this.m_config.getNodeOutage().getCriticalService();
            String string = service == null ? null : service.getName();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldPollAllIfNoCriticalServiceDefined() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getNodeOutage().getPollAllIfNoCriticalServiceDefined());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeOutageProcessingEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.getNodeOutage().getStatus().equals("on");
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceUnresponsiveEnabled() {
        try {
            this.getReadLock().lock();
            boolean bl = Boolean.valueOf(this.m_config.getServiceUnresponsiveEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        this.getReadLock().lock();
        try {
            HashMap<Package, List<InetAddress>> pkgIpMap = new HashMap<Package, List<InetAddress>>();
            for (Package pkg : this.packages()) {
                try {
                    List<InetAddress> ipList = this.getIpList(pkg);
                    LOG.debug("createPackageIpMap: package {}: ipList size = {}", (Object)pkg.getName(), (Object)ipList.size());
                    if (ipList.size() <= 0) continue;
                    pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LOG.error("createPackageIpMap: failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent(), t});
                }
            }
            this.m_pkgIpMap.set(pkgIpMap);
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetAddress> getIpList(Package pkg) {
        try {
            this.getReadLock().lock();
            StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
            if (m_verifyServer) {
                filterRules.append(" & (serverName == ");
                filterRules.append('\"');
                filterRules.append(m_localServer);
                filterRules.append('\"');
                filterRules.append(")");
            }
            LOG.debug("createPackageIpMap: package is {}. filter rules are {}", (Object)pkg.getName(), (Object)filterRules);
            FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
            List<InetAddress> list = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    @Override
    public boolean isInterfaceInPackage(String iface, Package pkg) {
        int endComparison;
        int comparison;
        boolean filterPassed = false;
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        List<InetAddress> ipList = this.m_pkgIpMap.get().get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{iface, pkg.getName(), filterPassed});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRanges().size() == 0 && pkg.getSpecifics().size() == 0;
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (IncludeRange rng : pkg.getIncludeRanges()) {
            comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
            if (comparison > 0) {
                endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                if (endComparison > 0) continue;
                has_range_include = true;
                break;
            }
            if (comparison != 0) continue;
            has_range_include = true;
            break;
        }
        for (String spec : pkg.getSpecifics()) {
            if (new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)spec)) != 0) continue;
            has_specific = true;
            break;
        }
        for (String includeUrl : pkg.getIncludeUrls()) {
            if (!this.interfaceInUrl(iface, includeUrl)) continue;
            has_specific = true;
            break;
        }
        if (!has_specific) {
            for (IncludeRange rng : pkg.getExcludeRanges()) {
                comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
                if (comparison > 0) {
                    endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                    if (endComparison > 0) continue;
                    has_range_exclude = true;
                    break;
                }
                if (comparison != 0) continue;
                has_range_exclude = true;
                break;
            }
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceInPackageAndEnabled(String svcName, Package pkg) {
        try {
            this.getReadLock().lock();
            if (pkg == null) {
                LOG.warn("serviceInPackageAndEnabled:  pkg argument is NULL!!");
                boolean bl = false;
                return bl;
            }
            LOG.debug("serviceInPackageAndEnabled: svcName={} pkg={}", (Object)svcName, (Object)pkg.getName());
            for (Service svc : this.services(pkg)) {
                String status;
                if (!svc.getName().equalsIgnoreCase(svcName) || (status = svc.getStatus()) != null && !status.equals("on")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getServiceInPackage(String svcName, Package pkg) {
        try {
            this.getReadLock().lock();
            for (Service svc : this.services(pkg)) {
                if (!svcName.equals(svc.getName())) continue;
                Service service = svc;
                return service;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceMonitored(String svcName) {
        try {
            this.getReadLock().lock();
            for (Monitor monitor : this.monitors()) {
                if (!monitor.getService().equals(svcName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstPackageMatch(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstLocalPackageMatch(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (pkg.getRemote().booleanValue() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                matchingPkgs.add(pkg.getName());
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr) {
        try {
            this.getReadLock().lock();
            for (Package pkg : this.packages()) {
                if (pkg.getRemote().booleanValue() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    @Override
    public boolean isPolled(String svcName, Package pkg) {
        if (this.isServiceInPackageAndEnabled(svcName, pkg)) {
            return this.isServiceMonitored(svcName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr, String svcName) {
        try {
            this.getReadLock().lock();
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr, String svcName) {
        try {
            this.getReadLock().lock();
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStep(Package pkg) {
        try {
            this.getReadLock().lock();
            int n = pkg.getRrd().getStep();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRRAList(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getRrd().getRras();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Package> enumeratePackage() {
        try {
            this.getReadLock().lock();
            Enumeration<Package> enumeration = Collections.enumeration(this.getConfiguration().getPackages());
            return enumeration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Service> services(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getServices();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<String> includeURLs(Package pkg) {
        try {
            this.getReadLock().lock();
            List list = pkg.getIncludeUrls();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Parameter> parameters(Service svc) {
        try {
            this.getReadLock().lock();
            List list = svc.getParameters();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Package> packages() {
        try {
            this.getReadLock().lock();
            List list = this.getConfiguration().getPackages();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Monitor> monitors() {
        try {
            this.getReadLock().lock();
            List list = this.getConfiguration().getMonitors();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThreads() {
        try {
            this.getReadLock().lock();
            int n = this.getConfiguration().getThreads();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void initializeServiceMonitors() {
        LOG.debug("start: Loading monitors");
        Collection<ServiceMonitorLocator> locators = this.getServiceMonitorLocators(DistributionContext.DAEMON);
        for (ServiceMonitorLocator locator : locators) {
            try {
                this.m_svcMonitors.put(locator.getServiceName(), locator.getServiceMonitor());
            }
            catch (Throwable t) {
                LOG.warn("start: Failed to create monitor {} for service {}", new Object[]{locator.getServiceLocatorKey(), locator.getServiceName(), t});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ServiceMonitor> getServiceMonitors() {
        try {
            this.getReadLock().lock();
            Map<String, ServiceMonitor> map = Collections.unmodifiableMap(this.m_svcMonitors);
            return map;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceMonitor getServiceMonitor(String svcName) {
        try {
            this.getReadLock().lock();
            ServiceMonitor serviceMonitor = this.getServiceMonitors().get(svcName);
            return serviceMonitor;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
        try {
            this.getReadLock().lock();
            for (Monitor monitor : this.monitors()) {
                try {
                    Class<? extends ServiceMonitor> mc = this.findServiceMonitorClass(monitor);
                    if (!this.isDistributableToContext(mc, context)) continue;
                    DefaultServiceMonitorLocator locator = new DefaultServiceMonitorLocator(monitor.getService(), mc);
                    locators.add(locator);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Unable to location monitor for service: {} class-name: {}", new Object[]{monitor.getService(), monitor.getClassName(), e});
                }
                catch (ConfigObjectRetrievalFailureException e) {
                    LOG.warn("{} {}", new Object[]{e.getMessage(), e.getRootCause(), e});
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return locators;
    }

    private boolean isDistributableToContext(Class<? extends ServiceMonitor> mc, DistributionContext context) {
        List<DistributionContext> supportedContexts = this.getSupportedDistributionContexts(mc);
        return supportedContexts.contains(context) || supportedContexts.contains(DistributionContext.ALL);
    }

    private List<DistributionContext> getSupportedDistributionContexts(Class<? extends ServiceMonitor> mc) {
        Distributable distributable = mc.getAnnotation(Distributable.class);
        List<DistributionContext> declaredContexts = distributable == null ? Collections.singletonList(DistributionContext.DAEMON) : Arrays.asList(distributable.value());
        return declaredContexts;
    }

    private Class<? extends ServiceMonitor> findServiceMonitorClass(Monitor monitor) throws ClassNotFoundException {
        Class<ServiceMonitor> mc = Class.forName(monitor.getClassName()).asSubclass(ServiceMonitor.class);
        if (!ServiceMonitor.class.isAssignableFrom(mc)) {
            throw new MarshallingResourceFailureException("The monitor for service: " + monitor.getService() + " class-name: " + monitor.getClassName() + " must implement ServiceMonitor");
        }
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNextOutageIdSql() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getNextOutageId();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllServiceMonitors() {
        try {
            this.getWriteLock().lock();
            for (ServiceMonitor sm : this.getServiceMonitors().values()) {
                sm.release();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

