/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filter;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.filter.Table;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class JdbcFilterDao
implements FilterDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcFilterDao.class);
    private static final Pattern SQL_KEYWORD_PATTERN = Pattern.compile("\\s+(?:AND|OR|(?:NOT )?(?:LIKE|IN)|IS (?:NOT )?DISTINCT FROM)\\s+|(?:\\s+IS (?:NOT )?NULL|::(?:TIMESTAMP|INET))(?!\\w)|(?<!\\w)(?:NOT\\s+|IPLIKE(?=\\())", 66);
    private static final Pattern SQL_QUOTE_PATTERN = Pattern.compile("'(?:[^']|'')*'|\"(?:[^\"]|\"\")*\"");
    private static final Pattern SQL_ESCAPED_PATTERN = Pattern.compile("###@(\\d+)@###");
    private static final Pattern SQL_VALUE_COLUMN_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]*[a-zA-Z][a-zA-Z0-9_\\-]*");
    private static final Pattern SQL_IPLIKE_PATTERN = Pattern.compile("(\\w+)\\s+IPLIKE\\s+([0-9.*,-]+|###@\\d+@###)", 66);
    private DataSource m_dataSource;
    private DatabaseSchemaConfigFactory m_databaseSchemaConfigFactory;

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory factory) {
        this.m_databaseSchemaConfigFactory = factory;
    }

    public DatabaseSchemaConfigFactory getDatabaseSchemaConfigFactory() {
        return this.m_databaseSchemaConfigFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource cannot be null");
        Assert.state((this.m_databaseSchemaConfigFactory != null ? 1 : 0) != 0, (String)"property databaseSchemaConfigFactory cannot be null");
    }

    @Override
    public SortedMap<Integer, String> getNodeMap(String rule) throws FilterParseException {
        TreeMap<Integer, String> resultMap = new TreeMap<Integer, String>();
        LOG.debug("Filter.getNodeMap({})", (Object)rule);
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getNodeMappingStatement(rule);
            LOG.debug("Filter.getNodeMap({}): SQL statement: {}", (Object)rule, (Object)sqlString);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    resultMap.put(rset.getInt(1), rset.getString(2));
                }
            }
        }
        catch (FilterParseException e) {
            LOG.warn("Filter Parse Exception occurred getting node map.", (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting node map: " + e.getLocalizedMessage(), e);
        }
        catch (SQLException e) {
            LOG.warn("SQL Exception occurred getting node map.", (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting node map: " + e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LOG.error("Exception getting database connection.", e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return Collections.unmodifiableSortedMap(resultMap);
    }

    @Override
    public Map<InetAddress, Set<String>> getIPAddressServiceMap(String rule) throws FilterParseException {
        TreeMap<InetAddress, Set<String>> ipServices = new TreeMap<InetAddress, Set<String>>((Comparator<InetAddress>)new InetAddressComparator());
        LOG.debug("Filter.getIPAddressServiceMap({})", (Object)rule);
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getIPServiceMappingStatement(rule);
            LOG.debug("Filter.getIPAddressServiceMap({}): SQL statement: {}", (Object)rule, (Object)sqlString);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    InetAddress ipaddr = InetAddressUtils.addr((String)rset.getString(1));
                    if (ipaddr == null) continue;
                    if (!ipServices.containsKey(ipaddr)) {
                        ipServices.put(ipaddr, new TreeSet());
                    }
                    ((Set)ipServices.get(ipaddr)).add(rset.getString(2));
                }
            }
        }
        catch (FilterParseException e) {
            LOG.warn("Filter Parse Exception occurred getting IP Service List.", (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting IP Service List: " + e.getLocalizedMessage(), e);
        }
        catch (SQLException e) {
            LOG.warn("SQL Exception occurred getting IP Service List.", (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting IP Service List: " + e.getLocalizedMessage(), e);
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected exception getting database connection.", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error("Unexpected exception getting database connection.", (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return ipServices;
    }

    @Override
    public List<InetAddress> getActiveIPAddressList(String rule) throws FilterParseException {
        return this.getIPAddressList(rule, true);
    }

    @Override
    public List<InetAddress> getIPAddressList(String rule) throws FilterParseException {
        return this.getIPAddressList(rule, false);
    }

    private List<InetAddress> getIPAddressList(String rule, boolean filterDeleted) throws FilterParseException {
        ArrayList<InetAddress> resultList = new ArrayList<InetAddress>();
        LOG.debug("Filter.getIPAddressList({})", (Object)rule);
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String sqlString = this.getSQLStatement(rule);
            if (filterDeleted && !sqlString.contains("isManaged")) {
                sqlString = sqlString + " AND (ipInterface.isManaged != 'D' or ipInterface.isManaged IS NULL)";
            }
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            LOG.debug("Filter.getIPAddressList({}): SQL statement: {}", (Object)rule, (Object)sqlString);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    resultList.add(InetAddressUtils.addr((String)rset.getString(1)));
                }
            }
        }
        catch (FilterParseException e) {
            LOG.warn("Filter Parse Exception occurred getting IP List.", (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting IP List: " + e.getLocalizedMessage(), e);
        }
        catch (SQLException e) {
            LOG.warn("SQL Exception occurred getting IP List.", (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting IP List: " + e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LOG.error("Exception getting database connection.", e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        LOG.debug("Filter.getIPAddressList({}): resultList = {}", (Object)rule, resultList);
        return resultList;
    }

    @Override
    public boolean isValid(String addr, String rule) throws FilterParseException {
        if (rule.length() == 0) {
            return true;
        }
        return this.getActiveIPAddressList(rule).contains(InetAddressUtils.addr((String)addr));
    }

    @Override
    public boolean isRuleMatching(String rule) throws FilterParseException {
        boolean matches = false;
        LOG.debug("Filter.isRuleMatching({})", (Object)rule);
        DBUtils d = new DBUtils(this.getClass());
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getSQLStatement(rule) + " LIMIT 1";
            LOG.debug("Filter.isRuleMatching({}): SQL statement: {}", (Object)rule, (Object)sqlString);
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            matches = rset.next();
            LOG.debug("isRuleMatching: rule \"{}\" {} an entry in the database", (Object)rule, (Object)(matches ? "matches" : "does not match"));
        }
        catch (FilterParseException e) {
            LOG.warn("Filter Parse Exception occurred testing rule \"{}\" for matching results.", (Object)rule, (Object)e);
            throw new FilterParseException("Filter Parse Exception occurred testing rule \"" + rule + "\" for matching results: " + e.getLocalizedMessage(), e);
        }
        catch (SQLException e) {
            LOG.warn("SQL Exception occurred testing rule \"{}\" for matching results.", (Throwable)e);
            throw new FilterParseException("SQL Exception occurred testing rule \"" + rule + "\" for matching results: " + e.getLocalizedMessage(), e);
        }
        catch (Throwable e) {
            LOG.error("Exception getting database connection.", e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return matches;
    }

    @Override
    public void validateRule(String rule) throws FilterParseException {
        this.isRuleMatching(rule);
    }

    public String getNodeMappingStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "nodeID"));
        columns.append(", " + this.addColumn(tables, "nodeLabel"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    public String getIPServiceMappingStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        columns.append(", " + this.addColumn(tables, "serviceName"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT " + columns.toString() + " " + from + " " + where;
    }

    public String getInterfaceWithServiceStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        columns.append(", " + this.addColumn(tables, "serviceName"));
        columns.append(", " + this.addColumn(tables, "nodeID"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    protected String getSQLStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    protected String getSQLStatement(String rule, long nodeId, String ipaddr, String service) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        StringBuffer where = new StringBuffer(this.parseRule(tables, rule));
        if (nodeId != 0L) {
            where.append(" AND " + this.addColumn(tables, "nodeID") + " = " + nodeId);
        }
        if (ipaddr != null && !ipaddr.equals("")) {
            where.append(" AND " + this.addColumn(tables, "ipAddr") + " = '" + ipaddr + "'");
        }
        if (service != null && !service.equals("")) {
            where.append(" AND " + this.addColumn(tables, "serviceName") + " = '" + service + "'");
        }
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    private String parseRule(List<Table> tables, String rule) throws FilterParseException {
        if (rule != null && rule.length() > 0) {
            ArrayList<String> extractedStrings = new ArrayList<String>();
            String sqlRule = rule;
            Matcher regex = SQL_QUOTE_PATTERN.matcher(sqlRule);
            StringBuffer tempStringBuff = new StringBuffer();
            while (regex.find()) {
                String tempString = regex.group();
                if (tempString.charAt(0) == '\"') {
                    extractedStrings.add("'" + tempString.substring(1, tempString.length() - 1).replaceAll("\"\"", "\"").replaceAll("'", "''") + "'");
                } else {
                    extractedStrings.add(regex.group());
                }
                regex.appendReplacement(tempStringBuff, "###@" + (extractedStrings.size() - 1) + "@###");
            }
            int tempIndex = tempStringBuff.length();
            regex.appendTail(tempStringBuff);
            if (tempStringBuff.substring(tempIndex).indexOf(39) > -1) {
                String message = "Unmatched ' in filter rule '" + rule + "'";
                LOG.error(message);
                throw new FilterParseException(message);
            }
            if (tempStringBuff.substring(tempIndex).indexOf(34) > -1) {
                String message = "Unmatched \" in filter rule '" + rule + "'";
                LOG.error(message);
                throw new FilterParseException(message);
            }
            sqlRule = tempStringBuff.toString();
            sqlRule = sqlRule.replaceAll("\\s*(?:&|&&)\\s*", " AND ");
            sqlRule = sqlRule.replaceAll("\\s*(?:\\||\\|\\|)\\s*", " OR ");
            sqlRule = sqlRule.replaceAll("\\s*!(?!=)\\s*", " NOT ");
            sqlRule = sqlRule.replaceAll("==", "=");
            regex = SQL_IPLIKE_PATTERN.matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                if (regex.group().charAt(0) == '#') {
                    regex.appendReplacement(tempStringBuff, "IPLIKE($1, $2)");
                    continue;
                }
                regex.appendReplacement(tempStringBuff, "IPLIKE($1, '$2')");
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = SQL_KEYWORD_PATTERN.matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                extractedStrings.add(regex.group().toUpperCase());
                regex.appendReplacement(tempStringBuff, "###@" + (extractedStrings.size() - 1) + "@###");
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = SQL_VALUE_COLUMN_PATTERN.matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                if (regex.group().startsWith("is")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "serviceName") + " = '" + regex.group().substring(2) + "'");
                    continue;
                }
                if (regex.group().startsWith("notis")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "ipAddr") + " NOT IN (SELECT ifServices.ipAddr FROM ifServices, service WHERE service.serviceName ='" + regex.group().substring(5) + "' AND service.serviceID = ifServices.serviceID)");
                    continue;
                }
                if (regex.group().startsWith("catinc")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "nodeID") + " IN (SELECT category_node.nodeID FROM category_node, categories WHERE categories.categoryID = category_node.categoryID AND categories.categoryName = '" + regex.group().substring(6) + "')");
                    continue;
                }
                regex.appendReplacement(tempStringBuff, this.addColumn(tables, regex.group()));
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = SQL_ESCAPED_PATTERN.matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                regex.appendReplacement(tempStringBuff, Matcher.quoteReplacement((String)extractedStrings.get(Integer.parseInt(regex.group(1)))));
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            return "WHERE " + sqlRule;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addColumn(List<Table> tables, String column) throws FilterParseException {
        this.m_databaseSchemaConfigFactory.getReadLock().lock();
        try {
            Table table = this.m_databaseSchemaConfigFactory.findTableByVisibleColumn(column);
            if (table == null) {
                String message = "Could not find the column '" + column + "' in filter rule";
                LOG.error(message);
                throw new FilterParseException(message);
            }
            if (!tables.contains(table)) {
                tables.add(table);
            }
            String string = table.getName() + "." + column;
            return string;
        }
        finally {
            this.m_databaseSchemaConfigFactory.getReadLock().unlock();
        }
    }
}

