/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.jasypt.util.password.PasswordEncryptor;
import org.jasypt.util.password.StrongPasswordEncryptor;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.config.users.Header;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.config.users.Userinfo;
import org.opennms.netmgt.config.users.Users;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;

public abstract class UserManager {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final PasswordEncryptor m_passwordEncryptor = new StrongPasswordEncryptor();
    private final ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_readWriteLock.readLock();
    private final Lock m_writeLock = this.m_readWriteLock.writeLock();
    protected GroupManager m_groupManager;
    protected Map<String, User> m_users;
    protected HashMap<String, List<DutySchedule>> m_dutySchedules;
    private Header oldHeader;

    protected UserManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXML(InputStream in) throws MarshalException, ValidationException {
        this.m_writeLock.lock();
        try {
            Userinfo userinfo = (Userinfo)CastorUtils.unmarshal(Userinfo.class, (InputStream)in);
            Users users = userinfo.getUsers();
            this.oldHeader = userinfo.getHeader();
            List usersList = users.getUserCollection();
            this.m_users = new TreeMap<String, User>();
            for (User curUser : usersList) {
                this.m_users.put(curUser.getUserId(), curUser);
            }
            this._buildDutySchedules(this.m_users);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(String name, User details) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            this._writeUser(name, details);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private void _writeUser(String name, User details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("UserFactory:saveUser  null");
        }
        this.m_users.put(name, details);
        this._saveCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OnmsUser onmsUser) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            User castorUser = this._getUser(onmsUser.getUsername());
            if (castorUser == null) {
                castorUser = new User();
                castorUser.setUserId(onmsUser.getUsername());
            }
            castorUser.setFullName(onmsUser.getFullName());
            castorUser.setUserComments(onmsUser.getComments());
            this._setContact(castorUser, ContactType.email, onmsUser.getEmail());
            Password pass = new Password();
            pass.setContent(onmsUser.getPassword());
            pass.setSalt(onmsUser.getPasswordSalted());
            castorUser.setPassword(pass);
            if (onmsUser.getDutySchedule() != null) {
                castorUser.setDutySchedule(onmsUser.getDutySchedule());
            }
            this._writeUser(onmsUser.getUsername(), castorUser);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private void _buildDutySchedules(Map<String, User> users) {
        this.m_dutySchedules = new HashMap();
        for (String key : users.keySet()) {
            User curUser = users.get(key);
            if (curUser.getDutyScheduleCount() <= 0) continue;
            ArrayList<DutySchedule> dutyList = new ArrayList<DutySchedule>();
            for (String duty : curUser.getDutyScheduleCollection()) {
                dutyList.add(new DutySchedule(duty));
            }
            this.m_dutySchedules.put(key, dutyList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserOnDuty(String user, Calendar time) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            if (!this.m_dutySchedules.containsKey(user)) {
                boolean bl = true;
                return bl;
            }
            for (DutySchedule curSchedule : this.m_dutySchedules.get(user)) {
                if (!curSchedule.isInSchedule(time)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.m_readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, User> getUsers() throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            Map<String, User> map = Collections.unmodifiableMap(this.m_users);
            return map;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnmsUserList getOnmsUserList() throws MarshalException, ValidationException, IOException {
        this.update();
        OnmsUserList list = new OnmsUserList();
        this.m_readLock.lock();
        try {
            for (String username : this._getUserNames()) {
                list.add((Object)this._getOnmsUser(username));
            }
            list.setTotalCount(list.getCount());
            OnmsUserList onmsUserList = list;
            return onmsUserList;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnmsUser getOnmsUser(String username) throws MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            OnmsUser onmsUser = this._getOnmsUser(username);
            return onmsUser;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private OnmsUser _getOnmsUser(String username) throws IOException, MarshalException, ValidationException {
        User castorUser = this._getUser(username);
        if (castorUser == null) {
            return null;
        }
        OnmsUser user = new OnmsUser(username);
        user.setFullName(castorUser.getFullName());
        user.setComments(castorUser.getUserComments());
        user.setPassword(castorUser.getPassword().getContent());
        user.setPasswordSalted(castorUser.getPassword().getSalt());
        user.setDutySchedule(castorUser.getDutyScheduleCollection());
        user.setEmail(this._getContactInfo(castorUser, ContactType.email));
        return user;
    }

    private Contact _getContact(String userId, ContactType contactType) {
        User user = this._getUser(userId);
        if (user != null && contactType != null) {
            for (Contact eachContact : user.getContactCollection()) {
                if (!contactType.name().equals(eachContact.getType())) continue;
                return eachContact;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUser(String userName) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            boolean bl = this.m_users.containsKey(userName);
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserNames() throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            List<String> list = this._getUserNames();
            return list;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private List<String> _getUserNames() {
        ArrayList<String> userNames = new ArrayList<String>();
        userNames.addAll(this.m_users.keySet());
        return userNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            User user = this._getUser(name);
            return user;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private User _getUser(String name) {
        return this.m_users.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTuiPin(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String string = this.m_users.get(name).getTuiPin();
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTuiPin(User user) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String string = this.m_users.get(user.getUserId()).getTuiPin();
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public String getMicroblogName(String name) throws MarshalException, ValidationException, FileNotFoundException, IOException {
        return this.getContactInfo(name, ContactType.microblog.toString());
    }

    public String getMicroblogName(User user) throws MarshalException, ValidationException, FileNotFoundException, IOException {
        return this.getContactInfo(user, ContactType.microblog.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContactInfo(String userId, ContactType contactType, String contactValue) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            User user = this._getUser(userId);
            if (user != null) {
                this._setContact(user, contactType, contactValue);
            }
            this._saveCurrent();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private void _setContact(User user, ContactType contactType, String value) {
        if (user != null && !StringUtils.isEmpty((String)value)) {
            Contact contact = this._getContact(user.getUserId(), contactType);
            if (contact == null) {
                contact = new Contact();
                user.addContact(contact);
            }
            contact.setInfo(value);
            contact.setType(contactType.name());
        }
    }

    public String getContactInfo(String userId, ContactType contactType) throws MarshalException, ValidationException, IOException {
        if (userId == null || contactType == null) {
            return null;
        }
        return this.getContactInfo(userId, contactType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContactInfo(String userID, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            User user = this.m_users.get(userID);
            String string = this._getContactInfo(user, command);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContactInfo(User user, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String string = this._getContactInfo(user, command);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private String _getContactInfo(User user, ContactType contactType) {
        return this._getContactInfo(user, contactType.name());
    }

    private String _getContactInfo(User user, String command) {
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals(command)) continue;
            return contact.getInfo();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContactServiceProvider(String userID, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            User user = this.m_users.get(userID);
            String string = this._getContactServiceProvider(user, command);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContactServiceProvider(User user, String command) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String string = this._getContactServiceProvider(user, command);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private String _getContactServiceProvider(User user, String command) {
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals(command)) continue;
            return contact.getServiceProvider();
        }
        return "";
    }

    public String getEmail(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, ContactType.email.toString());
    }

    public String getEmail(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(user, ContactType.email.toString());
    }

    public String getPagerEmail(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, ContactType.pagerEmail.toString());
    }

    public String getPagerEmail(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(user, ContactType.pagerEmail.toString());
    }

    public String getNumericPin(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, ContactType.numericPage.toString());
    }

    public String getNumericPin(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(user, ContactType.numericPage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMPPAddress(String userID) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            User user = this.m_users.get(userID);
            String string = this._getXMPPAddress(user);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMPPAddress(User user) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String string = this._getXMPPAddress(user);
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private String _getXMPPAddress(User user) {
        if (user == null) {
            return "";
        }
        for (Contact contact : user.getContactCollection()) {
            if (contact == null || !contact.getType().equals(ContactType.xmppAddress.toString())) continue;
            return contact.getInfo();
        }
        return "";
    }

    public String getNumericPage(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(userID, ContactType.numericPage.toString());
    }

    public String getNumericPage(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(user, ContactType.numericPage.toString());
    }

    public String getTextPin(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(userID, ContactType.textPage.toString());
    }

    public String getTextPin(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactInfo(user, ContactType.textPage.toString());
    }

    public String getTextPage(String userID) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(userID, ContactType.textPage.toString());
    }

    public String getTextPage(User user) throws IOException, MarshalException, ValidationException {
        return this.getContactServiceProvider(user, ContactType.textPage.toString());
    }

    public String getWorkPhone(String userID) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(userID, ContactType.workPhone.toString());
    }

    public String getWorkPhone(User user) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(user, ContactType.workPhone.toString());
    }

    public String getMobilePhone(String userID) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(userID, ContactType.mobilePhone.toString());
    }

    public String getMobilePhone(User user) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(user, ContactType.mobilePhone.toString());
    }

    public String getHomePhone(String userID) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(userID, ContactType.homePhone.toString());
    }

    public String getHomePhone(User user) throws MarshalException, ValidationException, IOException {
        return this.getContactInfo(user, ContactType.homePhone.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUsers(Collection<User> usersList) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            this.m_users.clear();
            for (User curUser : usersList) {
                this.m_users.put(curUser.getUserId(), curUser);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String name) throws Exception {
        this.m_writeLock.lock();
        try {
            if (!this.m_users.containsKey(name)) {
                throw new Exception("UserFactory:delete The old user name " + name + " is not found");
            }
            this.m_users.remove(name);
            this.m_groupManager.deleteUser(name);
            this._saveCurrent();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private void _saveCurrent() throws Exception {
        Users users = new Users();
        for (User user : this.m_users.values()) {
            users.addUser(user);
        }
        Userinfo userinfo = new Userinfo();
        userinfo.setUsers(users);
        Header header = this.oldHeader;
        if (header != null) {
            header.setCreated(EventConstants.formatToString((Date)new Date()));
            userinfo.setHeader(header);
        }
        this.oldHeader = header;
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)userinfo, (Writer)stringWriter);
        String writerString = stringWriter.toString();
        this.saveXML(writerString);
    }

    protected abstract void saveXML(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameUser(String oldName, String newName) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            User data;
            if (this.m_users.containsKey(oldName)) {
                data = this.m_users.get(oldName);
                if (data == null) {
                    this.m_users.remove(oldName);
                    throw new Exception("UserFactory:rename the data contained for old user " + oldName + " is null");
                }
            } else {
                throw new Exception("UserFactory:rename the old user name " + oldName + " is not found");
            }
            this.m_users.remove(oldName);
            data.setUserId(newName);
            this.m_users.put(newName, data);
            this.m_groupManager.renameUser(oldName, newName);
            this._saveCurrent();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncryptedPassword(String userID, String aPassword, boolean salted) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            User user = this.m_users.get(userID);
            if (user != null) {
                Password pass = new Password();
                pass.setContent(aPassword);
                pass.setSalt(salted);
                user.setPassword(pass);
            }
            this._saveCurrent();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnencryptedPassword(String userID, String aPassword) throws Exception {
        this.update();
        this.m_writeLock.lock();
        try {
            User user = this.m_users.get(userID);
            if (user != null) {
                Password pass = new Password();
                pass.setContent(this.encryptedPassword(aPassword, true));
                pass.setSalt(true);
                user.setPassword(pass);
            }
            this._saveCurrent();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public String encryptedPassword(String aPassword, boolean useSalt) {
        String encryptedPassword = null;
        if (useSalt) {
            encryptedPassword = m_passwordEncryptor.encryptPassword(aPassword);
        } else {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                encryptedPassword = this.hexToString(digest.digest(aPassword.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return encryptedPassword;
    }

    private String hexToString(byte[] data) {
        if (data.length % 2 != 0) {
            return null;
        }
        char[] buffer = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int low = data[i] & 0xF;
            int high = (data[i] & 0xF0) >> 4;
            buffer[i * 2] = HEX[high];
            buffer[i * 2 + 1] = HEX[low];
        }
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean comparePasswords(String userID, String aPassword) {
        this.m_readLock.lock();
        try {
            User user = this.m_users.get(userID);
            if (user == null) {
                boolean bl = false;
                return bl;
            }
            String password = user.getPassword().getContent().trim();
            boolean isSalted = user.getPassword().getSalt();
            if (isSalted) {
                boolean bl = this.checkSaltedPassword(aPassword, password);
                return bl;
            }
            boolean bl = password.equals(this.encryptedPassword(aPassword, false));
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public boolean checkSaltedPassword(String raw, String encrypted) {
        return m_passwordEncryptor.checkPassword(raw, encrypted);
    }

    protected abstract void doUpdate() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        this.m_writeLock.lock();
        try {
            this.doUpdate();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUsersWithRole(String roleid) throws IOException, MarshalException, ValidationException {
        this.update();
        this.m_readLock.lock();
        try {
            String[] stringArray = this._getUsersWithRole(roleid);
            return stringArray;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private String[] _getUsersWithRole(String roleid) throws MarshalException, ValidationException, IOException {
        ArrayList<String> usersWithRole = new ArrayList<String>();
        for (User user : this.m_users.values()) {
            if (!this._userHasRole(user, roleid)) continue;
            usersWithRole.add(user.getUserId());
        }
        return usersWithRole.toArray(new String[usersWithRole.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userHasRole(User user, String roleid) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            boolean bl = this._userHasRole(user, roleid);
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private boolean _userHasRole(User user, String roleid) throws MarshalException, ValidationException, IOException {
        if (roleid == null) {
            throw new NullPointerException("roleid is null");
        }
        return this.m_groupManager.userHasRole(user.getUserId(), roleid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserScheduledForRole(User user, String roleid, Date time) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            boolean bl = this._isUserScheduledForRole(user, roleid, time);
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private boolean _isUserScheduledForRole(User user, String roleid, Date time) throws MarshalException, ValidationException, IOException {
        if (roleid == null) {
            throw new NullPointerException("roleid is null");
        }
        return this.m_groupManager.isUserScheduledForRole(user.getUserId(), roleid, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUsersScheduledForRole(String roleid, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            ArrayList<String> usersScheduledForRole = new ArrayList<String>();
            for (User user : this.m_users.values()) {
                if (!this._isUserScheduledForRole(user, roleid, time)) continue;
                usersScheduledForRole.add(user.getUserId());
            }
            String[] stringArray = usersScheduledForRole.toArray(new String[usersScheduledForRole.size()]);
            return stringArray;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRole(String roleid) throws MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            boolean bl = this.m_groupManager.getRole(roleid) != null;
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countUsersWithRole(String roleid) throws MarshalException, ValidationException, IOException {
        this.update();
        this.m_readLock.lock();
        try {
            String[] users = this._getUsersWithRole(roleid);
            if (users == null) {
                int n = 0;
                return n;
            }
            int n = users.length;
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public abstract boolean isUpdateNeeded();

    public abstract long getLastModified();

    public abstract long getFileSize();

    public abstract void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    public static enum ContactType {
        email,
        pagerEmail,
        xmppAddress,
        microblog,
        numericPage,
        textPage,
        workPhone,
        mobilePhone,
        homePhone;

    }
}

