/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.BaseConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatJdbcPoolConnectionFactory
extends BaseConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatJdbcPoolConnectionFactory.class);
    private DataSource m_dataSource;

    public TomcatJdbcPoolConnectionFactory(JdbcDataSource ds) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(ds);
    }

    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_dataSource = new DataSource();
        this.m_dataSource.setName(dataSource.getName());
        this.m_dataSource.setDriverClassName(dataSource.getClassName());
        this.m_dataSource.setUrl(dataSource.getUrl());
        this.m_dataSource.setUsername(dataSource.getUserName());
        this.m_dataSource.setPassword(dataSource.getPassword());
        Properties properties = new Properties();
        for (Param parameter : dataSource.getParamCollection()) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        if (!properties.isEmpty()) {
            this.m_dataSource.setDbProperties(properties);
        }
        this.m_dataSource.setAccessToUnderlyingConnectionAllowed(true);
        this.m_dataSource.setFairQueue(true);
    }

    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public String getUrl() {
        return this.m_dataSource.getUrl();
    }

    public void setUrl(String url) {
        TomcatJdbcPoolConnectionFactory.validateJdbcUrl((String)url);
        this.m_dataSource.setUrl(url);
    }

    public String getUser() {
        return this.m_dataSource.getUsername();
    }

    public void setUser(String user) {
        this.m_dataSource.setUsername(user);
    }

    public javax.sql.DataSource getDataSource() {
        return this.m_dataSource;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_dataSource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) {
        this.m_dataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    public void close() {
        super.close();
        LOG.info("Closing Tomcat DBCP pool.");
        this.m_dataSource.close();
    }

    public void setIdleTimeout(int idleTimeout) {
        LOG.warn("Tomcat DBCP doesn't have the concept of a generic idle timeout.  Ignoring.");
    }

    public void setMinPool(int minPool) {
        this.m_dataSource.setInitialSize(minPool);
    }

    public void setMaxPool(int maxPool) {
        LOG.warn("Tomcat DBCP doesn't have the concept of a maximum pool.  Ignoring.");
    }

    public void setMaxSize(int maxSize) {
        this.m_dataSource.setMaxActive(maxSize);
    }
}

