/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public class SnmpPeerFactory
implements SnmpAgentConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPeerFactory.class);
    private static final int DEFAULT_SNMP_PORT = 161;
    private static final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private static final Lock m_readLock = m_globalLock.readLock();
    private static final Lock m_writeLock = m_globalLock.writeLock();
    private static SnmpPeerFactory m_singleton = null;
    private static SnmpConfig m_config;
    private static File m_configFile;
    private static boolean m_loaded;
    private static final int VERSION_UNSPECIFIED = -1;

    private SnmpPeerFactory(File configFile) throws IOException {
        this((Resource)new FileSystemResource(configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(Resource resource) {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(Reader rdr) throws IOException {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Reader)rdr);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(String configString) throws IOException {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (String)configString);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPeerFactory(InputStream stream) {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            m_config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (InputSource)new InputSource(stream), null);
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public static Lock getReadLock() {
        return m_readLock;
    }

    public static Lock getWriteLock() {
        return m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws IOException {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            if (m_loaded) {
                return;
            }
            File cfgFile = SnmpPeerFactory.getFile();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            m_singleton = new SnmpPeerFactory(cfgFile);
            m_loaded = true;
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public static void saveCurrent() throws IOException {
        SnmpPeerFactory.saveToFile(SnmpPeerFactory.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        FileOutputStream out = null;
        OutputStreamWriter fileWriter = null;
        try {
            SnmpPeerFactory.getWriteLock().lock();
            if (marshalledConfig != null) {
                out = new FileOutputStream(file);
                fileWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                fileWriter.write(marshalledConfig);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(out);
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpPeerFactory getInstance() {
        try {
            SnmpPeerFactory.getReadLock().lock();
            if (!m_loaded) {
                throw new IllegalStateException("The factory has not been initialized");
            }
            SnmpPeerFactory snmpPeerFactory = m_singleton;
            return snmpPeerFactory;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFile(File configFile) {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            File oldFile = m_configFile;
            m_configFile = configFile;
            if (oldFile == null || m_configFile == null || !oldFile.equals(m_configFile)) {
                m_singleton = null;
                m_loaded = false;
            }
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile() throws IOException {
        try {
            SnmpPeerFactory.getReadLock().lock();
            if (m_configFile == null) {
                SnmpPeerFactory.setFile(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
            }
            File file = m_configFile;
            return file;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(SnmpPeerFactory singleton) {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            m_singleton = singleton;
            m_loaded = true;
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        try {
            SnmpPeerFactory.getReadLock().lock();
            if (m_config == null) {
                SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
                if (requestedSnmpVersion == -1) {
                    agentConfig.setVersion(1);
                } else {
                    agentConfig.setVersion(requestedSnmpVersion);
                }
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
            block6: for (Definition def : m_config.getDefinitionCollection()) {
                for (String saddr : def.getSpecificCollection()) {
                    try {
                        InetAddress addr = InetAddressUtils.addr((String)saddr);
                        if (addr == null || !addr.equals(agentConfig.getAddress())) continue;
                        this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                        break block6;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.debug("Error while reading SNMP config <specific> tag: {}", (Object)saddr, (Object)e);
                    }
                }
                ByteArrayComparator comparator = new ByteArrayComparator();
                for (Range rng : def.getRangeCollection()) {
                    byte[] addr = agentConfig.getAddress().getAddress();
                    byte[] begin = InetAddressUtils.toIpAddrBytes((String)rng.getBegin());
                    byte[] end = InetAddressUtils.toIpAddrBytes((String)rng.getEnd());
                    boolean inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])begin, (byte[])end);
                    if (comparator.compare(begin, end) <= 0) {
                        inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])begin, (byte[])end);
                    } else {
                        LOG.warn("{} has an 'end' that is earlier than its 'beginning'!", (Object)rng);
                        inRange = InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])end, (byte[])begin);
                    }
                    if (!inRange) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block6;
                }
                for (String ipMatch : def.getIpMatchCollection()) {
                    if (!IPLike.matches((InetAddress)agentInetAddress, (String)ipMatch)) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block6;
                }
            }
            SnmpAgentConfig snmpAgentConfig = agentConfig;
            return snmpAgentConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.determineVersion(def, requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(this.determineSecurityLevel(def));
        agentConfig.setSecurityName(this.determineSecurityName(def));
        agentConfig.setAuthProtocol(this.determineAuthProtocol(def));
        agentConfig.setAuthPassPhrase(this.determineAuthPassPhrase(def));
        agentConfig.setPrivPassPhrase(this.determinePrivPassPhrase(def));
        agentConfig.setPrivProtocol(this.determinePrivProtocol(def));
        agentConfig.setReadCommunity(this.determineReadCommunity(def));
        agentConfig.setWriteCommunity(this.determineWriteCommunity(def));
        agentConfig.setContextName(this.determineContextName(def));
        agentConfig.setEngineId(this.determineEngineId(def));
        agentConfig.setContextEngineId(this.determineContextEngineId(def));
        agentConfig.setEnterpriseId(this.determineEnterpriseId(def));
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(this.determinePort(def));
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setMaxRequestSize(this.determineMaxRequestSize(def));
        agentConfig.setMaxVarsPerPdu(this.determineMaxVarsPerPdu(def));
        agentConfig.setMaxRepetitions(this.determineMaxRepetitions(def));
        InetAddress proxyHost = this.determineProxyHost(def);
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(this.determineProxyHost(def));
        }
    }

    private int determineMaxRepetitions(Definition def) {
        return !def.hasMaxRepetitions() ? (!m_config.hasMaxRepetitions() ? 2 : m_config.getMaxRepetitions()) : def.getMaxRepetitions();
    }

    private InetAddress determineProxyHost(Definition def) {
        String address;
        InetAddress inetAddr = null;
        Object object = def.getProxyHost() == null ? (m_config.getProxyHost() == null ? null : m_config.getProxyHost()) : (address = def.getProxyHost());
        if (address != null) {
            try {
                inetAddr = InetAddressUtils.addr((String)address);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Error while reading SNMP config proxy host: {}", (Object)address, (Object)e);
            }
        }
        return inetAddr;
    }

    private int determineMaxVarsPerPdu(Definition def) {
        return !def.hasMaxVarsPerPdu() ? (!m_config.hasMaxVarsPerPdu() ? 10 : m_config.getMaxVarsPerPdu()) : def.getMaxVarsPerPdu();
    }

    private String determineReadCommunity(Definition def) {
        return def.getReadCommunity() == null ? (m_config.getReadCommunity() == null ? "public" : m_config.getReadCommunity()) : def.getReadCommunity();
    }

    private String determineWriteCommunity(Definition def) {
        return def.getWriteCommunity() == null ? (m_config.getWriteCommunity() == null ? "private" : m_config.getWriteCommunity()) : def.getWriteCommunity();
    }

    private int determineMaxRequestSize(Definition def) {
        return !def.hasMaxRequestSize() ? (!m_config.hasMaxRequestSize() ? 65535 : m_config.getMaxRequestSize()) : def.getMaxRequestSize();
    }

    private String determineSecurityName(Definition def) {
        String securityName;
        String string = securityName = def.getSecurityName() == null ? m_config.getSecurityName() : def.getSecurityName();
        if (securityName == null) {
            return "opennmsUser";
        }
        return securityName;
    }

    private String determineAuthProtocol(Definition def) {
        String authProtocol;
        String string = authProtocol = def.getAuthProtocol() == null ? m_config.getAuthProtocol() : def.getAuthProtocol();
        if (authProtocol == null && this.determineAuthPassPhrase(def) != null) {
            return "MD5";
        }
        return authProtocol;
    }

    private String determineAuthPassPhrase(Definition def) {
        String authPassPhrase = def.getAuthPassphrase() == null ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        return authPassPhrase;
    }

    private String determinePrivPassPhrase(Definition def) {
        String privPassPhrase = def.getPrivacyPassphrase() == null ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        return privPassPhrase;
    }

    private String determinePrivProtocol(Definition def) {
        String authPrivProtocol;
        String string = authPrivProtocol = def.getPrivacyProtocol() == null ? m_config.getPrivacyProtocol() : def.getPrivacyProtocol();
        if (authPrivProtocol == null && this.determinePrivPassPhrase(def) != null) {
            return "DES";
        }
        return authPrivProtocol;
    }

    private int determineSecurityLevel(Definition def) {
        String privPassPhrase;
        if (def.hasSecurityLevel()) {
            return def.getSecurityLevel();
        }
        if (m_config.hasSecurityLevel()) {
            return m_config.getSecurityLevel();
        }
        int securityLevel = 1;
        String authPassPhrase = StringUtils.isBlank((String)def.getAuthPassphrase()) ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        String string = privPassPhrase = StringUtils.isBlank((String)def.getPrivacyPassphrase()) ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        securityLevel = authPassPhrase == null ? 1 : (privPassPhrase == null ? 2 : 3);
        return securityLevel;
    }

    private String determineContextName(Definition def) {
        String contextName;
        String string = contextName = def.getContextName() == null ? m_config.getContextName() : def.getContextName();
        if (contextName == null) {
            return SnmpAgentConfig.DEFAULT_CONTEXT_NAME;
        }
        return contextName;
    }

    private String determineEngineId(Definition def) {
        String engineId;
        String string = engineId = def.getEngineId() == null ? m_config.getEngineId() : def.getEngineId();
        if (engineId == null) {
            return SnmpAgentConfig.DEFAULT_ENGINE_ID;
        }
        return engineId;
    }

    private String determineContextEngineId(Definition def) {
        String contextEngineId;
        String string = contextEngineId = def.getContextEngineId() == null ? m_config.getContextEngineId() : def.getContextEngineId();
        if (contextEngineId == null) {
            return SnmpAgentConfig.DEFAULT_CONTEXT_ENGINE_ID;
        }
        return contextEngineId;
    }

    private int determinePort(Definition def) {
        return def.getPort() == 0 ? (m_config.getPort() == 0 ? 161 : m_config.getPort()) : def.getPort();
    }

    private String determineEnterpriseId(Definition def) {
        if (def.getEnterpriseId() != null) {
            return def.getEnterpriseId();
        }
        if (m_config.getEnterpriseId() != null) {
            return m_config.getEnterpriseId();
        }
        return null;
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? 3000L : (long)m_config.getTimeout().intValue()) : (long)def.getTimeout().intValue();
    }

    private int determineRetries(Definition def) {
        boolean retries = true;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? 1 : m_config.getRetry()) : def.getRetry();
    }

    private int determineVersion(Definition def, int requestedSnmpVersion) {
        int version = 1;
        String cfgVersion = "v1";
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (m_config.getVersion() == null) {
                    return version;
                }
                cfgVersion = m_config.getVersion();
            } else {
                cfgVersion = def.getVersion();
            }
        } else {
            return requestedSnmpVersion;
        }
        if (cfgVersion.equals("v1")) {
            version = 1;
        } else if (cfgVersion.equals("v2c")) {
            version = 2;
        } else if (cfgVersion.equals("v3")) {
            version = 3;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpConfig getSnmpConfig() {
        try {
            SnmpPeerFactory.getReadLock().lock();
            SnmpConfig snmpConfig = m_config;
            return snmpConfig;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void define(SnmpEventInfo info) {
        try {
            SnmpPeerFactory.getWriteLock().lock();
            SnmpConfigManager mgr = new SnmpConfigManager(m_config);
            mgr.mergeIntoConfig(info.createDef());
        }
        finally {
            SnmpPeerFactory.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshallConfig() {
        try {
            SnmpPeerFactory.getReadLock().lock();
            String marshalledConfig = null;
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                JaxbUtils.marshal((Object)m_config, (Writer)writer);
                marshalledConfig = writer.toString();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            String string = marshalledConfig;
            return string;
        }
        finally {
            SnmpPeerFactory.getReadLock().unlock();
        }
    }

    static {
        m_loaded = false;
    }
}

