/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.RowProcessor;
import org.opennms.core.utils.SingleResultQuerier;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.notifications.Header;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.notifications.Notifications;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.eventd.datablock.EventUtil;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Tticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class NotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    public Notifications m_notifications;
    private Header oldHeader;
    public static final String PARAM_TYPE = "-t";
    public static final String PARAM_DESTINATION = "-d";
    public static final String PARAM_TEXT_MSG = "-tm";
    public static final String PARAM_NUM_MSG = "-nm";
    public static final String PARAM_RESPONSE = "-r";
    public static final String PARAM_NODE = "-nodeid";
    public static final String PARAM_INTERFACE = "-interface";
    public static final String PARAM_SERVICE = "-service";
    public static final String PARAM_SUBJECT = "-subject";
    public static final String PARAM_EMAIL = "-email";
    public static final String PARAM_PAGER_EMAIL = "-pemail";
    public static final String PARAM_XMPP_ADDRESS = "-xmpp";
    public static final String PARAM_TEXT_PAGER_PIN = "-tp";
    public static final String PARAM_NUM_PAGER_PIN = "-np";
    public static final String PARAM_WORK_PHONE = "-wphone";
    public static final String PARAM_HOME_PHONE = "-hphone";
    public static final String PARAM_MOBILE_PHONE = "-mphone";
    public static final String PARAM_TUI_PIN = "-tuipin";
    public static final String PARAM_MICROBLOG_USERNAME = "-ublog";
    NotifdConfigManager m_configManager;
    private DataSource m_dataSource;
    private static final String NOTIFD_EXPANSION_PARM = "%(noticeid)%";
    private static RE m_expandRE;

    public static String expandNotifParms(String input, Map<String, String> paramMap) {
        String expanded = input;
        if (m_expandRE.match(expanded)) {
            String key = m_expandRE.getParen(1);
            Assert.isTrue((boolean)"noticeid".equals(key));
            String replace = paramMap.get(key);
            if (replace != null) {
                expanded = m_expandRE.subst(expanded, replace);
            }
        }
        return expanded;
    }

    protected NotificationManager(NotifdConfigManager configManager, DataSource dcf) {
        this.m_configManager = configManager;
        this.m_dataSource = dcf;
    }

    @Deprecated
    public synchronized void parseXML(Reader reader) throws MarshalException, ValidationException {
        this.m_notifications = (Notifications)CastorUtils.unmarshal(Notifications.class, (Reader)reader, (boolean)true);
        this.oldHeader = this.m_notifications.getHeader();
    }

    public synchronized void parseXML(InputStream stream) throws MarshalException, ValidationException {
        this.m_notifications = (Notifications)CastorUtils.unmarshal(Notifications.class, (InputStream)stream, (boolean)true);
        this.oldHeader = this.m_notifications.getHeader();
    }

    public boolean hasUei(String uei) throws IOException, MarshalException, ValidationException {
        this.update();
        for (Notification notif : this.m_notifications.getNotificationCollection()) {
            if (uei.equals(notif.getUei()) || "MATCH-ANY-UEI".equals(notif.getUei())) {
                return true;
            }
            if (notif.getUei().charAt(0) != '~' || !uei.matches(notif.getUei().substring(1))) continue;
            return true;
        }
        return false;
    }

    public Notification[] getNotifForEvent(Event event) throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<Notification> notifList = new ArrayList<Notification>();
        boolean matchAll = this.getConfigManager().getNotificationMatch();
        if (event == null) {
            LOG.warn("unable to get notification for null event!");
            return null;
        }
        if (event.getLogmsg() != null && !event.getLogmsg().getNotify().booleanValue()) {
            LOG.debug("Event {} is configured to suppress notifications.", (Object)event.getUei());
            return null;
        }
        for (Notification curNotif : this.m_notifications.getNotificationCollection()) {
            LOG.debug("Checking {} against {}", (Object)curNotif.getUei(), (Object)event.getUei());
            if (!event.getUei().equals(curNotif.getUei()) && !"MATCH-ANY-UEI".equals(curNotif.getUei())) {
                if (curNotif.getUei().charAt(0) == '~') {
                    if (!event.getUei().matches(curNotif.getUei().substring(1))) {
                        LOG.debug("Notification regex {} failed to match event UEI: {}", (Object)event.getUei(), (Object)curNotif.getUei());
                        continue;
                    }
                } else {
                    LOG.debug("Event UEI {} did not match {}", (Object)curNotif.getUei(), (Object)event.getUei());
                    continue;
                }
            }
            LOG.debug("Checking event severity: {} against notification severity: {}", (Object)curNotif.getEventSeverity(), (Object)event.getSeverity());
            if (curNotif.getEventSeverity() != null && !event.getSeverity().toLowerCase().matches(curNotif.getEventSeverity().toLowerCase())) {
                LOG.debug("Event severity: {} did not match notification severity: {}", (Object)curNotif.getEventSeverity(), (Object)event.getSeverity());
                continue;
            }
            if (curNotif.getStatus().equals("on")) {
                if (this.nodeInterfaceServiceValid(curNotif, event)) {
                    boolean parmsmatched = this.getConfigManager().matchNotificationParameters(event, curNotif);
                    if (!parmsmatched) {
                        LOG.debug("Event {} did not match parameters for notice {}", (Object)curNotif.getName(), (Object)event.getUei());
                        continue;
                    }
                    notifList.add(curNotif);
                    LOG.debug("Event {} matched notice {}", (Object)curNotif.getName(), (Object)event.getUei());
                    if (matchAll) continue;
                    break;
                }
                LOG.debug("Node/interface/service combination in the event was invalid");
                continue;
            }
            LOG.debug("Current notification is turned off.");
        }
        if (!notifList.isEmpty()) {
            return notifList.toArray(new Notification[0]);
        }
        return null;
    }

    protected NotifdConfigManager getConfigManager() {
        return this.m_configManager;
    }

    protected boolean nodeInterfaceServiceValid(Notification notif, Event event) {
        Assert.notNull((Object)notif, (String)"notif argument must not be null");
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)notif.getRule(), (String)"getRule() on notif argument must not return null");
        if (event.getNodeid() == 0L && event.getInterface() == null && event.getService() == null) {
            if ("MATCH-ANY-UEI".equals(notif.getUei())) {
                return "ipaddr != '0.0.0.0'".equals(notif.getRule().toLowerCase()) || "ipaddr iplike *.*.*.*".equals(notif.getRule().toLowerCase());
            }
            return true;
        }
        StringBuffer constraints = new StringBuffer();
        if (event.getNodeid() != 0L) {
            constraints.append(" & (nodeId == " + event.getNodeid() + ")");
        }
        if (event.getInterface() != null && !"0.0.0.0".equals(event.getInterface())) {
            constraints.append(" & (ipAddr == '" + event.getInterface() + "')");
            if (event.getService() != null) {
                constraints.append(" & (serviceName == '" + event.getService() + "')");
            }
        }
        String rule = "((" + notif.getRule() + ")" + constraints + ")";
        return this.isRuleMatchingFilter(notif, rule);
    }

    private boolean isRuleMatchingFilter(Notification notif, String rule) {
        try {
            return FilterDaoFactory.getInstance().isRuleMatching(rule);
        }
        catch (FilterParseException e) {
            LOG.error("Invalid filter rule for notification {}: {}", new Object[]{notif.getName(), notif.getRule(), e});
            throw e;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public int getNoticeId() throws SQLException, IOException, MarshalException, ValidationException {
        return this.getNxtId(this.m_configManager.getNextNotifIdSql());
    }

    public int getUserNotifId() throws SQLException, IOException, MarshalException, ValidationException {
        return this.getNxtId(this.m_configManager.getNextUserNotifIdSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNxtId(String sql) throws SQLException {
        int id = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet results = stmt.executeQuery(sql);
            results.next();
            id = results.getInt(1);
            stmt.close();
            results.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noticeOutstanding(int noticeId) throws IOException, MarshalException, ValidationException {
        boolean outstanding = false;
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement(this.getConfigManager().getConfiguration().getOutstandingNoticesSql());
            d.watch((Object)statement);
            statement.setInt(1, noticeId);
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            int count = 0;
            while (results.next()) {
                ++count;
            }
            if (count == 0) {
                outstanding = true;
            }
        }
        catch (SQLException e) {
            LOG.error("Error getting notice status", (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> acknowledgeNotice(Event event, String uei, String[] matchList) throws SQLException, IOException, MarshalException, ValidationException {
        Connection connection = null;
        LinkedList<Integer> notifIDs = new LinkedList<Integer>();
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            int eventID = 0;
            boolean wasAcked = false;
            StringBuffer sql = new StringBuffer("SELECT eventid FROM notifications WHERE eventuei=? ");
            for (int i = 0; i < matchList.length; ++i) {
                sql.append("AND ").append(matchList[i]).append("=? ");
            }
            sql.append("ORDER BY eventid desc limit 1");
            PreparedStatement statement = connection.prepareStatement(sql.toString());
            d.watch((Object)statement);
            statement.setString(1, uei);
            for (int i = 0; i < matchList.length; ++i) {
                if (matchList[i].equals("nodeid")) {
                    statement.setLong(i + 2, event.getNodeid());
                }
                if (matchList[i].equals("interfaceid")) {
                    statement.setString(i + 2, event.getInterface());
                }
                if (!matchList[i].equals("serviceid")) continue;
                statement.setInt(i + 2, this.getServiceId(event.getService()));
            }
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            if (results != null && results.next()) {
                eventID = results.getInt(1);
                LOG.debug("EventID for notice(s) to be acked: {}", (Object)eventID);
                sql = new StringBuffer("SELECT notifyid, answeredby, respondtime FROM notifications WHERE eventID=?");
                statement = connection.prepareStatement(sql.toString());
                statement.setInt(1, eventID);
                results = statement.executeQuery();
                if (results != null) {
                    while (results.next()) {
                        int notifID = results.getInt(1);
                        String ansBy = results.getString(2);
                        Timestamp ts = results.getTimestamp(3);
                        if (ansBy == null) {
                            ansBy = "auto-acknowledged";
                            ts = new Timestamp(new Date().getTime());
                        } else {
                            if (ansBy.indexOf("auto-acknowledged") > -1) {
                                LOG.debug("Notice has previously been auto-acknowledged. Skipping...");
                                continue;
                            }
                            wasAcked = true;
                            ansBy = ansBy + "/auto-acknowledged";
                        }
                        LOG.debug("Matching DOWN notifyID = {}, was acked by user = {}, ansBy = {}", new Object[]{ansBy, notifID, wasAcked});
                        PreparedStatement update = connection.prepareStatement(this.getConfigManager().getConfiguration().getAcknowledgeUpdateSql());
                        d.watch((Object)update);
                        update.setString(1, ansBy);
                        update.setTimestamp(2, ts);
                        update.setInt(3, notifID);
                        update.executeUpdate();
                        update.close();
                        if (wasAcked) {
                            notifIDs.add(-1 * notifID);
                            continue;
                        }
                        notifIDs.add(notifID);
                    }
                }
            } else {
                LOG.debug("No matching DOWN eventID found");
            }
        }
        finally {
            d.cleanUp();
        }
        return notifIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getActiveNodes() throws SQLException {
        String NODE_QUERY = "SELECT   n.nodeid FROM     node n WHERE    n.nodetype != 'D' ORDER BY n.nodelabel";
        Connection connection = null;
        ArrayList<Integer> allNodes = new ArrayList<Integer>();
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            Statement stmt = connection.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(NODE_QUERY);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    int nodeID = rset.getInt(1);
                    allNodes.add(nodeID);
                }
            }
            ArrayList<Integer> arrayList = allNodes;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceNoticeStatus(String nodeID, String ipaddr, String service) throws SQLException {
        String notify = "Y";
        String query = "SELECT notify FROM ifservices, service WHERE nodeid=? AND ipaddr=? AND ifservices.serviceid=service.serviceid AND service.servicename=?";
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT notify FROM ifservices, service WHERE nodeid=? AND ipaddr=? AND ifservices.serviceid=service.serviceid AND service.servicename=?");
            d.watch((Object)statement);
            statement.setInt(1, Integer.parseInt(nodeID));
            statement.setString(2, ipaddr);
            statement.setString(3, service);
            ResultSet rs = statement.executeQuery();
            d.watch((Object)rs);
            if (rs.next() && rs.getString("notify") != null && (notify = rs.getString("notify")) == null) {
                notify = "Y";
            }
            String string = notify;
            return string;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNoticeWithUserInfo(String userId, int noticeId, String media, String contactInfo, String autoNotify) throws SQLException, MarshalException, ValidationException, IOException {
        if (noticeId < 0) {
            return;
        }
        int userNotifId = this.getUserNotifId();
        LOG.debug("updating usersnotified: ID = {} User = {}, notice ID = {}, conctactinfo = {}, media = {}, autoNotify = {}", new Object[]{autoNotify, userNotifId, userId, noticeId, contactInfo, media});
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement insert = connection.prepareStatement("INSERT INTO usersNotified (id, userid, notifyid, notifytime, media, contactinfo, autonotify) values (?,?,?,?,?,?,?)");
            d.watch((Object)insert);
            insert.setInt(1, userNotifId);
            insert.setString(2, userId);
            insert.setInt(3, noticeId);
            insert.setTimestamp(4, new Timestamp(new Date().getTime()));
            insert.setString(5, media);
            insert.setString(6, contactInfo);
            insert.setString(7, autoNotify);
            insert.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNotice(int notifyId, Map<String, String> params, String queueID, Notification notification) throws SQLException {
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("INSERT INTO notifications (textmsg, numericmsg, notifyid, pagetime, nodeid, interfaceid, serviceid, eventid, eventuei, subject, queueID, notifConfigName) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            d.watch((Object)statement);
            String textMsg = params.get(PARAM_TEXT_MSG);
            if (textMsg != null && textMsg.length() > 4000) {
                LOG.warn("textmsg too long, it will be truncated");
                textMsg = textMsg.substring(0, 4000);
            }
            statement.setString(1, textMsg);
            String numMsg = params.get(PARAM_NUM_MSG);
            if (numMsg != null && numMsg.length() > 256) {
                LOG.warn("numericmsg too long, it will be truncated");
                numMsg = numMsg.substring(0, 256);
            }
            statement.setString(2, numMsg);
            statement.setInt(3, notifyId);
            statement.setTimestamp(4, new Timestamp(new Date().getTime()));
            String node = params.get(PARAM_NODE);
            if (!(node == null || node.trim().equals("") || node.equalsIgnoreCase("null") || node.equalsIgnoreCase("%nodeid%"))) {
                statement.setInt(5, Integer.parseInt(node));
            } else {
                statement.setNull(5, 4);
            }
            String ipaddr = params.get(PARAM_INTERFACE);
            if (!(ipaddr == null || ipaddr.trim().equals("") || ipaddr.equalsIgnoreCase("null") || ipaddr.equalsIgnoreCase("%interface%"))) {
                statement.setString(6, ipaddr);
            } else {
                statement.setString(6, null);
            }
            String service = params.get(PARAM_SERVICE);
            if (!(service == null || service.trim().equals("") || service.equalsIgnoreCase("null") || service.equalsIgnoreCase("%service%"))) {
                statement.setInt(7, this.getServiceId(service));
            } else {
                statement.setNull(7, 4);
            }
            String eventID = params.get("eventID");
            if (!(eventID == null || eventID.trim().equals("") || eventID.trim().equals("0") || eventID.equalsIgnoreCase("null") || eventID.equalsIgnoreCase("%eventid%"))) {
                statement.setInt(8, Integer.parseInt(eventID));
            } else {
                statement.setNull(8, 4);
            }
            statement.setString(9, params.get("eventUEI"));
            statement.setString(10, params.get(PARAM_SUBJECT));
            statement.setString(11, queueID);
            statement.setString(12, notification.getName());
            statement.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getServiceId(String service) throws SQLException {
        int serviceID = 0;
        Connection connection = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            connection = this.getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT serviceID from service where serviceName = ?");
            d.watch((Object)statement);
            statement.setString(1, service);
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            results.next();
            int n = serviceID = results.getInt(1);
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    public Map<String, Notification> getNotifications() throws IOException, MarshalException, ValidationException {
        this.update();
        HashMap<String, Notification> newMap = new HashMap<String, Notification>();
        Notification[] notices = this.m_notifications.getNotification();
        for (int i = 0; i < notices.length; ++i) {
            newMap.put(notices[i].getName(), notices[i]);
        }
        return Collections.unmodifiableMap(newMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServiceNames() throws SQLException {
        Connection connection = null;
        ArrayList<String> services = new ArrayList<String>();
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement();
            ResultSet rset = stmt.executeQuery("SELECT servicename FROM service");
            if (rset != null) {
                while (rset.next()) {
                    services.add(rset.getString(1));
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return services;
    }

    public Notification getNotification(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.getNotifications().get(name);
    }

    public List<String> getNotificationNames() throws IOException, MarshalException, ValidationException {
        this.update();
        ArrayList<String> notificationNames = new ArrayList<String>();
        for (Notification curNotif : this.m_notifications.getNotificationCollection()) {
            notificationNames.add(curNotif.getName());
        }
        return notificationNames;
    }

    public synchronized void removeNotification(String name) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(name));
        this.saveCurrent();
    }

    public synchronized void addNotification(Notification notice) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.removeNotification(this.getNotification(notice.getName()));
        this.m_notifications.addNotification(notice);
        this.saveCurrent();
    }

    public synchronized void replaceNotification(String oldName, Notification newNotice) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        Notification notice = this.getNotification(oldName);
        if (notice != null) {
            notice.setWriteable(newNotice.getWriteable());
            notice.setName(newNotice.getName());
            notice.setDescription(newNotice.getDescription());
            notice.setUei(newNotice.getUei());
            notice.setRule(newNotice.getRule());
            notice.setDestinationPath(newNotice.getDestinationPath());
            notice.setNoticeQueue(newNotice.getNoticeQueue());
            notice.setTextMessage(newNotice.getTextMessage());
            notice.setSubject(newNotice.getSubject());
            notice.setNumericMessage(newNotice.getNumericMessage());
            notice.setStatus(newNotice.getStatus());
            notice.setVarbind(newNotice.getVarbind());
            notice.getParameterCollection().clear();
            for (Parameter parameter : newNotice.getParameterCollection()) {
                Parameter newParam = new Parameter();
                newParam.setName(parameter.getName());
                newParam.setValue(parameter.getValue());
                notice.addParameter(newParam);
            }
            this.saveCurrent();
        } else {
            this.addNotification(newNotice);
        }
    }

    public synchronized void updateStatus(String name, String status) throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        if (!"on".equals(status) && !"off".equals(status)) {
            throw new IllegalArgumentException("Status must be on|off, not " + status);
        }
        Notification notice = this.getNotification(name);
        notice.setStatus(status);
        this.saveCurrent();
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        this.m_notifications.setHeader(this.rebuildHeader());
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_notifications, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        this.saveXML(xmlString);
        this.update();
    }

    protected abstract void saveXML(String var1) throws IOException;

    private Header rebuildHeader() {
        Header header = this.oldHeader;
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        return header;
    }

    public abstract void update() throws IOException, MarshalException, ValidationException;

    public Map<String, String> rebuildParameterMap(final int notifId, final String resolutionPrefix, final boolean skipNumericPrefix) throws Exception {
        final HashMap<String, String> parmMap = new HashMap<String, String>();
        Querier querier = new Querier(this.m_dataSource, "select notifications.*, service.* from notifications left outer join service on notifications.serviceID = service.serviceID  where notifyId = ?"){

            public void processRow(ResultSet rs) throws SQLException {
                parmMap.put(NotificationManager.PARAM_TEXT_MSG, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("textMsg"));
                if (skipNumericPrefix) {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, rs.getString("numericMsg"));
                } else {
                    parmMap.put(NotificationManager.PARAM_NUM_MSG, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("numericMsg"));
                }
                parmMap.put(NotificationManager.PARAM_SUBJECT, NotificationManager.expandNotifParms(resolutionPrefix, Collections.singletonMap("noticeid", String.valueOf(notifId))) + rs.getString("subject"));
                parmMap.put(NotificationManager.PARAM_NODE, rs.getString("nodeID"));
                parmMap.put(NotificationManager.PARAM_INTERFACE, rs.getString("interfaceID"));
                parmMap.put(NotificationManager.PARAM_SERVICE, rs.getString("serviceName"));
                parmMap.put("noticeid", rs.getString("notifyID"));
                parmMap.put("eventID", rs.getString("eventID"));
                parmMap.put("eventUEI", rs.getString("eventUEI"));
                Notification notification = null;
                try {
                    notification = NotificationManager.this.getNotification(rs.getObject("notifConfigName").toString());
                }
                catch (MarshalException e) {
                }
                catch (ValidationException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (notification != null) {
                    NotificationManager.addNotificationParams(parmMap, notification);
                }
            }
        };
        querier.execute(new Object[]{notifId});
        return parmMap;
    }

    public static void addNotificationParams(Map<String, String> paramMap, Notification notification) {
        List parameters = notification.getParameterCollection();
        for (Parameter parameter : parameters) {
            paramMap.put(parameter.getName(), parameter.getValue());
        }
    }

    public void forEachUserNotification(int notifId, RowProcessor rp) {
        Querier querier = new Querier(this.m_dataSource, "select * from usersNotified where notifyId = ? order by notifytime", rp);
        querier.execute(new Object[]{notifId});
    }

    public String getQueueForNotification(int notifId) {
        SingleResultQuerier querier = new SingleResultQuerier(this.m_dataSource, "select queueID from notifications where notifyId = ?");
        querier.execute(new Object[]{notifId});
        return (String)querier.getResult();
    }

    public static void expandMapValues(Map<String, String> map, Event event) {
        for (String key : map.keySet()) {
            String expandedValue;
            String mapValue = map.get(key);
            if (mapValue == null || (expandedValue = EventUtil.expandParms((String)map.get(key), (Event)event)) == null) continue;
            map.put(key, expandedValue);
        }
    }

    public Event getEvent(int eventid) {
        final Event event = new Event();
        Querier querier = new Querier(this.m_dataSource, "select * from events where eventid = ?", new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                event.setDbid(Integer.valueOf(rs.getInt("eventid")));
                event.setUei(rs.getString("eventuei"));
                event.setNodeid(Long.valueOf(rs.getLong("nodeid")));
                event.setTime(rs.getString("eventtime"));
                event.setHost(rs.getString("eventhost"));
                event.setInterface(rs.getString("ipaddr"));
                event.setSnmphost(rs.getString("eventsnmphost"));
                event.setService(this.getServiceName(rs.getInt("serviceid")));
                event.setCreationTime(rs.getString("eventcreatetime"));
                event.setSeverity(rs.getString("eventseverity"));
                event.setPathoutage(rs.getString("eventpathoutage"));
                Tticket tticket = new Tticket();
                tticket.setContent(rs.getString("eventtticket"));
                tticket.setState(rs.getString("eventtticketstate"));
                event.setTticket(tticket);
                event.setSource(rs.getString("eventsource"));
            }

            private String getServiceName(int serviceid) {
                SingleResultQuerier querier = new SingleResultQuerier(NotificationManager.this.m_dataSource, "select servicename from service where serviceid = ?");
                return (String)querier.getResult();
            }
        });
        querier.execute(new Object[]{eventid});
        return event;
    }

    static {
        try {
            m_expandRE = new RE(NOTIFD_EXPANSION_PARM);
        }
        catch (RESyntaxException e) {
            LOG.error("failed to compile RE {}", (Object)NOTIFD_EXPANSION_PARM, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

