/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.LinkdConfigManager;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkdConfigFactory
extends LinkdConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(LinkdConfigFactory.class);
    private static LinkdConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public LinkdConfigFactory(long currentVersion, InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            LinkdConfigFactory.setInstance(new LinkdConfigFactory(cfgFile.lastModified(), stream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    @Override
    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
            LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
        }
    }

    public static synchronized LinkdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(LinkdConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws IOException, MarshalException, ValidationException {
        block7: {
            this.getWriteLock().lock();
            try {
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
                if (cfgFile.lastModified() <= this.m_currentVersion) break block7;
                this.m_currentVersion = cfgFile.lastModified();
                LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(cfgFile);
                    this.reloadXML(stream);
                }
                finally {
                    if (stream != null) {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                }
                LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        this.getWriteLock().lock();
        try {
            this.updateUrlIpMap();
            this.updatePackageIpListMap();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (InputStream)stream);
            this.updateUrlIpMap();
            this.updatePackageIpListMap();
            this.updateVlanClassNames();
            this.updateIpRouteClassNames();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws MarshalException, IOException, ValidationException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)m_config, (Writer)stringWriter);
            this.saveXml(stringWriter.toString());
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            m_config = (LinkdConfiguration)CastorUtils.unmarshal(LinkdConfiguration.class, (Reader)reader);
            this.updateUrlIpMap();
            this.updatePackageIpListMap();
            this.updateVlanClassNames();
            this.updateIpRouteClassNames();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

