/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.eventd.EventdConfiguration;

public class EventdConfigManager {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected EventdConfiguration m_config;

    protected EventdConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.m_config = (EventdConfiguration)CastorUtils.unmarshal(EventdConfiguration.class, (InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventdConfigManager(String configFile) throws FileNotFoundException, MarshalException, ValidationException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.m_config = (EventdConfiguration)CastorUtils.unmarshal(EventdConfiguration.class, (InputStream)stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTCPIpAddress() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getTCPAddress();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTCPPort() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getTCPPort();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUDPIpAddress() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getUDPAddress();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUDPPort() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getUDPPort();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReceivers() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getReceivers();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueLength() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.hasQueueLength() ? this.m_config.getQueueLength() : Integer.MAX_VALUE;
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSocketSoTimeoutRequired() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getSocketSoTimeoutRequired();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSocketSoTimeoutPeriod() {
        try {
            this.getReadLock().lock();
            int n = this.m_config.getSocketSoTimeoutPeriod();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSocketSoTimeoutPeriod() {
        try {
            this.getReadLock().lock();
            boolean bl = this.m_config.hasSocketSoTimeoutPeriod();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGetNextEventID() {
        try {
            this.getReadLock().lock();
            String string = this.m_config.getGetNextEventID();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

