/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.BaseConnectionFactory;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;

public class TomcatJdbcPoolConnectionFactory
extends BaseConnectionFactory {
    private DataSource m_dataSource;

    public TomcatJdbcPoolConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(stream, dsName);
    }

    public TomcatJdbcPoolConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(configFile, dsName);
    }

    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_dataSource = new DataSource();
        this.m_dataSource.setName(dataSource.getName());
        this.m_dataSource.setDriverClassName(dataSource.getClassName());
        this.m_dataSource.setUrl(dataSource.getUrl());
        this.m_dataSource.setUsername(dataSource.getUserName());
        this.m_dataSource.setPassword(dataSource.getPassword());
        Properties properties = new Properties();
        for (Param parameter : dataSource.getParamCollection()) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        if (!properties.isEmpty()) {
            this.m_dataSource.setDbProperties(properties);
        }
        this.m_dataSource.setAccessToUnderlyingConnectionAllowed(true);
        this.m_dataSource.setFairQueue(true);
    }

    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public String getUrl() {
        return this.m_dataSource.getUrl();
    }

    public void setUrl(String url) {
        TomcatJdbcPoolConnectionFactory.validateJdbcUrl((String)url);
        this.m_dataSource.setUrl(url);
    }

    public String getUser() {
        return this.m_dataSource.getUsername();
    }

    public void setUser(String user) {
        this.m_dataSource.setUsername(user);
    }

    public javax.sql.DataSource getDataSource() {
        return this.m_dataSource;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_dataSource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_dataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    public void close() throws SQLException {
        super.close();
        LogUtils.infof((Object)((Object)this), (String)"Closing Tomcat DBCP pool.", (Object[])new Object[0]);
        this.m_dataSource.close();
    }

    public void setIdleTimeout(int idleTimeout) {
        LogUtils.warnf((Object)((Object)this), (String)"Tomcat DBCP doesn't have the concept of a generic idle timeout.  Ignoring.", (Object[])new Object[0]);
    }

    public void setMinPool(int minPool) {
        this.m_dataSource.setInitialSize(minPool);
    }

    public void setMaxPool(int maxPool) {
        LogUtils.warnf((Object)((Object)this), (String)"Tomcat DBCP doesn't have the concept of a maximum pool.  Ignoring.", (Object[])new Object[0]);
    }

    public void setMaxSize(int maxSize) {
        this.m_dataSource.setMaxActive(maxSize);
    }
}

