/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.AbstractTimeIntervalSequence;
import org.opennms.core.utils.OwnedInterval;
import org.opennms.core.utils.OwnedIntervalSequence;
import org.opennms.core.utils.Owner;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Groupinfo;
import org.opennms.netmgt.config.groups.Groups;
import org.opennms.netmgt.config.groups.Header;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Roles;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;

public abstract class GroupManager {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static HashMap<String, List<DutySchedule>> m_dutySchedules;
    private Map<String, Group> m_groups;
    private Map<String, Role> m_roles;
    private Header m_oldHeader;

    protected synchronized void parseXml(InputStream stream) throws MarshalException, ValidationException {
        Groupinfo groupinfo = (Groupinfo)CastorUtils.unmarshal(Groupinfo.class, (InputStream)stream);
        this.initializeGroupsAndRoles(groupinfo);
    }

    private void initializeGroupsAndRoles(Groupinfo groupinfo) {
        Groups groups = groupinfo.getGroups();
        this.m_groups = new LinkedHashMap<String, Group>();
        this.m_oldHeader = groupinfo.getHeader();
        for (Group curGroup : groups.getGroupCollection()) {
            this.m_groups.put(curGroup.getName(), curGroup);
        }
        GroupManager.buildDutySchedules(this.m_groups);
        Roles roles = groupinfo.getRoles();
        this.m_roles = new LinkedHashMap<String, Role>();
        if (roles != null) {
            for (Role role : roles.getRoleCollection()) {
                this.m_roles.put(role.getName(), role);
            }
        }
    }

    public void setGroups(Map<String, Group> grp) {
        this.m_groups = grp;
    }

    public Map<String, Group> getGroups() throws IOException, MarshalException, ValidationException {
        this.update();
        return Collections.unmodifiableMap(this.m_groups);
    }

    public OnmsGroupList getOnmsGroupList() throws MarshalException, ValidationException, IOException {
        OnmsGroupList list = new OnmsGroupList();
        for (String name : this.getGroupNames()) {
            list.add((Object)this.getOnmsGroup(name));
        }
        list.setTotalCount(list.getCount());
        return list;
    }

    public OnmsGroup getOnmsGroup(String groupName) throws MarshalException, ValidationException, IOException {
        Group castorGroup = this.getGroup(groupName);
        if (castorGroup == null) {
            return null;
        }
        OnmsGroup group = new OnmsGroup(groupName);
        group.setComments(castorGroup.getComments());
        group.setUsers(castorGroup.getUserCollection());
        return group;
    }

    public synchronized void save(OnmsGroup group) throws Exception {
        Group castorGroup = this.getGroup(group.getName());
        if (castorGroup == null) {
            castorGroup = new Group();
            castorGroup.setName(group.getName());
        }
        castorGroup.setComments(group.getComments());
        castorGroup.setUser(group.getUsers().toArray(EMPTY_STRING_ARRAY));
        this.saveGroup(group.getName(), castorGroup);
    }

    public abstract void update() throws IOException, MarshalException, ValidationException;

    public boolean hasGroup(String groupName) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_groups.containsKey(groupName);
    }

    public List<String> getGroupNames() throws IOException, MarshalException, ValidationException {
        this.update();
        return new ArrayList<String>(this.m_groups.keySet());
    }

    public Group getGroup(String name) throws IOException, MarshalException, ValidationException {
        this.update();
        return this.m_groups.get(name);
    }

    public synchronized void saveGroups() throws Exception {
        Header header = this.m_oldHeader;
        if (header != null) {
            header.setCreated(EventConstants.formatToString((Date)new Date()));
        }
        Groups groups = new Groups();
        for (Group grp : this.m_groups.values()) {
            groups.addGroup(grp);
        }
        Roles roles = new Roles();
        for (Role role : this.m_roles.values()) {
            roles.addRole(role);
        }
        Groupinfo groupinfo = new Groupinfo();
        groupinfo.setGroups(groups);
        if (roles.getRoleCount() > 0) {
            groupinfo.setRoles(roles);
        }
        groupinfo.setHeader(header);
        this.m_oldHeader = header;
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)groupinfo, (Writer)stringWriter);
        String data = stringWriter.toString();
        this.saveXml(data);
    }

    private static void buildDutySchedules(Map<String, Group> groups) {
        m_dutySchedules = new HashMap();
        for (String key : groups.keySet()) {
            Group curGroup = groups.get(key);
            if (curGroup.getDutyScheduleCount() <= 0) continue;
            ArrayList<DutySchedule> dutyList = new ArrayList<DutySchedule>();
            for (String duty : curGroup.getDutyScheduleCollection()) {
                dutyList.add(new DutySchedule(duty));
            }
            m_dutySchedules.put(key, dutyList);
        }
    }

    public boolean isGroupOnDuty(String group, Calendar time) throws IOException, MarshalException, ValidationException {
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return true;
        }
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (DutySchedule curSchedule : dutySchedules) {
            if (!curSchedule.isInSchedule(time)) continue;
            return true;
        }
        return false;
    }

    public long groupNextOnDuty(String group, Calendar time) throws IOException, MarshalException, ValidationException {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        long next = -1L;
        this.update();
        if (!m_dutySchedules.containsKey(group)) {
            return 0L;
        }
        List<DutySchedule> dutySchedules = m_dutySchedules.get(group);
        for (int i = 0; i < dutySchedules.size(); ++i) {
            DutySchedule curSchedule = dutySchedules.get(i);
            long tempnext = curSchedule.nextInSchedule(time);
            if (tempnext >= next && next != -1L) continue;
            if (log.isDebugEnabled()) {
                log.debug("isGroupOnDuty: On duty in " + tempnext + " millisec from schedule " + i);
            }
            next = tempnext;
        }
        return next;
    }

    protected abstract void saveXml(String var1) throws IOException;

    public synchronized void saveGroup(String name, Group details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("GroupFactory:saveGroup  null");
        }
        this.m_groups.put(name, details);
        this.saveGroups();
    }

    public void saveRole(Role role) throws Exception {
        this.m_roles.put(role.getName(), role);
        this.saveGroups();
    }

    public synchronized void deleteUser(String name) throws Exception {
        if (name != null && !name.equals("")) {
            for (Group group : this.m_groups.values()) {
                group.removeUser(name);
            }
            for (Role role : this.m_roles.values()) {
                Iterator s = role.getScheduleCollection().iterator();
                while (s.hasNext()) {
                    Schedule sched = (Schedule)s.next();
                    if (!name.equals(sched.getName())) continue;
                    s.remove();
                }
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user name:" + name);
        }
        this.saveGroups();
    }

    public synchronized void deleteGroup(String name) throws Exception {
        if (name != null && !name.equals("")) {
            if (!this.m_groups.containsKey(name)) {
                throw new Exception("GroupFactory:delete Group doesnt exist:" + name);
            }
        } else {
            throw new Exception("GroupFactory:delete Invalid user group:" + name);
        }
        this.m_groups.remove(name);
        this.saveGroups();
    }

    public void deleteRole(String name) throws Exception {
        if (name != null && !name.equals("")) {
            if (!this.m_roles.containsKey(name)) {
                throw new Exception("GroupFacotry:deleteRole Role doesn't exist: " + name);
            }
        } else {
            throw new Exception("GroupFactory:deleteRole Invalid role name: " + name);
        }
        this.m_roles.remove(name);
        this.saveGroups();
    }

    public synchronized void renameGroup(String oldName, String newName) throws Exception {
        if (oldName != null && !oldName.equals("")) {
            if (!this.m_groups.containsKey(oldName)) {
                throw new Exception("GroupFactory.renameGroup: Group doesn't exist: " + oldName);
            }
            Group grp = this.m_groups.remove(oldName);
            grp.setName(newName);
            this.m_groups.put(newName, grp);
            this.saveGroups();
        }
    }

    public synchronized void renameUser(String oldName, String newName) throws Exception {
        if (oldName == null || newName == null || oldName == "" || newName == "") {
            throw new Exception("Group Factory: Rename user.. no value ");
        }
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        for (Group group : this.m_groups.values()) {
            ListIterator<String> userList = group.getUserCollection().listIterator();
            while (userList.hasNext()) {
                String name = (String)userList.next();
                if (!name.equals(oldName)) continue;
                userList.set(newName);
            }
            map.put(group.getName(), group);
        }
        this.m_groups.clear();
        this.m_groups.putAll(map);
        for (Role role : this.m_roles.values()) {
            for (Schedule sched : role.getScheduleCollection()) {
                if (!oldName.equals(sched.getName())) continue;
                sched.setName(newName);
            }
        }
        this.saveGroups();
    }

    public String[] getRoleNames() {
        return this.m_roles.keySet().toArray(new String[this.m_roles.keySet().size()]);
    }

    public Collection<Role> getRoles() {
        return this.m_roles.values();
    }

    public Role getRole(String roleName) {
        return this.m_roles.get(roleName);
    }

    public boolean userHasRole(String userId, String roleid) throws MarshalException, ValidationException, IOException {
        this.update();
        for (Schedule sched : this.getRole(roleid).getScheduleCollection()) {
            if (!userId.equals(sched.getName())) continue;
            return true;
        }
        return false;
    }

    public List<Schedule> getSchedulesForRoleAt(String roleId, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Schedule sched : this.getRole(roleId).getScheduleCollection()) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
            schedules.add(sched);
        }
        return schedules;
    }

    public List<Schedule> getUserSchedulesForRole(String userId, String roleId) throws MarshalException, ValidationException, IOException {
        this.update();
        ArrayList<Schedule> scheds = new ArrayList<Schedule>();
        for (Schedule sched : this.getRole(roleId).getScheduleCollection()) {
            if (!userId.equals(sched.getName())) continue;
            scheds.add(sched);
        }
        return scheds;
    }

    public boolean isUserScheduledForRole(String userId, String roleId, Date time) throws MarshalException, ValidationException, IOException {
        this.update();
        for (Schedule sched : this.getUserSchedulesForRole(userId, roleId)) {
            if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
            return true;
        }
        Role role = this.getRole(roleId);
        if (userId.equals(role.getSupervisor())) {
            for (Schedule sched : role.getScheduleCollection()) {
                if (!BasicScheduleUtils.isTimeInSchedule(time, BasicScheduleUtils.getGroupSchedule(sched))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OwnedIntervalSequence getRoleScheduleEntries(String roleid, Date start, Date end) throws MarshalException, ValidationException, IOException {
        this.update();
        OwnedIntervalSequence schedEntries = new OwnedIntervalSequence();
        Role role = this.getRole(roleid);
        for (int i = 0; i < role.getScheduleCount(); ++i) {
            Schedule sched = role.getSchedule(i);
            Owner owner = new Owner(roleid, sched.getName(), i);
            schedEntries.addAll((AbstractTimeIntervalSequence)BasicScheduleUtils.getIntervalsCovering(start, end, BasicScheduleUtils.getGroupSchedule(sched), owner));
        }
        OwnedIntervalSequence defaultEntries = new OwnedIntervalSequence(new OwnedInterval(start, end));
        defaultEntries.removeAll((AbstractTimeIntervalSequence)schedEntries);
        Owner supervisor = new Owner(roleid, role.getSupervisor());
        for (OwnedInterval interval : defaultEntries) {
            interval.addOwner(supervisor);
        }
        schedEntries.addAll((AbstractTimeIntervalSequence)defaultEntries);
        return schedEntries;
    }

    public List<Group> findGroupsForUser(String user) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.m_groups.values()) {
            if (!group.getUserCollection().contains(user)) continue;
            groups.add(group);
        }
        return groups;
    }
}

