/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.CollectdConfig;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.springframework.util.Assert;

public class CollectdConfigFactory {
    static final String SELECT_METHOD_MIN = "min";
    private static CollectdConfigFactory m_singleton = null;
    private CollectdConfig m_collectdConfig;

    public synchronized void rebuildPackageIpListMap() {
        this.m_collectdConfig.rebuildPackageIpListMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectdConfigFactory(String configFile, String localServer, boolean verifyServer) throws IOException, MarshalException, ValidationException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            CollectdConfiguration config = (CollectdConfiguration)CastorUtils.unmarshal(CollectdConfiguration.class, (InputStream)stream);
            this.m_collectdConfig = new CollectdConfig(config, localServer, verifyServer);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public CollectdConfigFactory(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        CollectdConfiguration config = (CollectdConfiguration)CastorUtils.unmarshal(CollectdConfiguration.class, (InputStream)stream);
        this.m_collectdConfig = new CollectdConfig(config, localServer, verifyServer);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (CollectdConfigFactory.isInitialized()) {
            return;
        }
        OpennmsServerConfigFactory.init();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
        CollectdConfigFactory.log().debug("init: config file path: " + cfgFile.getPath());
        CollectdConfigFactory.setInstance(new CollectdConfigFactory(cfgFile.getPath(), OpennmsServerConfigFactory.getInstance().getServerName(), OpennmsServerConfigFactory.getInstance().verifyServer()));
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        CollectdConfigFactory.init();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
        CollectdConfiguration config = this.m_collectdConfig.getConfig();
        CastorUtils.marshalViaString((Object)config, (File)cfgFile);
        CollectdConfigFactory.reload();
    }

    public static synchronized CollectdConfigFactory getInstance() {
        Assert.state((boolean)CollectdConfigFactory.isInitialized(), (String)"The factory has not been initialized");
        return m_singleton;
    }

    public static synchronized void setInstance(CollectdConfigFactory instance) {
        m_singleton = instance;
    }

    public CollectdConfig getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public CollectdPackage getPackage(String name) {
        return this.m_collectdConfig.getPackage(name);
    }

    public synchronized boolean packageExists(String name) {
        return this.m_collectdConfig.getPackage(name) != null;
    }

    public boolean domainExists(String name) {
        return this.m_collectdConfig.domainExists(name);
    }

    public boolean isServiceCollectionEnabled(String ipAddr, String svcName) {
        return this.m_collectdConfig.isServiceCollectionEnabled(ipAddr, svcName);
    }

    private static boolean isInitialized() {
        return m_singleton != null;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(CollectdConfigFactory.class);
    }
}

