/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.tester;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.tester.ConfigTesterDataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ConfigTester
implements ApplicationContextAware {
    private ApplicationContext m_context;
    private Map<String, String> m_configs;

    public Map<String, String> getConfigs() {
        return this.m_configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.m_configs = configs;
    }

    public ApplicationContext getApplicationContext() {
        return this.m_context;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.m_context = context;
    }

    public void testConfig(String name, boolean ignoreUnknown) {
        this.checkConfigNameValid(name, ignoreUnknown);
        this.m_context.getBean(this.m_configs.get(name));
    }

    private void checkConfigNameValid(String name, boolean ignoreUnknown) {
        if (!this.m_configs.containsKey(name)) {
            if (ignoreUnknown) {
                System.err.println("Unknown configuration: " + name + "... skipping.");
            } else {
                throw new IllegalArgumentException("config '" + name + "' is not a known config name");
            }
        }
    }

    public static void main(String[] argv) {
        CommandLine line;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        Logger.getLogger((String)"org.springframework").setLevel(Level.WARN);
        ApplicationContext context = (ApplicationContext)BeanUtils.getFactory((String)"configTesterContext", ClassPathXmlApplicationContext.class);
        ConfigTester tester = (ConfigTester)context.getBean("configTester", ConfigTester.class);
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "print this help and exit");
        options.addOption("a", "all", false, "check all supported configuration files");
        options.addOption("l", "list", false, "list supported configuration files and exit");
        options.addOption("v", "verbose", false, "list each configuration file as it is tested");
        options.addOption("i", "ignore-unknown", false, "ignore unknown configuration files and continue processing");
        try {
            line = parser.parse(options, argv, false);
        }
        catch (ParseException e) {
            System.err.println("Invalid usage: " + e.getMessage());
            System.err.println("Run 'config-tester -h' for help.");
            System.exit(1);
            return;
        }
        boolean ignoreUnknown = line.hasOption("i");
        if (line.hasOption('l') || line.hasOption('h') || line.hasOption('a')) {
            if (line.getArgList().size() > 0) {
                System.err.println("Invalid usage: No arguments allowed when using the '-a', '-h', or '-l' options.");
                System.err.println("Run 'config-tester -h' for help.");
                System.exit(1);
            }
        } else if (line.getArgs().length == 0) {
            System.err.println("Invalid usage: too few arguments.  Use the '-h' option for help.");
            System.exit(1);
        }
        boolean verbose = line.hasOption('v');
        DataSourceFactory.setInstance((DataSource)new ConfigTesterDataSource());
        if (line.hasOption('l')) {
            System.out.println("Supported configuration files: ");
            for (String configFile : tester.getConfigs().keySet()) {
                System.out.println("    " + configFile);
            }
            System.out.println("Note: not all OpenNMS configuration files are currently supported.");
        } else if (line.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("config-tester -a\nOR: config-tester [config files]\nOR: config-tester -l\nOR: config-tester -h", options);
        } else if (line.hasOption('a')) {
            for (String configFile : tester.getConfigs().keySet()) {
                tester.testConfig(configFile, verbose, ignoreUnknown);
            }
        } else {
            for (String configFile : line.getArgs()) {
                tester.testConfig(configFile, verbose, ignoreUnknown);
            }
        }
    }

    private void testConfig(String configFile, boolean verbose, boolean ignoreUnknown) {
        if (verbose) {
            System.out.print("Testing " + configFile + " ... ");
        }
        long start = System.currentTimeMillis();
        this.testConfig(configFile, ignoreUnknown);
        long end = System.currentTimeMillis();
        if (verbose) {
            System.out.println("OK (" + (float)(end - start) / 1000.0f + "s)");
        }
    }
}

