/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="sendmail-host", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class SendmailHost
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="host")
    private String m_host;
    @XmlAttribute(name="port")
    private Integer m_port;

    public String getHost() {
        return this.m_host == null ? "127.0.0.1" : this.m_host;
    }

    public void setHost(String host) {
        this.m_host = ConfigUtils.normalizeString(host);
    }

    public Integer getPort() {
        return this.m_port == null ? 25 : this.m_port;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public int hashCode() {
        return Objects.hash(this.m_host, this.m_port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailHost) {
            SendmailHost that = (SendmailHost)obj;
            return Objects.equals(this.m_host, that.m_host) && Objects.equals(this.m_port, that.m_port);
        }
        return false;
    }
}

