/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.translator.Mapping;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="event-translation-spec")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="translator-configuration.xsd")
public class EventTranslationSpec
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="uei", required=true)
    private String m_uei;
    @XmlElementWrapper(name="mappings", required=true)
    @XmlElement(name="mapping")
    private List<Mapping> m_mappings = new ArrayList<Mapping>();

    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String uei) {
        this.m_uei = ConfigUtils.assertNotEmpty(uei, "uei");
    }

    public List<Mapping> getMappings() {
        return this.m_mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        if (mappings == this.m_mappings) {
            return;
        }
        this.m_mappings.clear();
        if (mappings != null) {
            this.m_mappings.addAll(mappings);
        }
    }

    public void addMapping(Mapping mapping) {
        this.m_mappings.add(mapping);
    }

    public boolean removeMapping(Mapping mapping) {
        return this.m_mappings.remove(mapping);
    }

    public int hashCode() {
        return Objects.hash(this.m_uei, this.m_mappings);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventTranslationSpec) {
            EventTranslationSpec that = (EventTranslationSpec)obj;
            return Objects.equals(this.m_uei, that.m_uei) && Objects.equals(this.m_mappings, that.m_mappings);
        }
        return false;
    }
}

